/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.tools.json;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.jooq.tools.json.JSONArray;
import org.jooq.tools.json.JSONObject;
import org.jooq.tools.json.JSONParser;
import org.jooq.tools.json.ParseException;

public class JSONValue {
    public static void writeJSONString(Object value, Writer out) throws IOException {
        if (value == null) {
            out.write("null");
            return;
        }
        if (value instanceof String) {
            out.write(34);
            out.write(JSONValue.escape((String)value));
            out.write(34);
            return;
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Number) {
            out.write(value.toString());
            return;
        }
        if (value instanceof Boolean) {
            out.write(value.toString());
            return;
        }
        if (value instanceof Map) {
            JSONObject.writeJSONString((Map)value, out);
            return;
        }
        if (value instanceof List) {
            JSONArray.writeJSONString((List)value, out);
            return;
        }
        out.write(34);
        out.write(JSONValue.escape(value.toString()));
        out.write(34);
    }

    public static String toJSONString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof String) {
            return "\"" + JSONValue.escape((String)value) + "\"";
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                return "null";
            }
            return value.toString();
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof Boolean) {
            return value.toString();
        }
        if (value instanceof Map) {
            return JSONObject.toJSONString((Map)value);
        }
        if (value instanceof List) {
            return JSONArray.toJSONString((List)value);
        }
        return "\"" + JSONValue.escape(value.toString()) + "\"";
    }

    public static String escape(String s2) {
        if (s2 == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        JSONValue.escape(s2, sb);
        return sb.toString();
    }

    static void escape(String s2, StringBuffer sb) {
        block10: for (int i2 = 0; i2 < s2.length(); ++i2) {
            char ch2 = s2.charAt(i2);
            switch (ch2) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch2 >= '\u0000' && ch2 <= '\u001f' || ch2 >= '\u007f' && ch2 <= '\u009f' || ch2 >= '\u2000' && ch2 <= '\u20ff') {
                        String ss = Integer.toHexString(ch2);
                        sb.append("\\u");
                        for (int k2 = 0; k2 < 4 - ss.length(); ++k2) {
                            sb.append('0');
                        }
                        sb.append(ss.toUpperCase());
                        continue block10;
                    }
                    sb.append(ch2);
                }
            }
        }
    }

    public static Object parseWithException(Reader in2) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in2);
    }

    public static Object parseWithException(String s2) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s2);
    }
}

