/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.meta;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.jooq.Condition;
import org.jooq.Configuration;
import org.jooq.DSLContext;
import org.jooq.ExecuteContext;
import org.jooq.Field;
import org.jooq.Log;
import org.jooq.Meta;
import org.jooq.Name;
import org.jooq.Param;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.SQLDialect;
import org.jooq.Schema;
import org.jooq.Select;
import org.jooq.Table;
import org.jooq.TableField;
import org.jooq.TableLike;
import org.jooq.TableOptions;
import org.jooq.conf.ParseWithMetaLookups;
import org.jooq.conf.RenderQuotedNames;
import org.jooq.exception.DataAccessException;
import org.jooq.exception.DetachedException;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteListener;
import org.jooq.impl.SQLDataType;
import org.jooq.meta.AbstractRoutineDefinition;
import org.jooq.meta.AbstractTableDefinition;
import org.jooq.meta.AbstractTypedElementDefinition;
import org.jooq.meta.ArrayDefinition;
import org.jooq.meta.AttributeDefinition;
import org.jooq.meta.CatalogDefinition;
import org.jooq.meta.CatalogVersionProvider;
import org.jooq.meta.CheckConstraintDefinition;
import org.jooq.meta.ColumnDefinition;
import org.jooq.meta.DataTypeDefinition;
import org.jooq.meta.Database;
import org.jooq.meta.DefaultColumnDefinition;
import org.jooq.meta.DefaultDataTypeDefinition;
import org.jooq.meta.DefaultEmbeddableDefinition;
import org.jooq.meta.DefaultEnumDefinition;
import org.jooq.meta.DefaultOrderProvider;
import org.jooq.meta.DefaultParameterDefinition;
import org.jooq.meta.DefaultRelations;
import org.jooq.meta.DefaultUniqueKeyDefinition;
import org.jooq.meta.Definition;
import org.jooq.meta.DomainDefinition;
import org.jooq.meta.EmbeddableDefinition;
import org.jooq.meta.EnumDefinition;
import org.jooq.meta.ForeignKeyDefinition;
import org.jooq.meta.IdentityDefinition;
import org.jooq.meta.InOutDefinition;
import org.jooq.meta.IndexDefinition;
import org.jooq.meta.PackageDefinition;
import org.jooq.meta.ParameterDefinition;
import org.jooq.meta.Patterns;
import org.jooq.meta.Relations;
import org.jooq.meta.RoutineDefinition;
import org.jooq.meta.SchemaDefinition;
import org.jooq.meta.SchemaVersionProvider;
import org.jooq.meta.SequenceDefinition;
import org.jooq.meta.SortedList;
import org.jooq.meta.Statements;
import org.jooq.meta.TableDefinition;
import org.jooq.meta.TableElementDefinition;
import org.jooq.meta.UDTDefinition;
import org.jooq.meta.UniqueKeyDefinition;
import org.jooq.meta.jaxb.CatalogMappingType;
import org.jooq.meta.jaxb.CommentType;
import org.jooq.meta.jaxb.CustomType;
import org.jooq.meta.jaxb.EmbeddableDefinitionType;
import org.jooq.meta.jaxb.EmbeddableField;
import org.jooq.meta.jaxb.EnumType;
import org.jooq.meta.jaxb.ForcedType;
import org.jooq.meta.jaxb.ForcedTypeObjectType;
import org.jooq.meta.jaxb.Nullability;
import org.jooq.meta.jaxb.OnError;
import org.jooq.meta.jaxb.RegexFlag;
import org.jooq.meta.jaxb.SchemaMappingType;
import org.jooq.meta.jaxb.SyntheticForeignKeyType;
import org.jooq.meta.jaxb.SyntheticIdentityType;
import org.jooq.meta.jaxb.SyntheticObjectsType;
import org.jooq.meta.jaxb.SyntheticPrimaryKeyType;
import org.jooq.meta.jaxb.SyntheticReadonlyColumnType;
import org.jooq.meta.jaxb.SyntheticReadonlyRowidType;
import org.jooq.meta.jaxb.SyntheticUniqueKeyType;
import org.jooq.meta.jaxb.SyntheticViewType;
import org.jooq.tools.JooqLogger;
import org.jooq.tools.StopWatch;
import org.jooq.tools.StringUtils;
import org.jooq.tools.csv.CSVReader;

public abstract class AbstractDatabase
implements Database {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractDatabase.class);
    private static final Set<SQLDialect> NO_SUPPORT_SCHEMATA = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.FIREBIRD, SQLDialect.SQLITE);
    private Properties properties;
    private String basedir;
    private SQLDialect dialect;
    private Connection connection;
    private boolean regexMatchesPartialQualification;
    private boolean sqlMatchesPartialQualification;
    private OnError onError = OnError.FAIL;
    private List<Database.Filter> filters;
    private String[] excludes;
    private String[] includes = new String[]{".*"};
    private boolean includeExcludeColumns = false;
    private boolean includeExcludePackageRoutines = false;
    private boolean includeInvisibleColumns = true;
    private boolean includeTables = true;
    private boolean includeEmbeddables = true;
    private boolean includeRoutines = true;
    private boolean includeTriggerRoutines = false;
    private boolean includePackages = true;
    private boolean includePackageRoutines = true;
    private boolean includePackageUDTs = true;
    private boolean includePackageConstants = true;
    private boolean includeUDTs = true;
    private boolean includeDomains = true;
    private boolean includeSequences = true;
    private boolean includeIndexes = true;
    private boolean includeCheckConstraints = true;
    private boolean includeSystemTables = false;
    private boolean includeSystemIndexes = false;
    private boolean includeSystemCheckConstraints = false;
    private boolean includeSystemSequences = false;
    private boolean includeSystemUDTs = false;
    private boolean includePrimaryKeys = true;
    private boolean includeUniqueKeys = true;
    private boolean includeForeignKeys = true;
    private boolean forceIntegerTypesOnZeroScaleDecimals = true;
    private String[] recordVersionFields;
    private String[] recordTimestampFields;
    private String embeddablePrimaryKeys = null;
    private String embeddableUniqueKeys = null;
    private String embeddableDomains = null;
    private boolean readonlyIdentities = false;
    private boolean readonlyComputedColumns = true;
    private boolean readonlyNonUpdatableColumns = true;
    private boolean supportsUnsignedTypes;
    private boolean integerDisplayWidths;
    private boolean ignoreProcedureReturnValues;
    private boolean dateAsTimestamp;
    private boolean javaTimeTypes = true;
    private List<CatalogMappingType> configuredCatalogs = new ArrayList<CatalogMappingType>();
    private List<SchemaMappingType> configuredSchemata = new ArrayList<SchemaMappingType>();
    private List<CustomType> configuredCustomTypes = new ArrayList<CustomType>();
    private List<EnumType> configuredEnumTypes = new ArrayList<EnumType>();
    private List<ForcedType> configuredForcedTypes;
    private Set<ForcedType> unusedForcedTypes = new HashSet<ForcedType>();
    private List<EmbeddableDefinitionType> configuredEmbeddables = new ArrayList<EmbeddableDefinitionType>();
    private Set<EmbeddableDefinitionType> unusedEmbeddables = new HashSet<EmbeddableDefinitionType>();
    private List<CommentType> configuredComments = new ArrayList<CommentType>();
    private Set<CommentType> unusedComments = new HashSet<CommentType>();
    private List<SyntheticReadonlyColumnType> configuredSyntheticReadonlyColumns = new ArrayList<SyntheticReadonlyColumnType>();
    private Set<SyntheticReadonlyColumnType> unusedSyntheticReadonlyColumns = new HashSet<SyntheticReadonlyColumnType>();
    private List<SyntheticReadonlyRowidType> configuredSyntheticReadonlyRowids = new ArrayList<SyntheticReadonlyRowidType>();
    private Set<SyntheticReadonlyRowidType> unusedSyntheticReadonlyRowids = new HashSet<SyntheticReadonlyRowidType>();
    private List<SyntheticIdentityType> configuredSyntheticIdentities = new ArrayList<SyntheticIdentityType>();
    private Set<SyntheticIdentityType> unusedSyntheticIdentities = new HashSet<SyntheticIdentityType>();
    private List<SyntheticPrimaryKeyType> configuredSyntheticPrimaryKeys = new ArrayList<SyntheticPrimaryKeyType>();
    private Set<SyntheticPrimaryKeyType> unusedSyntheticPrimaryKeys = new HashSet<SyntheticPrimaryKeyType>();
    private List<SyntheticUniqueKeyType> configuredSyntheticUniqueKeys = new ArrayList<SyntheticUniqueKeyType>();
    private Set<SyntheticUniqueKeyType> unusedSyntheticUniqueKeys = new HashSet<SyntheticUniqueKeyType>();
    private List<SyntheticForeignKeyType> configuredSyntheticForeignKeys = new ArrayList<SyntheticForeignKeyType>();
    private Set<SyntheticForeignKeyType> unusedSyntheticForeignKeys = new HashSet<SyntheticForeignKeyType>();
    private List<SyntheticViewType> configuredSyntheticViews = new ArrayList<SyntheticViewType>();
    private Set<SyntheticViewType> unusedSyntheticViews = new HashSet<SyntheticViewType>();
    private SchemaVersionProvider schemaVersionProvider;
    private CatalogVersionProvider catalogVersionProvider;
    private Comparator<Definition> orderProvider;
    private boolean includeRelations = true;
    private boolean tableValuedFunctions = true;
    private int logSlowQueriesAfterSeconds;
    private int logSlowResultsAfterSeconds;
    private Map<Definition, String> sources;
    private List<String> inputCatalogs;
    private List<String> inputSchemata;
    private Map<String, List<String>> inputSchemataPerCatalog;
    private List<CatalogDefinition> catalogs;
    private List<SchemaDefinition> schemata;
    private List<SequenceDefinition> sequences;
    private List<IdentityDefinition> identities;
    private List<IndexDefinition> indexes;
    private List<UniqueKeyDefinition> primaryKeys;
    private List<UniqueKeyDefinition> uniqueKeys;
    private List<UniqueKeyDefinition> keys;
    private List<ForeignKeyDefinition> foreignKeys;
    private List<CheckConstraintDefinition> checkConstraints;
    private List<TableDefinition> tables;
    private List<EmbeddableDefinition> embeddables;
    private List<EnumDefinition> enums;
    private List<DomainDefinition> domains;
    private List<UDTDefinition> udts;
    private List<ArrayDefinition> arrays;
    private List<RoutineDefinition> routines;
    private List<PackageDefinition> packages;
    private Relations relations;
    private transient Map<SchemaDefinition, List<SequenceDefinition>> sequencesBySchema;
    private transient Map<SchemaDefinition, List<IdentityDefinition>> identitiesBySchema;
    private transient Map<SchemaDefinition, List<IndexDefinition>> indexesBySchema;
    private transient Map<TableDefinition, List<IndexDefinition>> indexesByTable;
    private transient Map<SchemaDefinition, List<UniqueKeyDefinition>> primaryKeysBySchema;
    private transient Map<SchemaDefinition, List<UniqueKeyDefinition>> uniqueKeysBySchema;
    private transient Map<SchemaDefinition, List<UniqueKeyDefinition>> keysBySchema;
    private transient Map<SchemaDefinition, List<ForeignKeyDefinition>> foreignKeysBySchema;
    private transient Map<SchemaDefinition, List<CheckConstraintDefinition>> checkConstraintsBySchema;
    private transient Map<SchemaDefinition, List<TableDefinition>> tablesBySchema;
    private transient Map<SchemaDefinition, List<EmbeddableDefinition>> embeddablesByDefiningSchema;
    private transient Map<TableDefinition, List<EmbeddableDefinition>> embeddablesByDefiningTable;
    private transient Map<TableDefinition, List<EmbeddableDefinition>> embeddablesByReferencingTable;
    private transient Map<SchemaDefinition, List<EnumDefinition>> enumsBySchema;
    private transient Map<SchemaDefinition, List<DomainDefinition>> domainsBySchema;
    private transient Map<SchemaDefinition, List<UDTDefinition>> udtsBySchema;
    private transient Map<PackageDefinition, List<UDTDefinition>> udtsByPackage;
    private transient Map<SchemaDefinition, List<ArrayDefinition>> arraysBySchema;
    private transient Map<SchemaDefinition, List<RoutineDefinition>> routinesBySchema;
    private transient Map<SchemaDefinition, List<PackageDefinition>> packagesBySchema;
    private transient boolean initialised;
    private final List<Definition> all;
    private final List<Definition> included;
    private final List<Definition> excluded;
    private final Map<Table<?>, Boolean> existTables = new HashMap();
    private final Map<TableField<?, ?>, Boolean> existFields = new HashMap();
    private final Patterns patterns = new Patterns();
    private final Statements statements = new Statements();

    protected AbstractDatabase() {
        this.filters = new ArrayList<Database.Filter>();
        this.all = new ArrayList<Definition>();
        this.included = new ArrayList<Definition>();
        this.excluded = new ArrayList<Definition>();
        this.orderProvider = new DefaultOrderProvider();
    }

    @Override
    public final SQLDialect getDialect() {
        if (this.dialect == null) {
            this.dialect = this.create().configuration().dialect();
        }
        return this.dialect;
    }

    @Override
    public final void setDialect(SQLDialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public final void setConnection(Connection connection) {
        this.connection = connection;
        this.statements.dslContext(this.create());
    }

    @Override
    public final Connection getConnection() {
        return this.connection;
    }

    @Override
    public final DSLContext create() {
        return this.create(false);
    }

    protected final DSLContext create(boolean muteExceptions) {
        Configuration configuration;
        try {
            configuration = this.create0().configuration();
        }
        catch (NoSuchFieldError e2) {
            log.error("NoSuchFieldError may happen when the jOOQ Open Source Edition (Maven groupId 'org.jooq') is used with a commercial SQLDialect. Use an appropriate groupId instead: 'org.jooq.trial', 'org.jooq.trial-java-8', 'org.jooq.trial-java-11', 'org.jooq.pro', 'org.jooq.pro-java-8', or 'org.jooq.pro-java-11'. See also: https://www.jooq.org/doc/latest/manual/getting-started/tutorials/jooq-in-7-steps/jooq-in-7-steps-step1/");
            throw e2;
        }
        configuration.settings().setRenderQuotedNames(this.getRenderQuotedNames());
        configuration.settings().setNamePathSeparator("__");
        if (muteExceptions) {
            return DSL.using(configuration);
        }
        DefaultExecuteListener newListener = new DefaultExecuteListener(){

            @Override
            public void start(ExecuteContext ctx) {
                if (!AbstractDatabase.this.initialised) {
                    try {
                        DSL.using(configuration).selectOne().fetch();
                    }
                    catch (DataAccessException e2) {
                        log.debug((Object)"Error while running init query", e2);
                    }
                    AbstractDatabase.this.initialised = true;
                }
            }

            @Override
            public void executeStart(ExecuteContext ctx) {
                ctx.data("org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.execute", new StopWatch());
            }

            @Override
            public void executeEnd(ExecuteContext ctx) {
                int s2 = AbstractDatabase.this.getLogSlowQueriesAfterSeconds();
                if (s2 <= 0) {
                    return;
                }
                StopWatch watch = (StopWatch)ctx.data("org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.execute");
                if (watch.split() > TimeUnit.SECONDS.toNanos(s2)) {
                    watch.splitWarn("Slow SQL");
                    log.warn("Slow SQL", "jOOQ Meta executed a slow query (slower than " + s2 + " seconds, configured by configuration/generator/database/logSlowQueriesAfterSeconds)\n\nIf you think this is a bug in jOOQ, please report it here: https://github.com/jOOQ/jOOQ/issues/new\n\n```sql\n" + this.formatted(ctx.query()) + "```\n", new SQLPerformanceWarning());
                }
            }

            @Override
            public void fetchStart(ExecuteContext ctx) {
                ctx.data("org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.fetch", new StopWatch());
            }

            @Override
            public void fetchEnd(ExecuteContext ctx) {
                int s2 = AbstractDatabase.this.getLogSlowResultsAfterSeconds();
                if (s2 <= 0) {
                    return;
                }
                StopWatch watch = (StopWatch)ctx.data("org.jooq.meta.AbstractDatabase.SQLPerformanceWarning.fetch");
                if (watch.split() > TimeUnit.SECONDS.toNanos(s2)) {
                    watch.splitWarn("Slow Result Fetching");
                    log.warn("Slow Result Fetching", "jOOQ Meta fetched a slow result (slower than " + s2 + " seconds, configured by configuration/generator/database/logSlowResultsAfterSeconds)\n\nIf you think this is a bug in jOOQ, please report it here: https://github.com/jOOQ/jOOQ/issues/new\n\n```sql\n" + this.formatted(ctx.query()) + "```\n", new SQLPerformanceWarning());
                }
            }

            @Override
            public void exception(ExecuteContext ctx) {
                log.warn((Object)"SQL exception", "Exception while executing meta query: " + (ctx.sqlException() != null ? ctx.sqlException().getMessage() : (ctx.exception() != null ? ctx.exception().getMessage() : "No exception available")) + "\n\nIf you think this is a bug in jOOQ, please report it here: https://github.com/jOOQ/jOOQ/issues/new\n\nNote you can mute some exceptions using the configuration/onError flag\n\n```sql\n" + this.formatted(ctx.query()) + "```\n");
            }

            private String formatted(Query query) {
                return configuration.deriveSettings(s2 -> s2.withRenderFormatted(true)).dsl().renderInlined(query);
            }

            class SQLPerformanceWarning
            extends Exception {
                SQLPerformanceWarning() {
                }
            }
        };
        return configuration.deriveAppending(newListener).dsl();
    }

    protected RenderQuotedNames getRenderQuotedNames() {
        return RenderQuotedNames.NEVER;
    }

    protected boolean configuredDialectIsNotFamilyAndSupports(List<SQLDialect> d2, Supplier<Boolean> ifFamily) {
        return this.getDialect().isFamily() ? ifFamily.get().booleanValue() : d2.stream().allMatch(this.getDialect()::supports);
    }

    @Override
    public final boolean exists(TableField<?, ?> field) {
        return this.existFields.computeIfAbsent(field, this::exists0);
    }

    protected boolean exists0(TableField<?, ?> field) {
        try {
            this.create(true).select(field).from((TableLike<?>)field.getTable()).where((Condition)DSL.falseCondition()).fetch();
            return true;
        }
        catch (DetachedException e2) {
            return true;
        }
        catch (DataAccessException e3) {
            return false;
        }
    }

    protected final <R extends Record> boolean exists1(TableField<?, ?> find, Table<R> in2, TableField<R, String> schemaQualifier, TableField<R, String> tableQualifier, TableField<R, String> columnQualifier) {
        Condition condition = columnQualifier.eq(find.getName());
        Table<?> table = find.getTable();
        condition = condition.and(tableQualifier.eq(table.getName()));
        Schema schema = table.getSchema();
        if (schema != null) {
            condition = condition.and(schemaQualifier.eq(schema.getName()));
        }
        return this.create().fetchExists((Table<?>)in2, condition);
    }

    @Override
    public final boolean existAll(TableField<?, ?> ... f2) {
        return Stream.of(f2).allMatch(this::exists);
    }

    @Override
    public final boolean exists(Table<?> table) {
        return this.existTables.computeIfAbsent(table, this::exists0);
    }

    protected boolean exists0(Table<?> table) {
        try {
            this.create(true).selectOne().from((TableLike<?>)table).where((Condition)DSL.falseCondition()).fetch();
            return true;
        }
        catch (DataAccessException e2) {
            return false;
        }
    }

    protected final <R extends Record> boolean exists1(Table<?> find, Table<R> in2, TableField<R, String> schemaQualifier, TableField<R, String> tableQualifier) {
        Condition condition = tableQualifier.eq(find.getName());
        Schema schema = find.getSchema();
        if (schema != null) {
            condition = condition.and(schemaQualifier.eq(schema.getName()));
        }
        return this.create().fetchExists((Table<?>)in2, condition);
    }

    @Override
    public final boolean existAll(Table<?> ... t2) {
        return Stream.of(t2).allMatch(this::exists);
    }

    final boolean matches(Pattern pattern, Definition definition) {
        if (pattern == null) {
            return false;
        }
        if (!this.getRegexMatchesPartialQualification()) {
            return pattern.matcher(definition.getName()).matches() || pattern.matcher(definition.getQualifiedName()).matches();
        }
        List<Name> parts = Arrays.asList(definition.getQualifiedNamePart().parts());
        for (int i2 = parts.size() - 1; i2 >= 0; --i2) {
            if (!pattern.matcher(DSL.name(parts.subList(i2, parts.size()).toArray(new Name[0])).unquotedName().toString()).matches()) continue;
            return true;
        }
        return false;
    }

    final boolean matches(Set<?> set, Definition definition) {
        if (set == null) {
            return false;
        }
        if (!this.getSqlMatchesPartialQualification()) {
            return set.contains(definition.getName()) || set.contains(definition.getQualifiedName());
        }
        List<Name> parts = Arrays.asList(definition.getQualifiedNamePart().parts());
        for (int i2 = parts.size() - 1; i2 >= 0; --i2) {
            if (!set.contains(DSL.name(parts.subList(i2, parts.size()).toArray(new Name[0])).unquotedName().toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public final Map<Definition, String> getSources() {
        if (this.sources == null) {
            this.sources = new LinkedHashMap<Definition, String>();
            this.onError(Log.Level.ERROR, "Could not load sources", () -> {
                this.sources = this.getSources0();
                log.info((Object)"Sequences fetched", AbstractDatabase.fetchedSize(this.sources.values(), this.sources.values()));
            });
        }
        return this.sources;
    }

    @Override
    public final List<CatalogDefinition> getCatalogs() {
        if (this.catalogs == null) {
            this.catalogs = new ArrayList<CatalogDefinition>();
            this.onError(Log.Level.ERROR, "Could not load catalogs", () -> {
                this.catalogs = this.sort((List)this.getCatalogs0());
            });
            boolean onlyDefaultCatalog = true;
            Iterator<CatalogDefinition> it2 = this.catalogs.iterator();
            while (it2.hasNext()) {
                CatalogDefinition catalog = it2.next();
                if (!StringUtils.isBlank(catalog.getName())) {
                    onlyDefaultCatalog = false;
                }
                if (this.getInputCatalogs().contains(catalog.getName())) continue;
                it2.remove();
            }
            if (this.catalogs.isEmpty()) {
                if (onlyDefaultCatalog) {
                    log.warn((Object)"No catalogs were loaded", "Your database reported only a default catalog, which was filtered out by your <inputCatalog/> configurations. jOOQ does not support catalogs for all databases, in case of which <inputCatalog/> configurations will not work. E.g. a catalog works on SQL Server to qualify tables as [catalog].[schema].[table]. Perhaps you meant to configure an <inputSchema/> instead?");
                } else {
                    log.warn((Object)"No catalogs were loaded", "Please check your connection settings, and whether your database (and your database version!) is really supported by jOOQ. Also, check the case-sensitivity in your configured <inputCatalog/> elements.");
                }
            }
        }
        return this.catalogs;
    }

    @Override
    public final CatalogDefinition getCatalog(String inputName) {
        for (CatalogDefinition catalog : this.getCatalogs()) {
            if (!catalog.getName().equals(inputName)) continue;
            return catalog;
        }
        return null;
    }

    @Override
    public final List<SchemaDefinition> getSchemata() {
        if (this.schemata == null) {
            this.schemata = new ArrayList<SchemaDefinition>();
            this.onError(Log.Level.ERROR, "Could not load schemata", () -> {
                this.schemata = this.sort((List)this.getSchemata0());
            });
            this.schemata.removeIf(schema -> !this.getInputSchemata().contains(schema.getName()));
            if (this.schemata.isEmpty()) {
                log.warn((Object)"No schemata were loaded", "Please check your connection settings, and whether your database (and your database version!) is really supported by jOOQ. Also, check the case-sensitivity in your configured <inputSchema/> elements : " + this.inputSchemataPerCatalog);
                if (NO_SUPPORT_SCHEMATA.contains((Object)this.getDialect().family())) {
                    log.warn((Object)"No schemata were loaded", "The database you're using (" + this.getClass().getName() + ") does not support schemata. Consider removing all <inputSchema/> and related configuration : " + this.inputSchemataPerCatalog);
                }
            }
        }
        return this.schemata;
    }

    @Override
    public final List<SchemaDefinition> getSchemata(CatalogDefinition catalog) {
        ArrayList<SchemaDefinition> result = new ArrayList<SchemaDefinition>();
        for (SchemaDefinition schema : this.getSchemata()) {
            if (!catalog.equals(schema.getCatalog())) continue;
            result.add(schema);
        }
        return result;
    }

    @Override
    public final SchemaDefinition getSchema(String inputName) {
        for (SchemaDefinition schema : this.getSchemata()) {
            if (!schema.getName().equals(inputName)) continue;
            return schema;
        }
        return null;
    }

    @Override
    public final List<String> getInputCatalogs() {
        if (this.inputCatalogs == null) {
            this.inputCatalogs = new ArrayList<String>();
            if (this.configuredCatalogs.size() == 1 && StringUtils.isBlank(this.configuredCatalogs.get(0).getInputCatalog())) {
                this.onError(Log.Level.ERROR, "Could not load catalogs", () -> {
                    for (CatalogDefinition catalog : this.sort((List)this.getCatalogs0())) {
                        this.inputCatalogs.add(catalog.getName());
                    }
                });
            } else {
                for (CatalogMappingType catalog : this.configuredCatalogs) {
                    this.inputCatalogs.add(catalog.getInputCatalog());
                }
            }
        }
        return this.inputCatalogs;
    }

    @Override
    public final List<String> getInputSchemata() {
        block10: {
            if (this.inputSchemataPerCatalog != null) break block10;
            this.inputSchemata = new ArrayList<String>();
            this.inputSchemataPerCatalog = new LinkedHashMap<String, List<String>>();
            if (this.configuredSchemata.size() == 1 && StringUtils.isBlank(this.configuredSchemata.get(0).getInputSchema())) {
                this.initAllSchemata();
            } else if (this.configuredCatalogs.size() == 1 && StringUtils.isBlank(this.configuredCatalogs.get(0).getInputCatalog()) && this.configuredCatalogs.get(0).getSchemata().size() == 1 && StringUtils.isBlank(this.configuredCatalogs.get(0).getSchemata().get(0).getInputSchema())) {
                this.initAllSchemata();
            } else if (this.configuredCatalogs.isEmpty()) {
                this.inputSchemataPerCatalog.put("", this.inputSchemata);
                for (SchemaMappingType schema : this.configuredSchemata) {
                    this.inputSchemata.add(schema.getInputSchema());
                }
            } else {
                for (CatalogMappingType catalog : this.configuredCatalogs) {
                    for (SchemaMappingType schema : catalog.getSchemata()) {
                        String inputSchema = schema.getInputSchema();
                        this.inputSchemata.add(inputSchema);
                        for (String inputCatalog : this.configuredCatalogs.size() == 1 && StringUtils.isBlank(this.configuredCatalogs.get(0).getInputCatalog()) ? this.getInputCatalogs() : Collections.singletonList(catalog.getInputCatalog())) {
                            this.inputSchemataPerCatalog.computeIfAbsent(inputCatalog, c2 -> new ArrayList()).add(inputSchema);
                        }
                    }
                }
            }
        }
        return this.inputSchemata;
    }

    private void initAllSchemata() {
        this.onError(Log.Level.ERROR, "Could not load schemata", () -> {
            for (SchemaDefinition schema : this.sort((List)this.getSchemata0())) {
                this.inputSchemata.add(schema.getName());
                this.inputSchemataPerCatalog.computeIfAbsent(schema.getCatalog().getName(), c2 -> new ArrayList()).add(schema.getName());
            }
        });
    }

    @Override
    public final List<String> getInputSchemata(CatalogDefinition catalog) {
        return this.getInputSchemata(catalog.getInputName());
    }

    @Override
    public final List<String> getInputSchemata(String catalog) {
        this.getInputSchemata();
        return this.inputSchemataPerCatalog.getOrDefault(catalog, Collections.emptyList());
    }

    @Override
    @Deprecated
    public String getOutputCatalog(String inputCatalog) {
        for (CatalogMappingType catalog : this.configuredCatalogs) {
            if (!inputCatalog.equals(catalog.getInputCatalog())) continue;
            return catalog.getOutputCatalog();
        }
        return inputCatalog;
    }

    @Override
    @Deprecated
    public String getOutputSchema(String inputSchema) {
        for (SchemaMappingType schema : this.configuredSchemata) {
            if (!inputSchema.equals(schema.getInputSchema())) continue;
            return schema.getOutputSchema();
        }
        return inputSchema;
    }

    @Override
    public String getOutputSchema(String inputCatalog, String inputSchema) {
        for (CatalogMappingType catalog : this.configuredCatalogs) {
            if (!inputCatalog.equals(catalog.getInputCatalog())) continue;
            for (SchemaMappingType schema : catalog.getSchemata()) {
                if (!inputSchema.equals(schema.getInputSchema())) continue;
                return schema.getOutputSchema();
            }
        }
        return inputSchema;
    }

    @Override
    public final void setConfiguredCatalogs(List<CatalogMappingType> catalogs) {
        this.configuredCatalogs = catalogs;
    }

    @Override
    public final void setConfiguredSchemata(List<SchemaMappingType> schemata) {
        this.configuredSchemata = schemata;
    }

    @Override
    public final void setProperties(Properties properties) {
        this.properties = properties;
    }

    @Override
    public final Properties getProperties() {
        return this.properties;
    }

    @Override
    public final void setBasedir(String basedir) {
        this.basedir = basedir;
    }

    @Override
    public final String getBasedir() {
        return this.basedir == null ? new File(".").getAbsolutePath() : this.basedir;
    }

    @Override
    public final void setOnError(OnError onError) {
        this.onError = onError;
    }

    @Override
    public final OnError onError() {
        return this.onError == null ? OnError.FAIL : this.onError;
    }

    @Override
    public final List<Database.Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new ArrayList<Database.Filter>();
        }
        return Collections.unmodifiableList(this.filters);
    }

    @Override
    public final void addFilter(Database.Filter filter) {
        this.filters.add(filter);
    }

    final Patterns patterns() {
        return this.patterns;
    }

    @Override
    public final void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    @Override
    public final String[] getExcludes() {
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
        return this.excludes;
    }

    @Override
    public final void setIncludes(String[] includes) {
        this.includes = includes;
    }

    @Override
    public final String[] getIncludes() {
        if (this.includes == null) {
            this.includes = new String[0];
        }
        return this.includes;
    }

    @Override
    public final void setIncludeExcludeColumns(boolean includeExcludeColumns) {
        this.includeExcludeColumns = includeExcludeColumns;
    }

    @Override
    public final boolean getIncludeExcludeColumns() {
        return this.includeExcludeColumns;
    }

    @Override
    public final void setIncludeExcludePackageRoutines(boolean includeExcludePackageRoutines) {
        this.includeExcludePackageRoutines = includeExcludePackageRoutines;
    }

    @Override
    public final boolean getIncludeExcludePackageRoutines() {
        return this.includeExcludePackageRoutines;
    }

    @Override
    public final void setIncludeInvisibleColumns(boolean includeInvisibleColumns) {
        this.includeInvisibleColumns = includeInvisibleColumns;
    }

    @Override
    public final boolean getIncludeInvisibleColumns() {
        return this.includeInvisibleColumns;
    }

    @Override
    public final boolean getIncludeTables() {
        return this.includeTables;
    }

    @Override
    public final void setIncludeTables(boolean includeTables) {
        this.includeTables = includeTables;
    }

    @Override
    public final boolean getIncludeEmbeddables() {
        return this.includeEmbeddables;
    }

    @Override
    public final void setIncludeEmbeddables(boolean includeEmbeddables) {
        this.includeEmbeddables = includeEmbeddables;
    }

    @Override
    public final boolean getIncludeRoutines() {
        return this.includeRoutines;
    }

    @Override
    public final void setIncludeRoutines(boolean includeRoutines) {
        this.includeRoutines = includeRoutines;
    }

    @Override
    public void setIncludeTriggerRoutines(boolean includeTriggerRoutines) {
        this.includeTriggerRoutines = includeTriggerRoutines;
    }

    @Override
    public boolean getIncludeTriggerRoutines() {
        return this.includeTriggerRoutines;
    }

    @Override
    public final boolean getIncludePackages() {
        return this.includePackages;
    }

    @Override
    public final void setIncludePackages(boolean includePackages) {
        this.includePackages = includePackages;
    }

    @Override
    public final boolean getIncludePackageRoutines() {
        return this.includePackageRoutines;
    }

    @Override
    public final void setIncludePackageRoutines(boolean includePackageRoutines) {
        this.includePackageRoutines = includePackageRoutines;
    }

    @Override
    public final boolean getIncludePackageUDTs() {
        return this.includePackageUDTs;
    }

    @Override
    public final void setIncludePackageUDTs(boolean includePackageUDTs) {
        this.includePackageUDTs = includePackageUDTs;
    }

    @Override
    public final boolean getIncludePackageConstants() {
        return this.includePackageConstants;
    }

    @Override
    public final void setIncludePackageConstants(boolean includePackageConstants) {
        this.includePackageConstants = includePackageConstants;
    }

    @Override
    public final boolean getIncludeUDTs() {
        return this.includeUDTs;
    }

    @Override
    public final void setIncludeUDTs(boolean includeUDTs) {
        this.includeUDTs = includeUDTs;
    }

    @Override
    public final boolean getIncludeDomains() {
        return this.includeDomains;
    }

    @Override
    public final void setIncludeDomains(boolean includeDomains) {
        this.includeDomains = includeDomains;
    }

    @Override
    public final boolean getIncludeSequences() {
        return this.includeSequences;
    }

    @Override
    public final void setIncludeSequences(boolean includeSequences) {
        this.includeSequences = includeSequences;
    }

    @Override
    public final void setIncludeCheckConstraints(boolean includeCheckConstraints) {
        this.includeCheckConstraints = includeCheckConstraints;
    }

    @Override
    public final boolean getIncludeCheckConstraints() {
        return this.includeCheckConstraints;
    }

    @Override
    public final void setIncludeSystemTables(boolean includeSystemTables) {
        this.includeSystemTables = includeSystemTables;
    }

    @Override
    public final boolean getIncludeSystemTables() {
        return this.includeSystemTables;
    }

    @Override
    public final void setIncludeSystemIndexes(boolean includeSystemIndexes) {
        this.includeSystemIndexes = includeSystemIndexes;
    }

    @Override
    public final boolean getIncludeSystemIndexes() {
        return this.includeSystemIndexes;
    }

    @Override
    public final void setIncludeSystemCheckConstraints(boolean includeSystemCheckConstraints) {
        this.includeSystemCheckConstraints = includeSystemCheckConstraints;
    }

    @Override
    public final boolean getIncludeSystemCheckConstraints() {
        return this.includeSystemCheckConstraints;
    }

    @Override
    public final void setIncludeSystemSequences(boolean includeSystemSequences) {
        this.includeSystemSequences = includeSystemSequences;
    }

    @Override
    public final boolean getIncludeSystemSequences() {
        return this.includeSystemSequences;
    }

    @Override
    public final void setIncludeSystemUDTs(boolean includeSystemUDTs) {
        this.includeSystemUDTs = includeSystemUDTs;
    }

    @Override
    public final boolean getIncludeSystemUDTs() {
        return this.includeSystemUDTs;
    }

    @Override
    public final void setIncludeIndexes(boolean includeIndexes) {
        this.includeIndexes = includeIndexes;
    }

    @Override
    public final boolean getIncludeIndexes() {
        return this.includeIndexes;
    }

    @Override
    public final boolean getIncludePrimaryKeys() {
        return this.includePrimaryKeys;
    }

    @Override
    public final void setIncludePrimaryKeys(boolean includePrimaryKeys) {
        this.includePrimaryKeys = includePrimaryKeys;
    }

    @Override
    public final boolean getIncludeUniqueKeys() {
        return this.includeUniqueKeys;
    }

    @Override
    public final void setIncludeUniqueKeys(boolean includeUniqueKeys) {
        this.includeUniqueKeys = includeUniqueKeys;
    }

    @Override
    public final boolean getIncludeForeignKeys() {
        return this.includeForeignKeys;
    }

    @Override
    public final void setIncludeForeignKeys(boolean includeForeignKeys) {
        this.includeForeignKeys = includeForeignKeys;
    }

    @Override
    public final void setRegexFlags(List<RegexFlag> regexFlags) {
        this.patterns.setRegexFlags(regexFlags);
    }

    @Override
    public final List<RegexFlag> getRegexFlags() {
        return this.patterns.getRegexFlags();
    }

    @Override
    public final void setRegexMatchesPartialQualification(boolean regexMatchesPartialQualification) {
        this.regexMatchesPartialQualification = regexMatchesPartialQualification;
    }

    @Override
    public final boolean getRegexMatchesPartialQualification() {
        return this.regexMatchesPartialQualification;
    }

    @Override
    public final void setSqlMatchesPartialQualification(boolean sqlMatchesPartialQualification) {
        this.sqlMatchesPartialQualification = sqlMatchesPartialQualification;
    }

    @Override
    public final boolean getSqlMatchesPartialQualification() {
        return this.sqlMatchesPartialQualification;
    }

    @Override
    public void setRecordVersionFields(String[] recordVersionFields) {
        this.recordVersionFields = recordVersionFields;
    }

    @Override
    public String[] getRecordVersionFields() {
        if (this.recordVersionFields == null) {
            this.recordVersionFields = new String[0];
        }
        return this.recordVersionFields;
    }

    @Override
    public void setRecordTimestampFields(String[] recordTimestampFields) {
        this.recordTimestampFields = recordTimestampFields;
    }

    @Override
    public String[] getRecordTimestampFields() {
        if (this.recordTimestampFields == null) {
            this.recordTimestampFields = new String[0];
        }
        return this.recordTimestampFields;
    }

    @Override
    @Deprecated
    public void setSyntheticPrimaryKeys(String[] syntheticPrimaryKeys) {
        if (syntheticPrimaryKeys != null) {
            for (String syntheticPrimaryKey : syntheticPrimaryKeys) {
                if (StringUtils.isBlank(syntheticPrimaryKey)) continue;
                log.warn((Object)"DEPRECATION", "The <syntheticPrimaryKeys/> configuration element has been deprecated in jOOQ 3.14. Use <syntheticObjects/> only, instead.");
                this.getConfiguredSyntheticPrimaryKeys().add(new SyntheticPrimaryKeyType().withFields(syntheticPrimaryKey));
            }
        }
    }

    @Override
    @Deprecated
    public String[] getSyntheticPrimaryKeys() {
        log.warn((Object)"DEPRECATION", "The <syntheticPrimaryKeys/> configuration element has been deprecated in jOOQ 3.14. Use <syntheticObjects/> only, instead.");
        return new String[0];
    }

    @Override
    @Deprecated
    public void setOverridePrimaryKeys(String[] overridePrimaryKeys) {
        if (overridePrimaryKeys != null) {
            for (String overridePrimaryKey : overridePrimaryKeys) {
                if (StringUtils.isBlank(overridePrimaryKey)) continue;
                log.warn((Object)"DEPRECATION", "The <overridePrimaryKeys/> configuration element has been deprecated in jOOQ 3.14. Use <syntheticObjects/> only, instead.");
                this.getConfiguredSyntheticPrimaryKeys().add(new SyntheticPrimaryKeyType().withKey(overridePrimaryKey));
            }
        }
    }

    @Override
    @Deprecated
    public String[] getOverridePrimaryKeys() {
        log.warn((Object)"DEPRECATION", "The <overridePrimaryKeys/> configuration element has been deprecated in jOOQ 3.14. Use <syntheticObjects/> only, instead.");
        return new String[0];
    }

    @Override
    @Deprecated
    public void setSyntheticIdentities(String[] syntheticIdentities) {
        if (syntheticIdentities != null) {
            for (String syntheticIdentity : syntheticIdentities) {
                if (StringUtils.isBlank(syntheticIdentity)) continue;
                log.warn((Object)"DEPRECATION", "The <syntheticIdentities/> configuration element has been deprecated in jOOQ 3.14. Use <syntheticObjects/> only, instead.");
                this.getConfiguredSyntheticIdentities().add(new SyntheticIdentityType().withFields(syntheticIdentity));
            }
        }
    }

    @Override
    @Deprecated
    public final String[] getSyntheticIdentities() {
        log.warn((Object)"DEPRECATION", "The <syntheticIdentities/> configuration element has been deprecated in jOOQ 3.14. Use <syntheticObjects/> only, instead.");
        return new String[0];
    }

    @Override
    public final void setConfiguredEnumTypes(List<EnumType> configuredEnumTypes) {
        this.configuredEnumTypes = configuredEnumTypes;
    }

    @Override
    public final List<EnumType> getConfiguredEnumTypes() {
        if (this.configuredEnumTypes == null) {
            this.configuredEnumTypes = new ArrayList<EnumType>();
        }
        return this.configuredEnumTypes;
    }

    @Override
    @Deprecated
    public final void setConfiguredCustomTypes(List<CustomType> configuredCustomTypes) {
        if (!configuredCustomTypes.isEmpty()) {
            log.warn((Object)"DEPRECATION", "The <customTypes/> configuration element has been deprecated in jOOQ 3.10. Use <forcedTypes/> only, instead.");
        }
        this.configuredCustomTypes = configuredCustomTypes;
    }

    @Override
    @Deprecated
    public final List<CustomType> getConfiguredCustomTypes() {
        if (this.configuredCustomTypes == null) {
            this.configuredCustomTypes = new ArrayList<CustomType>();
        }
        return this.configuredCustomTypes;
    }

    @Override
    @Deprecated
    public final CustomType getConfiguredCustomType(String typeName) {
        if (typeName == null) {
            return null;
        }
        Iterator<CustomType> it1 = this.getConfiguredCustomTypes().iterator();
        while (it1.hasNext()) {
            CustomType type = it1.next();
            if (type == null || type.getName() == null && type.getType() == null) {
                log.warn("Invalid custom type encountered: " + type);
                it1.remove();
                continue;
            }
            if (!StringUtils.equals(type.getType() != null ? type.getType() : type.getName(), typeName)) continue;
            return type;
        }
        Iterator<ForcedType> it2 = this.configuredForcedTypes.iterator();
        while (it2.hasNext()) {
            ForcedType type = it2.next();
            if (type.getExpressions() != null) {
                type.setIncludeExpression(type.getExpressions());
                type.setExpressions(null);
                log.warn((Object)"DEPRECATED", "The <expressions/> element in <forcedType/> is deprecated. Use <includeExpression/> instead: " + type);
            }
            if (type.getExpression() != null) {
                type.setIncludeExpression(type.getExpression());
                type.setExpression(null);
                log.warn((Object)"DEPRECATED", "The <expression/> element in <forcedType/> is deprecated. Use <includeExpression/> instead: " + type);
            }
            if (type.getTypes() != null) {
                type.setIncludeTypes(type.getTypes());
                type.setTypes(null);
                log.warn((Object)"DEPRECATED", "The <types/> element in <forcedType/> is deprecated. Use <includeTypes/> instead: " + type);
            }
            if (StringUtils.isBlank(type.getName())) {
                if (StringUtils.isBlank(type.getUserType())) {
                    log.warn("Bad configuration for <forcedType/>. Either <name/> or <userType/> is required: " + type);
                    it2.remove();
                    continue;
                }
                if (StringUtils.isBlank(type.getBinding()) && StringUtils.isBlank(type.getConverter()) && !Boolean.TRUE.equals(type.isEnumConverter()) && type.getLambdaConverter() == null) {
                    log.warn("Bad configuration for <forcedType/>. Either <binding/> or <converter/> or <enumConverter/> or <lambdaConverter/> is required: " + type);
                    it2.remove();
                    continue;
                }
            } else {
                if (!StringUtils.isBlank(type.getUserType())) {
                    log.warn("Bad configuration for <forcedType/>. <userType/> is not allowed when <name/> is provided: " + type);
                    type.setUserType(null);
                }
                if (!StringUtils.isBlank(type.getBinding())) {
                    log.warn("Bad configuration for <forcedType/>. <binding/> is not allowed when <name/> is provided: " + type);
                    type.setBinding(null);
                }
                if (!StringUtils.isBlank(type.getConverter())) {
                    log.warn("Bad configuration for <forcedType/>. <converter/> is not allowed when <name/> is provided: " + type);
                    type.setConverter(null);
                }
                if (Boolean.TRUE.equals(type.isEnumConverter())) {
                    log.warn("Bad configuration for <forcedType/>. <enumConverter/> is not allowed when <name/> is provided: " + type);
                    type.setEnumConverter(null);
                }
                if (type.getLambdaConverter() != null) {
                    log.warn("Bad configuration for <forcedType/>. <lambdaConverter/> is not allowed when <name/> is provided: " + type);
                    type.setLambdaConverter(null);
                }
            }
            if (type.getUserType() == null || !StringUtils.equals(type.getUserType(), typeName)) continue;
            return AbstractTypedElementDefinition.customType(this, type);
        }
        return null;
    }

    @Override
    public void markUsed(ForcedType forcedType) {
        this.unusedForcedTypes.remove(forcedType);
    }

    @Override
    public List<ForcedType> getUnusedForcedTypes() {
        return new ArrayList<ForcedType>(this.unusedForcedTypes);
    }

    @Override
    public final void setConfiguredForcedTypes(List<ForcedType> configuredForcedTypes) {
        this.getConfiguredForcedTypes().addAll(configuredForcedTypes);
        this.unusedForcedTypes.addAll(configuredForcedTypes);
    }

    @Override
    public final List<ForcedType> getConfiguredForcedTypes() {
        if (this.configuredForcedTypes == null) {
            this.configuredForcedTypes = new SortedList<ForcedType>(new ArrayList(), Comparator.comparing(f2 -> StringUtils.defaultIfNull(f2.getPriority(), 0), (i1, i2) -> Integer.compare(i2, i1)));
        }
        return this.configuredForcedTypes;
    }

    @Override
    public final int getLogSlowQueriesAfterSeconds() {
        return this.logSlowQueriesAfterSeconds;
    }

    @Override
    public final void setLogSlowQueriesAfterSeconds(int logSlowQueriesAfterSeconds) {
        this.logSlowQueriesAfterSeconds = logSlowQueriesAfterSeconds;
    }

    @Override
    public final int getLogSlowResultsAfterSeconds() {
        return this.logSlowResultsAfterSeconds;
    }

    @Override
    public final void setLogSlowResultsAfterSeconds(int logSlowResultsAfterSeconds) {
        this.logSlowResultsAfterSeconds = logSlowResultsAfterSeconds;
    }

    @Override
    public final SchemaVersionProvider getSchemaVersionProvider() {
        return this.schemaVersionProvider;
    }

    @Override
    public final void setSchemaVersionProvider(SchemaVersionProvider schemaVersionProvider) {
        this.schemaVersionProvider = schemaVersionProvider;
    }

    @Override
    public final CatalogVersionProvider getCatalogVersionProvider() {
        return this.catalogVersionProvider;
    }

    @Override
    public final void setCatalogVersionProvider(CatalogVersionProvider catalogVersionProvider) {
        this.catalogVersionProvider = catalogVersionProvider;
    }

    @Override
    public final Comparator<Definition> getOrderProvider() {
        return this.orderProvider;
    }

    @Override
    public final void setOrderProvider(Comparator<Definition> provider) {
        this.orderProvider = provider;
    }

    @Override
    public final void setSupportsUnsignedTypes(boolean supportsUnsignedTypes) {
        this.supportsUnsignedTypes = supportsUnsignedTypes;
    }

    @Override
    public final boolean supportsUnsignedTypes() {
        return this.supportsUnsignedTypes;
    }

    @Override
    public final void setIntegerDisplayWidths(boolean integerDisplayWidths) {
        this.integerDisplayWidths = integerDisplayWidths;
    }

    @Override
    public final boolean integerDisplayWidths() {
        return this.integerDisplayWidths;
    }

    @Override
    public final void setIgnoreProcedureReturnValues(boolean ignoreProcedureReturnValues) {
        this.ignoreProcedureReturnValues = ignoreProcedureReturnValues;
    }

    @Override
    public final boolean ignoreProcedureReturnValues() {
        return this.ignoreProcedureReturnValues;
    }

    @Override
    public final void setDateAsTimestamp(boolean dateAsTimestamp) {
        this.dateAsTimestamp = dateAsTimestamp;
    }

    @Override
    public final boolean dateAsTimestamp() {
        return this.dateAsTimestamp;
    }

    @Override
    public final void setJavaTimeTypes(boolean javaTimeTypes) {
        this.javaTimeTypes = javaTimeTypes;
    }

    @Override
    public final boolean javaTimeTypes() {
        return this.javaTimeTypes;
    }

    @Override
    public final void setIncludeRelations(boolean includeRelations) {
        this.includeRelations = includeRelations;
    }

    @Override
    public final boolean includeRelations() {
        return this.includeRelations;
    }

    @Override
    public void setForceIntegerTypesOnZeroScaleDecimals(boolean forceIntegerTypesOnZeroScaleDecimals) {
        this.forceIntegerTypesOnZeroScaleDecimals = forceIntegerTypesOnZeroScaleDecimals;
    }

    @Override
    public boolean getForceIntegerTypesOnZeroScaleDecimals() {
        return this.forceIntegerTypesOnZeroScaleDecimals;
    }

    @Override
    public final void setTableValuedFunctions(boolean tableValuedFunctions) {
        this.tableValuedFunctions = tableValuedFunctions;
    }

    @Override
    public final boolean tableValuedFunctions() {
        return this.tableValuedFunctions;
    }

    @Override
    public final List<SequenceDefinition> getSequences() {
        if (this.sequences == null) {
            this.sequences = new ArrayList<SequenceDefinition>();
            if (this.getIncludeSequences()) {
                this.onError(Log.Level.ERROR, "Error while fetching sequences", () -> {
                    List<SequenceDefinition> s2 = this.getSequences0();
                    this.sequences = this.sort((List)this.filterExcludeInclude((List)s2));
                    log.info((Object)"Sequences fetched", AbstractDatabase.fetchedSize(s2, this.sequences));
                });
            } else {
                log.info("Sequences excluded");
            }
        }
        return this.sequences;
    }

    @Override
    public final List<SequenceDefinition> getSequences(SchemaDefinition schema) {
        if (this.sequencesBySchema == null) {
            this.sequencesBySchema = new LinkedHashMap<SchemaDefinition, List<SequenceDefinition>>();
        }
        return this.filterSchema(this.getSequences(), schema, this.sequencesBySchema);
    }

    @Override
    public final List<IdentityDefinition> getIdentities(SchemaDefinition schema) {
        if (this.identities == null) {
            this.identities = new ArrayList<IdentityDefinition>();
            for (SchemaDefinition s2 : this.getSchemata()) {
                for (TableDefinition table : this.getTables(s2)) {
                    IdentityDefinition identity = table.getIdentity();
                    if (identity == null) continue;
                    this.identities.add(identity);
                }
            }
            this.sort((List)this.identities);
        }
        if (this.identitiesBySchema == null) {
            this.identitiesBySchema = new LinkedHashMap<SchemaDefinition, List<IdentityDefinition>>();
        }
        return this.filterSchema(this.identities, schema, this.identitiesBySchema);
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys() {
        if (this.uniqueKeys == null) {
            this.uniqueKeys = new ArrayList<UniqueKeyDefinition>();
            if (this.getIncludeUniqueKeys()) {
                for (SchemaDefinition s2 : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s2)) {
                        this.uniqueKeys.addAll(table.getUniqueKeys());
                    }
                }
            }
            this.sort((List)this.uniqueKeys);
        }
        return this.uniqueKeys;
    }

    @Override
    public final List<UniqueKeyDefinition> getPrimaryKeys(SchemaDefinition schema) {
        if (this.primaryKeysBySchema == null) {
            this.primaryKeysBySchema = new LinkedHashMap<SchemaDefinition, List<UniqueKeyDefinition>>();
        }
        return this.filterSchema(this.getPrimaryKeys(), schema, this.primaryKeysBySchema);
    }

    @Override
    public final List<UniqueKeyDefinition> getPrimaryKeys() {
        if (this.primaryKeys == null) {
            this.primaryKeys = new ArrayList<UniqueKeyDefinition>();
            if (this.getIncludePrimaryKeys()) {
                for (SchemaDefinition s2 : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s2)) {
                        if (table.getPrimaryKey() == null) continue;
                        this.primaryKeys.add(table.getPrimaryKey());
                    }
                }
            }
            this.sort((List)this.primaryKeys);
        }
        return this.primaryKeys;
    }

    @Override
    public final List<UniqueKeyDefinition> getUniqueKeys(SchemaDefinition schema) {
        if (this.uniqueKeysBySchema == null) {
            this.uniqueKeysBySchema = new LinkedHashMap<SchemaDefinition, List<UniqueKeyDefinition>>();
        }
        return this.filterSchema(this.getUniqueKeys(), schema, this.uniqueKeysBySchema);
    }

    @Override
    public final List<UniqueKeyDefinition> getKeys() {
        if (this.keys == null) {
            this.keys = new ArrayList<UniqueKeyDefinition>();
            if (this.getIncludeUniqueKeys() || this.getIncludePrimaryKeys()) {
                for (SchemaDefinition s2 : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s2)) {
                        this.keys.addAll(table.getKeys());
                    }
                }
            }
            this.sort((List)this.keys);
        }
        return this.keys;
    }

    @Override
    public final List<UniqueKeyDefinition> getKeys(SchemaDefinition schema) {
        if (this.keysBySchema == null) {
            this.keysBySchema = new LinkedHashMap<SchemaDefinition, List<UniqueKeyDefinition>>();
        }
        return this.filterSchema(this.getKeys(), schema, this.keysBySchema);
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys() {
        if (this.foreignKeys == null) {
            this.foreignKeys = new ArrayList<ForeignKeyDefinition>();
            if (this.getIncludeForeignKeys()) {
                for (SchemaDefinition s2 : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s2)) {
                        this.foreignKeys.addAll(table.getForeignKeys());
                    }
                }
            }
            this.sort((List)this.foreignKeys);
        }
        return this.foreignKeys;
    }

    @Override
    public final List<ForeignKeyDefinition> getForeignKeys(SchemaDefinition schema) {
        if (this.foreignKeysBySchema == null) {
            this.foreignKeysBySchema = new LinkedHashMap<SchemaDefinition, List<ForeignKeyDefinition>>();
        }
        return this.filterSchema(this.getForeignKeys(), schema, this.foreignKeysBySchema);
    }

    @Override
    public final List<CheckConstraintDefinition> getCheckConstraints(SchemaDefinition schema) {
        if (this.checkConstraints == null) {
            this.checkConstraints = new ArrayList<CheckConstraintDefinition>();
            if (this.getIncludeCheckConstraints()) {
                for (SchemaDefinition s2 : this.getSchemata()) {
                    for (TableDefinition table : this.getTables(s2)) {
                        this.checkConstraints.addAll(table.getCheckConstraints());
                    }
                }
            }
            this.sort((List)this.checkConstraints);
        }
        if (this.checkConstraintsBySchema == null) {
            this.checkConstraintsBySchema = new LinkedHashMap<SchemaDefinition, List<CheckConstraintDefinition>>();
        }
        return this.filterSchema(this.checkConstraints, schema, this.checkConstraintsBySchema);
    }

    @Override
    public final List<TableDefinition> getTables() {
        if (this.tables == null) {
            this.tables = new ArrayList<TableDefinition>();
            if (this.getIncludeTables()) {
                this.onError(Log.Level.ERROR, "Error while fetching tables", () -> {
                    List<TableDefinition> t2 = this.getTables0();
                    this.syntheticViews(t2);
                    this.tables = this.sort((List)this.filterExcludeInclude((List)t2));
                    log.info((Object)"Tables fetched", AbstractDatabase.fetchedSize(t2, this.tables));
                });
            } else {
                log.info("Tables excluded");
            }
        }
        return this.tables;
    }

    @Override
    public final List<TableDefinition> getTables(SchemaDefinition schema) {
        if (this.tablesBySchema == null) {
            this.tablesBySchema = new LinkedHashMap<SchemaDefinition, List<TableDefinition>>();
        }
        return this.filterSchema(this.getTables(), schema, this.tablesBySchema);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name) {
        return this.getTable(schema, name, false);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getTables(schema), name, ignoreCase);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, Name name) {
        return this.getTable(schema, name, false);
    }

    @Override
    public final TableDefinition getTable(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getTables(schema), name, ignoreCase);
    }

    @Override
    public final List<EnumDefinition> getEnums(SchemaDefinition schema) {
        if (this.enums == null) {
            this.enums = new ArrayList<EnumDefinition>();
            this.onError(Log.Level.ERROR, "Error while fetching enums", () -> {
                List<EnumDefinition> e2 = this.getEnums0();
                this.enums = this.sort((List)this.filterExcludeInclude((List)e2));
                this.enums.addAll(this.getConfiguredEnums());
                log.info((Object)"Enums fetched", AbstractDatabase.fetchedSize(e2, this.enums));
            });
        }
        if (this.enumsBySchema == null) {
            this.enumsBySchema = new LinkedHashMap<SchemaDefinition, List<EnumDefinition>>();
        }
        return this.filterSchema(this.enums, schema, this.enumsBySchema);
    }

    private final List<EnumDefinition> getConfiguredEnums() {
        ArrayList<EnumDefinition> result = new ArrayList<EnumDefinition>(this.getConfiguredEnumTypes().size());
        for (EnumType enumType : this.getConfiguredEnumTypes()) {
            String name = enumType.getName();
            DefaultEnumDefinition e2 = new DefaultEnumDefinition(this.getSchemata().get(0), name, null, true);
            String literals = enumType.getLiterals();
            try {
                CSVReader reader = new CSVReader(new StringReader(literals));
                e2.addLiterals(reader.readNext());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            result.add(e2);
        }
        return result;
    }

    @Override
    public final ForcedType getConfiguredForcedType(Definition definition) {
        return this.getConfiguredForcedType(definition, null);
    }

    @Override
    public final ForcedType getConfiguredForcedType(Definition definition, DataTypeDefinition definedType) {
        for (ForcedType forcedType : this.getConfiguredForcedTypes()) {
            String excludeExpression = forcedType.getExcludeExpression();
            String includeExpression = StringUtils.firstNonNull(forcedType.getIncludeExpression(), forcedType.getExpression(), forcedType.getExpressions());
            String excludeTypes = forcedType.getExcludeTypes();
            String includeTypes = StringUtils.firstNonNull(forcedType.getIncludeTypes(), forcedType.getTypes());
            Nullability nullability = forcedType.getNullability();
            ForcedTypeObjectType objectType = forcedType.getObjectType();
            String sql = forcedType.getSql();
            if (objectType != null && objectType != ForcedTypeObjectType.ALL && (objectType == ForcedTypeObjectType.ATTRIBUTE && !(definition instanceof AttributeDefinition) || objectType == ForcedTypeObjectType.COLUMN && !(definition instanceof ColumnDefinition) || objectType == ForcedTypeObjectType.ELEMENT && !(definition instanceof ArrayDefinition) || objectType == ForcedTypeObjectType.PARAMETER && !(definition instanceof ParameterDefinition) || objectType == ForcedTypeObjectType.SEQUENCE && !(definition instanceof SequenceDefinition)) || nullability != null && nullability != Nullability.ALL && definedType != null && (nullability == Nullability.NOT_NULL && definedType.isNullable() || nullability == Nullability.NULL && !definedType.isNullable()) || excludeExpression != null && this.matches(this.patterns.pattern(excludeExpression), definition) || includeExpression != null && !this.matches(this.patterns.pattern(includeExpression), definition) || definedType != null && (excludeTypes != null || includeTypes != null) && !this.typeMatchesExcludeInclude(definedType, excludeTypes, includeTypes) || sql != null && !this.matches(this.statements.fetchSet(sql), definition)) continue;
            return forcedType;
        }
        return null;
    }

    private boolean typeMatchesExcludeInclude(DataTypeDefinition type, String exclude, String include) {
        if (exclude != null && this.matches(type, this.patterns.pattern(exclude))) {
            return false;
        }
        return include == null || this.matches(type, this.patterns.pattern(include));
    }

    private boolean matches(DataTypeDefinition type, Pattern pattern) {
        return type.getMatchNames().stream().map(pattern::matcher).anyMatch(Matcher::matches);
    }

    @Override
    public final void markUsed(EmbeddableDefinitionType embeddable) {
        this.unusedEmbeddables.remove(embeddable);
    }

    @Override
    public final List<EmbeddableDefinitionType> getUnusedEmbeddables() {
        return new ArrayList<EmbeddableDefinitionType>(this.unusedEmbeddables);
    }

    @Override
    public final void setConfiguredEmbeddables(List<EmbeddableDefinitionType> configuredEmbeddables) {
        this.getConfiguredEmbeddables().addAll(configuredEmbeddables);
        this.unusedEmbeddables.addAll(configuredEmbeddables);
    }

    @Override
    public final List<EmbeddableDefinitionType> getConfiguredEmbeddables() {
        if (this.configuredEmbeddables == null) {
            this.configuredEmbeddables = new ArrayList<EmbeddableDefinitionType>();
        }
        return this.configuredEmbeddables;
    }

    @Override
    public String embeddablePrimaryKeys() {
        return this.embeddablePrimaryKeys;
    }

    @Override
    public void setEmbeddablePrimaryKeys(String embeddablePrimaryKeys) {
        if (!StringUtils.isBlank(embeddablePrimaryKeys)) {
            log.info((Object)"Commercial feature", "Embeddable primary and unique keys are a commercial only feature. Please consider upgrading to the jOOQ Professional Edition");
        }
        this.embeddablePrimaryKeys = embeddablePrimaryKeys;
    }

    @Override
    public String embeddableUniqueKeys() {
        return this.embeddableUniqueKeys;
    }

    @Override
    public void setEmbeddableUniqueKeys(String embeddableUniqueKeys) {
        if (!StringUtils.isBlank(embeddableUniqueKeys)) {
            log.info((Object)"Commercial feature", "Embeddable primary and unique keys are a commercial only feature. Please consider upgrading to the jOOQ Professional Edition");
        }
        this.embeddableUniqueKeys = embeddableUniqueKeys;
    }

    @Override
    public String embeddableDomains() {
        return this.embeddableDomains;
    }

    @Override
    public void setEmbeddableDomains(String embeddableDomains) {
        if (!StringUtils.isBlank(embeddableDomains)) {
            log.info((Object)"Commercial feature", "Embeddable domains are a commercial only feature. Please consider upgrading to the jOOQ Professional Edition");
        }
        this.embeddableDomains = embeddableDomains;
    }

    @Override
    public boolean readonlyIdentities() {
        return this.readonlyIdentities;
    }

    @Override
    public void setReadonlyIdentities(boolean readonlyIdentities) {
        this.readonlyIdentities = readonlyIdentities;
    }

    @Override
    public boolean readonlyComputedColumns() {
        return this.readonlyComputedColumns;
    }

    @Override
    public void setReadonlyComputedColumns(boolean readonlyComputedColumns) {
        this.readonlyComputedColumns = readonlyComputedColumns;
    }

    @Override
    public boolean readonlyNonUpdatableColumns() {
        return this.readonlyNonUpdatableColumns;
    }

    @Override
    public void setReadonlyNonUpdatableColumns(boolean readonlyNonUpdatableColumns) {
        this.readonlyNonUpdatableColumns = readonlyNonUpdatableColumns;
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddables() {
        if (this.embeddables == null) {
            this.embeddables = new ArrayList<EmbeddableDefinition>();
            if (this.getIncludeEmbeddables()) {
                this.onError(Log.Level.ERROR, "Error while fetching embeddables", () -> {
                    List<EmbeddableDefinition> r2 = this.getEmbeddables0();
                    this.embeddables = this.sort((List)r2);
                    log.info((Object)"Embeddables fetched", AbstractDatabase.fetchedSize(r2, this.embeddables));
                });
            } else {
                log.info("Embeddables excluded");
            }
        }
        return this.embeddables;
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddables(SchemaDefinition schema) {
        if (this.embeddablesByDefiningSchema == null) {
            this.embeddablesByDefiningSchema = new LinkedHashMap<SchemaDefinition, List<EmbeddableDefinition>>();
        }
        return this.filterSchema(this.getEmbeddables(), schema, this.embeddablesByDefiningSchema);
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddables(TableDefinition table) {
        if (this.embeddablesByDefiningTable == null) {
            this.embeddablesByDefiningTable = new LinkedHashMap<TableDefinition, List<EmbeddableDefinition>>();
        }
        return this.filterTable(this.getEmbeddables(table.getSchema()), table, this.embeddablesByDefiningTable);
    }

    @Override
    public final List<EmbeddableDefinition> getEmbeddablesByReferencingTable(TableDefinition table) {
        if (this.embeddablesByReferencingTable == null) {
            this.embeddablesByReferencingTable = new LinkedHashMap<TableDefinition, List<EmbeddableDefinition>>();
        }
        return this.filterReferencingTable(this.getEmbeddables(), table, this.embeddablesByReferencingTable);
    }

    private final List<EmbeddableDefinition> getEmbeddables0() {
        LinkedHashMap<Name, DefaultEmbeddableDefinition> result = new LinkedHashMap<Name, DefaultEmbeddableDefinition>();
        for (TableDefinition table : this.getTables()) {
            for (EmbeddableDefinitionType embeddable : this.getConfiguredEmbeddables()) {
                Name name;
                SchemaDefinition schema;
                if (embeddable.getTables() != null && !this.matches(this.patterns.pattern(embeddable.getTables()), (Definition)table)) continue;
                if (embeddable.getFields().isEmpty()) {
                    log.warn((Object)"Illegal embeddable", "An embeddable definition must have at least one field declaration");
                    continue;
                }
                ArrayList<ColumnDefinition> columns = new ArrayList<ColumnDefinition>();
                ArrayList<String> names = new ArrayList<String>();
                for (EmbeddableField embeddableField : embeddable.getFields()) {
                    boolean matched = false;
                    for (ColumnDefinition column : table.getColumns()) {
                        if (!this.matches(this.patterns.pattern(embeddableField.getExpression()), (Definition)column)) continue;
                        if (matched) {
                            log.warn("EmbeddableField configuration matched several columns in table " + table + ": " + embeddableField);
                            continue;
                        }
                        matched = columns.add(column) && names.add(StringUtils.defaultIfEmpty(embeddableField.getName(), column.getName()));
                    }
                }
                if (columns.size() != embeddable.getFields().size()) continue;
                CatalogDefinition catalog = this.getCatalog(embeddable.getCatalog());
                SchemaDefinition schemaDefinition = schema = catalog != null ? catalog.getSchema(embeddable.getSchema()) : this.getSchema(embeddable.getSchema());
                if (schema == null) {
                    schema = table.getSchema();
                }
                if (result.containsKey(name = table.getQualifiedNamePart().append(embeddable.getName()))) {
                    log.warn((Object)"Embeddable configuration", "Table " + table + " already has embeddable " + embeddable);
                    continue;
                }
                result.put(name, new DefaultEmbeddableDefinition(schema, embeddable.getName(), embeddable.getComment(), table, names, StringUtils.defaultIfBlank(embeddable.getReferencingName(), embeddable.getName()), StringUtils.defaultIfBlank(embeddable.getReferencingComment(), embeddable.getComment()), table, columns, Boolean.TRUE.equals(embeddable.isReplacesFields())));
                this.markUsed(embeddable);
            }
        }
        return new ArrayList<EmbeddableDefinition>(result.values());
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name) {
        return this.getEnum(schema, name, false);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getEnums(schema), name, ignoreCase);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, Name name) {
        return this.getEnum(schema, name, false);
    }

    @Override
    public final EnumDefinition getEnum(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getEnums(schema), name, ignoreCase);
    }

    @Override
    public final List<DomainDefinition> getDomains() {
        if (this.domains == null) {
            this.domains = new ArrayList<DomainDefinition>();
            if (this.getIncludeDomains()) {
                this.onError(Log.Level.ERROR, "Error while fetching domains", () -> {
                    List<DomainDefinition> e2 = this.getDomains0();
                    this.domains = this.sort((List)this.filterExcludeInclude((List)e2));
                    log.info((Object)"Domains fetched", AbstractDatabase.fetchedSize(e2, this.domains));
                });
            } else {
                log.info("Domains excluded");
            }
        }
        return this.domains;
    }

    @Override
    public final List<DomainDefinition> getDomains(SchemaDefinition schema) {
        if (this.domainsBySchema == null) {
            this.domainsBySchema = new LinkedHashMap<SchemaDefinition, List<DomainDefinition>>();
        }
        return this.filterSchema(this.getDomains(), schema, this.domainsBySchema);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, String name) {
        return this.getDomain(schema, name, false);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getDomains(schema), name, ignoreCase);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, Name name) {
        return this.getDomain(schema, name, false);
    }

    @Override
    public final DomainDefinition getDomain(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getDomains(schema), name, ignoreCase);
    }

    @Override
    public final List<ArrayDefinition> getArrays(SchemaDefinition schema) {
        if (this.arrays == null) {
            this.arrays = new ArrayList<ArrayDefinition>();
            if (this.getIncludeUDTs()) {
                this.onError(Log.Level.ERROR, "Error while fetching ARRAYs", () -> {
                    List<ArrayDefinition> a2 = this.getArrays0();
                    this.arrays = this.sort((List)this.filterExcludeInclude((List)a2));
                    log.info((Object)"ARRAYs fetched", AbstractDatabase.fetchedSize(a2, this.arrays));
                });
            } else {
                log.info("ARRAYs excluded");
            }
        }
        if (this.arraysBySchema == null) {
            this.arraysBySchema = new LinkedHashMap<SchemaDefinition, List<ArrayDefinition>>();
        }
        return this.filterSchema(this.arrays, schema, this.arraysBySchema);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name) {
        return this.getArray(schema, name, false);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getArrays(schema), name, ignoreCase);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, Name name) {
        return this.getArray(schema, name, false);
    }

    @Override
    public final ArrayDefinition getArray(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getArrays(schema), name, ignoreCase);
    }

    @Override
    public final List<UDTDefinition> getUDTs() {
        if (this.udts == null) {
            this.udts = new ArrayList<UDTDefinition>();
            if (this.getIncludeUDTs()) {
                this.onError(Log.Level.ERROR, "Error while fetching UDTs", () -> {
                    List<UDTDefinition> u2 = this.getUDTs0();
                    this.udts = this.sort((List)this.filterExcludeInclude((List)u2));
                    log.info((Object)"UDTs fetched", AbstractDatabase.fetchedSize(u2, this.udts));
                });
            } else {
                log.info("UDTs excluded");
            }
        }
        return this.udts;
    }

    @Override
    public final List<UDTDefinition> getUDTs(SchemaDefinition schema) {
        if (this.udtsBySchema == null) {
            this.udtsBySchema = new LinkedHashMap<SchemaDefinition, List<UDTDefinition>>();
        }
        return this.filterSchema(this.getUDTs(), schema, this.udtsBySchema);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name) {
        return this.getUDT(schema, name, false);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, String name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getUDTs(schema), name, ignoreCase);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, Name name) {
        return this.getUDT(schema, name, false);
    }

    @Override
    public final UDTDefinition getUDT(SchemaDefinition schema, Name name, boolean ignoreCase) {
        return AbstractDatabase.getDefinition(this.getUDTs(schema), name, ignoreCase);
    }

    @Override
    public final List<UDTDefinition> getUDTs(PackageDefinition pkg) {
        if (this.udtsByPackage == null) {
            this.udtsByPackage = new LinkedHashMap<PackageDefinition, List<UDTDefinition>>();
        }
        return this.filterPackage(this.getUDTs(), pkg, this.udtsByPackage);
    }

    @Override
    public final Relations getRelations() {
        if (this.relations == null) {
            this.relations = new DefaultRelations();
            if (this.includeRelations) {
                this.onError(Log.Level.ERROR, "Error while fetching relations", () -> {
                    this.relations = this.getRelations0();
                });
            }
        }
        return this.relations;
    }

    @Override
    public final List<IndexDefinition> getIndexes(SchemaDefinition schema) {
        if (this.indexes == null) {
            this.indexes = new ArrayList<IndexDefinition>();
            if (this.getIncludeIndexes()) {
                this.onError(Log.Level.ERROR, "Error while fetching indexes", () -> {
                    List<IndexDefinition> r2 = this.getIndexes0();
                    this.indexes = this.sort((List)r2);
                    log.info((Object)"Indexes fetched", AbstractDatabase.fetchedSize(r2, this.indexes));
                });
            } else {
                log.info("Indexes excluded");
            }
        }
        if (this.indexesBySchema == null) {
            this.indexesBySchema = new LinkedHashMap<SchemaDefinition, List<IndexDefinition>>();
        }
        return this.filterSchema(this.indexes, schema, this.indexesBySchema);
    }

    @Override
    public final List<IndexDefinition> getIndexes(TableDefinition table) {
        List<IndexDefinition> list;
        if (this.indexesByTable == null) {
            this.indexesByTable = new HashMap<TableDefinition, List<IndexDefinition>>();
        }
        if ((list = this.indexesByTable.get(table)) == null) {
            list = new ArrayList<IndexDefinition>();
            this.indexesByTable.put(table, list);
            for (TableDefinition otherTable : this.getTables(table.getSchema())) {
                if (this.indexesByTable.containsKey(otherTable)) continue;
                this.indexesByTable.put(otherTable, new ArrayList());
            }
            for (IndexDefinition index : this.getIndexes(table.getSchema())) {
                this.indexesByTable.computeIfAbsent(index.getTable(), k2 -> new ArrayList()).add(index);
            }
        }
        return list;
    }

    @Override
    public final List<RoutineDefinition> getRoutines(SchemaDefinition schema) {
        if (this.routines == null) {
            this.routines = new ArrayList<RoutineDefinition>();
            if (this.getIncludeRoutines()) {
                this.onError(Log.Level.ERROR, "Error while fetching routines", () -> {
                    List<RoutineDefinition> r2 = this.getRoutines0();
                    this.routines = this.sort((List)this.filterExcludeInclude((List)r2));
                    log.info((Object)"Routines fetched", AbstractDatabase.fetchedSize(r2, this.routines));
                });
            } else {
                log.info("Routines excluded");
            }
        }
        if (this.routinesBySchema == null) {
            this.routinesBySchema = new LinkedHashMap<SchemaDefinition, List<RoutineDefinition>>();
        }
        return this.filterSchema(this.routines, schema, this.routinesBySchema);
    }

    @Override
    public final List<PackageDefinition> getPackages(SchemaDefinition schema) {
        if (this.packages == null) {
            this.packages = new ArrayList<PackageDefinition>();
            if (this.getIncludePackages()) {
                this.onError(Log.Level.ERROR, "Error while fetching packages", () -> {
                    List<PackageDefinition> p2 = this.getPackages0();
                    this.packages = this.sort((List)this.filterExcludeInclude((List)p2));
                    log.info((Object)"Packages fetched", AbstractDatabase.fetchedSize(p2, this.packages));
                });
            } else {
                log.info("Packages excluded");
            }
        }
        if (this.packagesBySchema == null) {
            this.packagesBySchema = new LinkedHashMap<SchemaDefinition, List<PackageDefinition>>();
        }
        return this.filterSchema(this.packages, schema, this.packagesBySchema);
    }

    @Override
    public PackageDefinition getPackage(SchemaDefinition schema, String inputName) {
        for (PackageDefinition pkg : this.getPackages(schema)) {
            if (!pkg.getName().equals(inputName)) continue;
            return pkg;
        }
        return null;
    }

    protected static final <D extends Definition> D getDefinition(List<D> definitions, String name, boolean ignoreCase) {
        if (name == null) {
            return null;
        }
        for (Definition definition : definitions) {
            if ((!ignoreCase || !definition.getName().equalsIgnoreCase(name)) && (ignoreCase || !definition.getName().equals(name))) continue;
            return (D)definition;
        }
        return null;
    }

    protected static final <D extends Definition> D getDefinition(List<D> definitions, Name name, boolean ignoreCase) {
        if (name == null) {
            return null;
        }
        for (Definition definition : definitions) {
            if ((!ignoreCase || !definition.getQualifiedNamePart().equalsIgnoreCase(name)) && (ignoreCase || !definition.getQualifiedNamePart().equals(name))) continue;
            return (D)definition;
        }
        return null;
    }

    protected final <T extends Definition> List<T> filterSchema(List<T> definitions, SchemaDefinition schema, Map<SchemaDefinition, List<T>> cache) {
        return cache.computeIfAbsent(schema, s2 -> this.filterSchema(definitions, (SchemaDefinition)s2));
    }

    protected final <T extends Definition> List<T> filterSchema(List<T> definitions, SchemaDefinition schema) {
        if (schema == null) {
            return definitions;
        }
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (Definition definition : definitions) {
            if (definition.getSchema() == null || !definition.getSchema().equals(schema)) continue;
            result.add(definition);
        }
        return result;
    }

    protected final <T extends Definition> List<T> filterPackage(List<T> definitions, PackageDefinition pkg, Map<PackageDefinition, List<T>> cache) {
        return cache.computeIfAbsent(pkg, p2 -> this.filterPackage(definitions, (PackageDefinition)p2));
    }

    protected final <T extends Definition> List<T> filterPackage(List<T> definitions, PackageDefinition pkg) {
        if (pkg == null) {
            return definitions;
        }
        ArrayList<Definition> result = new ArrayList<Definition>();
        for (Definition definition : definitions) {
            if (definition.getPackage() == null || !definition.getPackage().equals(pkg)) continue;
            result.add(definition);
        }
        return result;
    }

    protected final <T extends TableElementDefinition> List<T> filterTable(List<T> definitions, TableDefinition table, Map<TableDefinition, List<T>> cache) {
        List<T> result = cache.get(table);
        if (result == null) {
            result = this.filterTable(definitions, table);
            cache.put(table, result);
        }
        return result;
    }

    protected final <T extends TableElementDefinition> List<T> filterTable(List<T> definitions, TableDefinition table) {
        if (table == null) {
            return definitions;
        }
        ArrayList<TableElementDefinition> result = new ArrayList<TableElementDefinition>();
        for (TableElementDefinition definition : definitions) {
            if (!definition.getTable().equals(table)) continue;
            result.add(definition);
        }
        return result;
    }

    private final <T extends EmbeddableDefinition> List<T> filterReferencingTable(List<T> definitions, TableDefinition table, Map<TableDefinition, List<T>> cache) {
        List<T> result = cache.get(table);
        if (result == null) {
            result = this.filterReferencingTable(definitions, table);
            cache.put(table, result);
        }
        return result;
    }

    private final <T extends EmbeddableDefinition> List<T> filterReferencingTable(List<T> definitions, TableDefinition table) {
        if (table == null) {
            return definitions;
        }
        ArrayList<EmbeddableDefinition> result = new ArrayList<EmbeddableDefinition>();
        for (EmbeddableDefinition definition : definitions) {
            if (!definition.getReferencingTable().equals(table)) continue;
            result.add(definition);
        }
        return result;
    }

    public final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions) {
        List<T> result = this.filterExcludeInclude(definitions, this.excludes, this.includes, this.filters);
        this.all.addAll(definitions);
        this.included.addAll(result);
        this.excluded.addAll(definitions);
        this.excluded.removeAll(result);
        return result;
    }

    public final <T extends Definition> List<T> sort(List<T> definitions) {
        if (this.orderProvider != null) {
            definitions.sort(this.orderProvider);
        }
        return definitions;
    }

    @Override
    public final List<Definition> getIncluded() {
        return Collections.unmodifiableList(this.included);
    }

    @Override
    public final List<Definition> getExcluded() {
        return Collections.unmodifiableList(this.excluded);
    }

    @Override
    public final List<Definition> getAll() {
        return Collections.unmodifiableList(this.all);
    }

    protected final <T extends Definition> List<T> filter(List<T> definitions, String include) {
        return this.filterExcludeInclude(definitions, null, include);
    }

    protected final <T extends Definition> List<T> filter(List<T> definitions, List<String> include) {
        ArrayList<T> result = new ArrayList<T>();
        for (String i2 : include) {
            result.addAll(this.filter(definitions, i2));
        }
        return result;
    }

    protected final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions, String e2, String i2) {
        return this.filterExcludeInclude(definitions, new String[]{e2}, new String[]{i2 != null ? i2 : ".*"}, Collections.emptyList());
    }

    protected final <T extends Definition> List<T> filterExcludeInclude(List<T> definitions, String[] e2, String[] i2, List<Database.Filter> f2) {
        ArrayList<Definition> result = new ArrayList<Definition>();
        block0: for (Definition definition : definitions) {
            if (e2 != null) {
                for (String exclude : e2) {
                    if (exclude == null || !this.matches(this.patterns.pattern(exclude), definition)) continue;
                    if (!log.isDebugEnabled()) continue block0;
                    log.debug((Object)"Exclude", "Excluding " + definition.getQualifiedName() + " because of pattern " + exclude);
                    continue block0;
                }
            }
            if (i2 == null) continue;
            for (String include : i2) {
                if (include == null || !this.matches(this.patterns.pattern(include), definition)) continue;
                for (Database.Filter filter : f2) {
                    if (!filter.exclude(definition)) continue;
                    if (!log.isDebugEnabled()) continue block0;
                    log.debug((Object)"Exclude", "Excluding " + definition.getQualifiedName() + " because of filter " + filter);
                    continue block0;
                }
                result.add(definition);
                if (!log.isDebugEnabled()) continue block0;
                log.debug((Object)"Include", "Including " + definition.getQualifiedName() + " because of pattern " + include);
                continue block0;
            }
        }
        return result;
    }

    protected final Relations getRelations0() {
        DefaultRelations result;
        DefaultRelations defaultRelations = result = this.relations instanceof DefaultRelations ? (DefaultRelations)this.relations : new DefaultRelations();
        if (this.getIncludePrimaryKeys()) {
            this.onError(Log.Level.ERROR, "Error while fetching primary keys", () -> this.loadPrimaryKeys(result));
        }
        if (this.getIncludeUniqueKeys()) {
            this.onError(Log.Level.ERROR, "Error while fetching unique keys", () -> this.loadUniqueKeys(result));
        }
        if (this.getIncludeCheckConstraints()) {
            this.onError(Log.Level.ERROR, "Error while fetching check constraints", () -> this.loadCheckConstraints(result));
        }
        if (this.getIncludePrimaryKeys()) {
            this.onError(Log.Level.ERROR, "Error while generating synthetic primary keys", () -> this.syntheticPrimaryKeys(result));
            this.onError(Log.Level.ERROR, "Error while generating overridden primary keys", () -> this.overridePrimaryKeys(result));
        }
        if (this.getIncludeForeignKeys()) {
            this.onError(Log.Level.ERROR, "Error while fetching foreign keys", () -> this.loadForeignKeys(result));
        }
        return result;
    }

    @Override
    public final boolean isArrayType(String dataType) {
        String upper = dataType.toUpperCase();
        switch (this.getDialect().family()) {
            case H2: 
            case POSTGRES: 
            case YUGABYTEDB: {
                return "ARRAY".equals(upper) || upper.endsWith(" ARRAY") || upper.equals("ANYARRAY");
            }
        }
        return upper.endsWith(" ARRAY");
    }

    protected static final String fetchedSize(Collection<?> fetched, Collection<?> included) {
        return fetched.size() + " (" + included.size() + " included, " + (fetched.size() - included.size()) + " excluded)";
    }

    @Override
    public void setConfiguredComments(List<CommentType> configuredComments) {
        if (configuredComments != null) {
            this.getConfiguredComments().addAll(configuredComments);
            this.unusedComments.addAll(configuredComments);
            if (!configuredComments.isEmpty()) {
                log.info((Object)"Commercial feature", "Comments are a commercial only feature. Please upgrade to the jOOQ Professional Edition");
            }
        }
    }

    @Override
    public List<CommentType> getConfiguredComments() {
        if (this.configuredComments == null) {
            this.configuredComments = new ArrayList<CommentType>();
        }
        return this.configuredComments;
    }

    @Override
    public void markUsed(CommentType object) {
        this.unusedComments.remove(object);
    }

    @Override
    public List<CommentType> getUnusedComments() {
        return new ArrayList<CommentType>(this.unusedComments);
    }

    @Override
    public void setConfiguredSyntheticObjects(SyntheticObjectsType configuredSyntheticObjects) {
        if (configuredSyntheticObjects != null) {
            this.getConfiguredSyntheticReadonlyColumns().addAll(configuredSyntheticObjects.getReadonlyColumns());
            this.getConfiguredSyntheticReadonlyRowids().addAll(configuredSyntheticObjects.getReadonlyRowids());
            this.getConfiguredSyntheticIdentities().addAll(configuredSyntheticObjects.getIdentities());
            this.getConfiguredSyntheticPrimaryKeys().addAll(configuredSyntheticObjects.getPrimaryKeys());
            this.getConfiguredSyntheticUniqueKeys().addAll(configuredSyntheticObjects.getUniqueKeys());
            this.getConfiguredSyntheticForeignKeys().addAll(configuredSyntheticObjects.getForeignKeys());
            this.getConfiguredSyntheticViews().addAll(configuredSyntheticObjects.getViews());
            this.unusedSyntheticReadonlyColumns.addAll(configuredSyntheticObjects.getReadonlyColumns());
            this.unusedSyntheticReadonlyRowids.addAll(configuredSyntheticObjects.getReadonlyRowids());
            this.unusedSyntheticIdentities.addAll(configuredSyntheticObjects.getIdentities());
            this.unusedSyntheticPrimaryKeys.addAll(configuredSyntheticObjects.getPrimaryKeys());
            this.unusedSyntheticUniqueKeys.addAll(configuredSyntheticObjects.getUniqueKeys());
            this.unusedSyntheticForeignKeys.addAll(configuredSyntheticObjects.getForeignKeys());
            this.unusedSyntheticViews.addAll(configuredSyntheticObjects.getViews());
            if (!configuredSyntheticObjects.getReadonlyColumns().isEmpty()) {
                log.info((Object)"Commercial feature", "Synthetic read only columns are a commercial only feature. Please upgrade to the jOOQ Professional Edition");
            }
            if (!configuredSyntheticObjects.getReadonlyRowids().isEmpty()) {
                log.info((Object)"Commercial feature", "Synthetic read only rowids are a commercial only feature. Please upgrade to the jOOQ Professional Edition");
            }
            if (!configuredSyntheticObjects.getUniqueKeys().isEmpty()) {
                log.info((Object)"Commercial feature", "Synthetic unique keys are a commercial only feature. Please upgrade to the jOOQ Professional Edition");
            }
            if (!configuredSyntheticObjects.getForeignKeys().isEmpty()) {
                log.info((Object)"Commercial feature", "Synthetic foreign keys are a commercial only feature. Please upgrade to the jOOQ Professional Edition");
            }
        }
    }

    @Override
    public List<SyntheticReadonlyColumnType> getConfiguredSyntheticReadonlyColumns() {
        if (this.configuredSyntheticReadonlyColumns == null) {
            this.configuredSyntheticReadonlyColumns = new ArrayList<SyntheticReadonlyColumnType>();
        }
        return this.configuredSyntheticReadonlyColumns;
    }

    @Override
    public List<SyntheticReadonlyRowidType> getConfiguredSyntheticReadonlyRowids() {
        if (this.configuredSyntheticReadonlyRowids == null) {
            this.configuredSyntheticReadonlyRowids = new ArrayList<SyntheticReadonlyRowidType>();
        }
        return this.configuredSyntheticReadonlyRowids;
    }

    @Override
    public List<SyntheticIdentityType> getConfiguredSyntheticIdentities() {
        if (this.configuredSyntheticIdentities == null) {
            this.configuredSyntheticIdentities = new ArrayList<SyntheticIdentityType>();
        }
        return this.configuredSyntheticIdentities;
    }

    @Override
    public List<SyntheticPrimaryKeyType> getConfiguredSyntheticPrimaryKeys() {
        if (this.configuredSyntheticPrimaryKeys == null) {
            this.configuredSyntheticPrimaryKeys = new ArrayList<SyntheticPrimaryKeyType>();
        }
        return this.configuredSyntheticPrimaryKeys;
    }

    @Override
    public List<SyntheticUniqueKeyType> getConfiguredSyntheticUniqueKeys() {
        if (this.configuredSyntheticUniqueKeys == null) {
            this.configuredSyntheticUniqueKeys = new ArrayList<SyntheticUniqueKeyType>();
        }
        return this.configuredSyntheticUniqueKeys;
    }

    @Override
    public List<SyntheticForeignKeyType> getConfiguredSyntheticForeignKeys() {
        if (this.configuredSyntheticForeignKeys == null) {
            this.configuredSyntheticForeignKeys = new ArrayList<SyntheticForeignKeyType>();
        }
        return this.configuredSyntheticForeignKeys;
    }

    @Override
    public List<SyntheticViewType> getConfiguredSyntheticViews() {
        if (this.configuredSyntheticViews == null) {
            this.configuredSyntheticViews = new ArrayList<SyntheticViewType>();
        }
        return this.configuredSyntheticViews;
    }

    @Override
    public void markUsed(SyntheticReadonlyColumnType readonlyColumn) {
        this.unusedSyntheticReadonlyColumns.remove(readonlyColumn);
    }

    @Override
    public void markUsed(SyntheticReadonlyRowidType readonlyRowid) {
        this.unusedSyntheticReadonlyRowids.remove(readonlyRowid);
    }

    @Override
    public void markUsed(SyntheticIdentityType identity) {
        this.unusedSyntheticIdentities.remove(identity);
    }

    @Override
    public void markUsed(SyntheticPrimaryKeyType primaryKey) {
        this.unusedSyntheticPrimaryKeys.remove(primaryKey);
    }

    @Override
    public void markUsed(SyntheticUniqueKeyType uniqueKey) {
        this.unusedSyntheticUniqueKeys.remove(uniqueKey);
    }

    @Override
    public void markUsed(SyntheticForeignKeyType foreignKey) {
        this.unusedSyntheticForeignKeys.remove(foreignKey);
    }

    @Override
    public void markUsed(SyntheticViewType view) {
        this.unusedSyntheticViews.remove(view);
    }

    @Override
    public List<SyntheticReadonlyColumnType> getUnusedSyntheticReadonlyColumns() {
        return new ArrayList<SyntheticReadonlyColumnType>(this.unusedSyntheticReadonlyColumns);
    }

    @Override
    public List<SyntheticReadonlyRowidType> getUnusedSyntheticReadonlyRowids() {
        return new ArrayList<SyntheticReadonlyRowidType>(this.unusedSyntheticReadonlyRowids);
    }

    @Override
    public List<SyntheticIdentityType> getUnusedSyntheticIdentities() {
        return new ArrayList<SyntheticIdentityType>(this.unusedSyntheticIdentities);
    }

    @Override
    public List<SyntheticPrimaryKeyType> getUnusedSyntheticPrimaryKeys() {
        return new ArrayList<SyntheticPrimaryKeyType>(this.unusedSyntheticPrimaryKeys);
    }

    @Override
    public List<SyntheticUniqueKeyType> getUnusedSyntheticUniqueKeys() {
        return new ArrayList<SyntheticUniqueKeyType>(this.unusedSyntheticUniqueKeys);
    }

    @Override
    public List<SyntheticForeignKeyType> getUnusedSyntheticForeignKeys() {
        return new ArrayList<SyntheticForeignKeyType>(this.unusedSyntheticForeignKeys);
    }

    @Override
    public List<SyntheticViewType> getUnusedSyntheticViews() {
        return new ArrayList<SyntheticViewType>(this.unusedSyntheticViews);
    }

    private final void overridePrimaryKeys(DefaultRelations r2) {
        for (SyntheticPrimaryKeyType key : this.getConfiguredSyntheticPrimaryKeys()) {
            if (key.getKey() == null) continue;
            for (TableDefinition table : this.filter(this.getTables(), key.getTables())) {
                for (UniqueKeyDefinition uk : this.filter(table.getKeys(), key.getKey())) {
                    log.info((Object)"Overriding primary key", "" + uk);
                    r2.overridePrimaryKey(uk);
                    this.markUsed(key);
                }
            }
        }
    }

    private final void syntheticPrimaryKeys(DefaultRelations r2) {
        for (SyntheticPrimaryKeyType key : this.getConfiguredSyntheticPrimaryKeys()) {
            if (key.getKey() != null) continue;
            for (TableDefinition table : this.filter(this.getTables(), key.getTables())) {
                Object keyName;
                Object object = keyName = key.getName() != null ? key.getName() : "SYNTHETIC_PK_" + table.getName();
                List<ColumnDefinition> columns = this.filter(table.getColumns(), key.getFields());
                if (columns.isEmpty()) continue;
                this.markUsed(key);
                DefaultUniqueKeyDefinition pk2 = new DefaultUniqueKeyDefinition(table.getSchema(), (String)keyName, table, true);
                pk2.getKeyColumns().addAll(columns);
                log.info((Object)"Synthetic primary key", "" + pk2);
                r2.overridePrimaryKey(pk2);
            }
        }
    }

    private final DataTypeDefinition type(SchemaDefinition schema, Field<?> field) {
        return new DefaultDataTypeDefinition(schema.getDatabase(), schema, field.getDataType().getTypeName(), (Number)field.getDataType().length(), (Number)field.getDataType().precision(), (Number)field.getDataType().scale(), (Boolean)field.getDataType().nullable(), field.getDataType().defaultValue() == null ? null : this.create().renderInlined(field.getDataType().defaultValue()));
    }

    private final void syntheticViews(List<TableDefinition> t2) {
        for (SyntheticViewType view : this.getConfiguredSyntheticViews()) {
            SchemaDefinition schema;
            CatalogDefinition catalog = StringUtils.isBlank(view.getCatalog()) ? this.getCatalogs().get(0) : this.getCatalog(view.getCatalog());
            if (catalog == null) continue;
            SchemaDefinition schemaDefinition = schema = StringUtils.isBlank(view.getSchema()) ? catalog.getSchemata().get(0) : catalog.getSchema(view.getSchema());
            if (schema == null) continue;
            this.onError(Log.Level.ERROR, "Error while parsing view", () -> {
                Meta meta = this.create().meta();
                final ArrayList params = new ArrayList();
                Configuration configuration = this.create().configuration().deriveSettings(s2 -> s2.withParseWithMetaLookups(ParseWithMetaLookups.THROW_ON_FAILURE)).derive(() -> meta);
                configuration.data("org.jooq.parser.param-collector", param -> {
                    if (!param.isInline()) {
                        params.add(param);
                    }
                });
                final Select<?> select = configuration.dsl().parser().parseSelect(view.getSql());
                final AbstractRoutineDefinition routine = params.isEmpty() ? null : new AbstractRoutineDefinition(schema, null, view.getName(), view.getComment(), null){

                    @Override
                    protected void init0() throws SQLException {
                        int i2 = 0;
                        for (Param param : params) {
                            this.addParameter(InOutDefinition.IN, new DefaultParameterDefinition(this, param.getParamName(), ++i2, AbstractDatabase.this.type(schema, param)));
                        }
                    }
                };
                t2.add(new AbstractTableDefinition(schema, view.getName(), view.getComment(), routine == null ? TableOptions.TableType.VIEW : TableOptions.TableType.FUNCTION, view.getSql()){

                    @Override
                    public boolean isSynthetic() {
                        return true;
                    }

                    @Override
                    protected List<ColumnDefinition> getElements0() throws SQLException {
                        ArrayList<ColumnDefinition> result = new ArrayList<ColumnDefinition>();
                        int i2 = 0;
                        for (Field<?> field : select.getSelect()) {
                            result.add(new DefaultColumnDefinition(this, field.getName(), ++i2, AbstractDatabase.this.type(this.getSchema(), field), false, field.getComment()));
                        }
                        return result;
                    }

                    @Override
                    protected List<ParameterDefinition> getParameters0() {
                        ArrayList<ParameterDefinition> result = new ArrayList<ParameterDefinition>();
                        if (routine != null) {
                            result.addAll(routine.getInParameters());
                        }
                        return result;
                    }
                });
                log.info((Object)"Synthetic view added", view.getName());
            });
            this.markUsed(view);
        }
    }

    @Override
    public void close() {
    }

    protected abstract DSLContext create0();

    protected Map<Definition, String> getSources0() throws SQLException {
        return new LinkedHashMap<Definition, String>();
    }

    protected List<IndexDefinition> getIndexes0() throws SQLException {
        return Collections.emptyList();
    }

    protected abstract void loadPrimaryKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadUniqueKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadForeignKeys(DefaultRelations var1) throws SQLException;

    protected abstract void loadCheckConstraints(DefaultRelations var1) throws SQLException;

    protected abstract List<CatalogDefinition> getCatalogs0() throws SQLException;

    protected abstract List<SchemaDefinition> getSchemata0() throws SQLException;

    protected abstract List<SequenceDefinition> getSequences0() throws SQLException;

    protected abstract List<TableDefinition> getTables0() throws SQLException;

    protected abstract List<RoutineDefinition> getRoutines0() throws SQLException;

    protected abstract List<PackageDefinition> getPackages0() throws SQLException;

    protected abstract List<EnumDefinition> getEnums0() throws SQLException;

    protected abstract List<DomainDefinition> getDomains0() throws SQLException;

    protected abstract List<UDTDefinition> getUDTs0() throws SQLException;

    protected abstract List<ArrayDefinition> getArrays0() throws SQLException;

    protected final DataTypeDefinition getDataTypeForMAX_VAL(SchemaDefinition schema, BigInteger value) {
        DefaultDataTypeDefinition type = BigInteger.valueOf(127L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)2, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(32767L).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)4, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(Integer.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)9, (Number)0, (Boolean)false, (String)null) : (BigInteger.valueOf(Long.MAX_VALUE).compareTo(value) >= 0 ? new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)18, (Number)0, (Boolean)false, (String)null) : new DefaultDataTypeDefinition((Database)this, schema, SQLDataType.NUMERIC.getTypeName(), (Number)0, (Number)38, (Number)0, (Boolean)false, (String)null))));
        return type;
    }

    private void onError(Log.Level level, String message, ExceptionRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Exception e2) {
            switch (this.onError()) {
                case SILENT: {
                    break;
                }
                case LOG: {
                    log.log(level, (Object)message, e2);
                    break;
                }
                case FAIL: {
                    log.log(Log.Level.ERROR, (Object)"Code generation error", "An error was encountered during code generation. This can have various reasons:\n\n- There's a bug in jOOQ. Please report it here: https://github.com/jOOQ/jOOQ/issues/new/choose\n- Your database user doesn't have the necessary privileges to access a metadata table\n- The database connection suffered a failure\n\nThere are other reasons. If the error can be ignored, you can either:\n\n- Turn off the relevant feature in the code generator to avoid running into the error\n- Avoid fetching the relevant meta data by excluding the object from code generation\n- Use the <onError/> code generation configuration to specify the severity of such errors (for all errors!)\n\nSee https://www.jooq.org/doc/latest/manual/code-generation/codegen-advanced/codegen-config-onerror/\n");
                    throw new RuntimeException(e2);
                }
            }
        }
    }

    protected final Field<Integer> overload(Field<String> schema, Field<String> name, Field<String> order) {
        return DSL.when(DSL.count().over(DSL.partitionBy(schema, name)).gt(DSL.one()), DSL.rowNumber().over(DSL.partitionBy(schema, name).orderBy(order))).as("overload");
    }

    @FunctionalInterface
    private static interface ExceptionRunnable {
        public void run() throws Exception;
    }
}

