/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.jooq.Context;
import org.jooq.QueryPart;
import org.jooq.QueryPartInternal;
import org.jooq.impl.AbstractQueryPart;
import org.jooq.impl.ObjIntFunction;
import org.jooq.impl.QOM;
import org.jooq.impl.SeparatedQueryPart;
import org.jooq.impl.SimpleQueryPart;
import org.jooq.impl.Tools;

class QueryPartCollectionView<T extends QueryPart>
extends AbstractQueryPart
implements QOM.UnmodifiableCollection<T>,
SimpleQueryPart,
SeparatedQueryPart {
    final Collection<T> wrapped;
    Boolean qualify;
    String separator;
    ObjIntFunction<? super T, ? extends T> mapper;

    static final <T extends QueryPart> QueryPartCollectionView<T> wrap(Collection<T> wrapped) {
        return new QueryPartCollectionView<T>(wrapped);
    }

    QueryPartCollectionView(Collection<T> wrapped) {
        Collection<T> collection = this.wrapped = wrapped != null ? wrapped : Collections.emptyList();
        if (wrapped instanceof QueryPartCollectionView) {
            QueryPartCollectionView v2 = (QueryPartCollectionView)wrapped;
            this.qualify = v2.qualify;
            this.separator = v2.separator;
            this.mapper = v2.mapper;
        } else {
            this.separator = ",";
        }
    }

    QueryPartCollectionView<T> qualify(boolean newQualify) {
        this.qualify = newQualify;
        return this;
    }

    QueryPartCollectionView<T> map(Function<? super T, ? extends T> newMapper) {
        return this.map((? super T t2, int i2) -> (QueryPart)newMapper.apply(t2));
    }

    QueryPartCollectionView<T> map(ObjIntFunction<? super T, ? extends T> newMapper) {
        this.mapper = this.mapper == null ? newMapper : this.mapper.andThen(newMapper);
        return this;
    }

    QueryPartCollectionView<T> separator(String newSeparator) {
        this.separator = newSeparator;
        return this;
    }

    Collection<T> wrapped() {
        return this.wrapped;
    }

    @Override
    public boolean isSimple(Context<?> ctx) {
        return !Tools.anyMatch(this, e2 -> !Tools.isSimple(ctx, e2));
    }

    @Override
    public boolean rendersSeparator() {
        if (this.isEmpty()) {
            return false;
        }
        return Tools.isRendersSeparator((QueryPart)Tools.last(this.wrapped));
    }

    @Override
    public boolean rendersContent(Context<?> ctx) {
        return !this.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(Context<?> ctx) {
        boolean indent;
        BitSet rendersContent = new BitSet(this.size());
        int i2 = 0;
        for (QueryPart e2 : this) {
            rendersContent.set(i2++, ((QueryPartInternal)e2).rendersContent(ctx));
        }
        int size = rendersContent.cardinality();
        boolean format = ctx.format() && (size >= 2 && !this.isSimple(ctx) || size > 4);
        boolean previousQualify = ctx.qualify();
        boolean previousAlreadyIndented = Boolean.TRUE.equals(ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED));
        boolean bl2 = indent = format && !previousAlreadyIndented;
        if (previousAlreadyIndented) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, false);
        }
        if (this.qualify != null) {
            ctx.qualify(this.qualify);
        }
        if (indent) {
            ctx.formatIndentStart();
        }
        if (ctx.separatorRequired()) {
            if (format) {
                ctx.formatSeparator();
            } else {
                ctx.sql(' ');
            }
        }
        if (size == 0) {
            this.toSQLEmptyList(ctx);
        } else {
            int j2 = 0;
            int k2 = 0;
            QueryPart prev = null;
            for (QueryPart part : this) {
                try {
                    int j0 = j2;
                    if (!rendersContent.get(j2++)) continue;
                    if (this.mapper != null) {
                        part = (QueryPart)this.mapper.apply(part, j0);
                    }
                    if (k2++ > 0) {
                        if (!(prev instanceof SeparatedQueryPart) || !((SeparatedQueryPart)((Object)prev)).rendersSeparator()) {
                            ctx.sql(this.separator);
                        }
                        if (format) {
                            ctx.formatSeparator();
                        } else {
                            ctx.sql(' ');
                        }
                    } else if (indent) {
                        ctx.formatNewLine();
                    }
                    if (indent) {
                        QueryPart t2 = part;
                        ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, t2 instanceof QueryPartCollectionView && ((QueryPartCollectionView)t2).size() > 1, c2 -> this.acceptElement((Context<?>)c2, (T)t2));
                        continue;
                    }
                    this.acceptElement(ctx, part);
                }
                finally {
                    prev = part;
                }
            }
        }
        if (indent) {
            ctx.formatIndentEnd().formatNewLine();
        }
        if (this.qualify != null) {
            ctx.qualify(previousQualify);
        }
        if (previousAlreadyIndented) {
            ctx.data((Object)Tools.BooleanDataKey.DATA_LIST_ALREADY_INDENTED, previousAlreadyIndented);
        }
    }

    protected void acceptElement(Context<?> ctx, T part) {
        ctx.visit((QueryPart)part);
    }

    protected void toSQLEmptyList(Context<?> context) {
    }

    @Override
    public final int size() {
        return this.wrapped.size();
    }

    @Override
    public final boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public final boolean contains(Object o2) {
        return this.wrapped.contains(o2);
    }

    @Override
    public final Iterator<T> iterator() {
        return this.wrapped.iterator();
    }

    @Override
    public final Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public final <E> E[] toArray(E[] a2) {
        return this.wrapped.toArray(a2);
    }

    @Override
    public final boolean add(T e2) {
        if (e2 != null) {
            return this.wrapped.add(e2);
        }
        return false;
    }

    @Override
    public final boolean remove(Object o2) {
        return this.wrapped.remove(o2);
    }

    @Override
    public final boolean containsAll(Collection<?> c2) {
        return this.wrapped.containsAll(c2);
    }

    final void addAll(Iterable<? extends T> c2) {
        if (c2 != null) {
            for (QueryPart t2 : c2) {
                if (t2 == null) continue;
                this.add((T)t2);
            }
        }
    }

    @Override
    public final boolean addAll(Collection<? extends T> c2) {
        return this.wrapped.addAll(this.removeNulls(c2));
    }

    final Collection<? extends T> removeNulls(Collection<? extends T> c2) {
        boolean containsNulls;
        try {
            containsNulls = c2.contains(null);
        }
        catch (NullPointerException ignore) {
            containsNulls = false;
        }
        if (containsNulls) {
            ArrayList<T> list = new ArrayList<T>(c2);
            list.removeIf(Objects::isNull);
            return list;
        }
        return c2;
    }

    @Override
    public final boolean removeAll(Collection<?> c2) {
        return this.wrapped.removeAll(c2);
    }

    @Override
    public final boolean retainAll(Collection<?> c2) {
        return this.wrapped.retainAll(c2);
    }

    @Override
    public final void clear() {
        this.wrapped.clear();
    }

    @Override
    public int hashCode() {
        return this.wrapped.hashCode();
    }

    @Override
    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that instanceof List && !(this instanceof List)) {
            return false;
        }
        if (that instanceof QueryPartCollectionView) {
            return this.wrapped.equals(((QueryPartCollectionView)that).wrapped);
        }
        return super.equals(that);
    }
}

