/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.impl;

import io.r2dbc.spi.ConnectionFactory;
import java.sql.Connection;
import java.sql.SQLException;
import org.jooq.Configuration;
import org.jooq.ExecuteListener;
import org.jooq.Query;
import org.jooq.conf.SettingsTools;
import org.jooq.exception.ControlFlowSignal;
import org.jooq.impl.AbstractBatch;
import org.jooq.impl.DSL;
import org.jooq.impl.DefaultExecuteContext;
import org.jooq.impl.ExecuteListeners;
import org.jooq.impl.NoConnectionFactory;
import org.jooq.impl.R2DBC;
import org.jooq.impl.SettingsEnabledPreparedStatement;
import org.jooq.impl.Tools;
import org.reactivestreams.Subscriber;

final class BatchMultiple
extends AbstractBatch {
    final Query[] queries;

    public BatchMultiple(Configuration configuration, Query ... queries) {
        super(configuration);
        this.queries = queries;
    }

    @Override
    public final int size() {
        return this.queries.length;
    }

    @Override
    public final void subscribe(Subscriber<? super Integer> subscriber) {
        ConnectionFactory cf2 = this.configuration.connectionFactory();
        if (cf2 instanceof NoConnectionFactory) {
            throw new UnsupportedOperationException();
        }
        subscriber.onSubscribe(new R2DBC.BatchSubscription<BatchMultiple>(this, subscriber, s2 -> new R2DBC.BatchMultipleSubscriber(this, (R2DBC.BatchSubscription<BatchMultiple>)s2)));
    }

    @Override
    public final int[] execute() {
        return BatchMultiple.execute(this.configuration, this.queries);
    }

    static int[] execute(Configuration configuration, Query[] queries) {
        DefaultExecuteContext ctx = new DefaultExecuteContext(configuration, queries);
        ExecuteListener listener = ExecuteListeners.get(ctx);
        Connection connection = ctx.connection();
        try {
            int i2;
            listener.start(ctx);
            if (ctx.statement() == null) {
                ctx.statement(new SettingsEnabledPreparedStatement(connection));
            }
            String[] batchSQL = ctx.batchSQL();
            for (i2 = 0; i2 < queries.length; ++i2) {
                ctx.sql(null);
                listener.renderStart(ctx);
                batchSQL[i2] = DSL.using(configuration).renderInlined(queries[i2]);
                ctx.sql(batchSQL[i2]);
                listener.renderEnd(ctx);
            }
            for (i2 = 0; i2 < queries.length; ++i2) {
                ctx.sql(batchSQL[i2]);
                listener.prepareStart(ctx);
                ctx.statement().addBatch(batchSQL[i2]);
                listener.prepareEnd(ctx);
            }
            int t2 = SettingsTools.getQueryTimeout(0, ctx.settings());
            if (t2 != 0) {
                ctx.statement().setQueryTimeout(t2);
            }
            listener.executeStart(ctx);
            int[] result = ctx.statement().executeBatch();
            int[] batchRows = ctx.batchRows();
            for (int i3 = 0; i3 < batchRows.length && i3 < result.length; ++i3) {
                batchRows[i3] = result[i3];
            }
            listener.executeEnd(ctx);
            int[] nArray = result;
            return nArray;
        }
        catch (ControlFlowSignal e2) {
            throw e2;
        }
        catch (RuntimeException e3) {
            ctx.exception(e3);
            listener.exception(ctx);
            throw ctx.exception();
        }
        catch (SQLException e4) {
            ctx.sqlException(e4);
            listener.exception(ctx);
            throw ctx.exception();
        }
        finally {
            Tools.safeClose(listener, ctx);
        }
    }
}

