/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Scanner;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jooq.CLIUtil;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.ParseNameCase;
import org.jooq.conf.ParseUnknownFunctions;
import org.jooq.conf.ParseUnsupportedSyntax;
import org.jooq.conf.RenderKeywordCase;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.RenderOptionalKeyword;
import org.jooq.conf.RenderQuotedNames;
import org.jooq.conf.Settings;
import org.jooq.conf.TransformUnneededArithmeticExpressions;
import org.jooq.conf.Transformation;
import org.jooq.impl.DSL;
import org.jooq.impl.ParserException;

public final class ParserCLI {
    private static final Pattern FLAG = Pattern.compile("^/([\\w\\-]+)(?:\\s+(\\w+))?\\s*$");

    public static final void main(String ... args) throws Exception {
        CLIUtil.main("https://www.jooq.org/doc/latest/manual/sql-building/sql-parser/sql-parser-cli/", () -> {
            Settings settings = new Settings();
            Args a2 = ParserCLI.parse(args);
            ParserCLI.settings(a2, settings);
            DSLContext ctx = ParserCLI.ctx(a2, settings);
            if (a2.interactive || args == null || args.length == 0) {
                ParserCLI.interactiveMode(ctx, a2);
            } else if (!a2.done) {
                if (a2.toDialect == null || a2.sql == null) {
                    System.out.println("Mandatory arguments: -T and -s. Use -h for help");
                    throw new RuntimeException();
                }
                ParserCLI.render(ctx, a2);
            }
        });
    }

    private static final DSLContext ctx(Args a2, Settings settings) {
        return DSL.using(a2.toDialect, settings);
    }

    private static final void settings(Args a2, Settings settings) {
        if (a2.formatted != null) {
            settings.setRenderFormatted(a2.formatted);
        }
        if (a2.keywords != null) {
            settings.setRenderKeywordCase(a2.keywords);
        }
        if (a2.name != null) {
            settings.setRenderNameCase(a2.name);
        }
        if (a2.quoted != null) {
            settings.setRenderQuotedNames(a2.quoted);
        }
        if (a2.fromDialect != null) {
            settings.setParseDialect(a2.fromDialect);
        }
        if (a2.parseDateFormat != null) {
            settings.setParseDateFormat(a2.parseDateFormat);
        }
        if (a2.parseIgnoreComments != null) {
            settings.setParseIgnoreComments(a2.parseIgnoreComments);
        }
        if (a2.parseIgnoreCommentStart != null) {
            settings.setParseIgnoreCommentStart(a2.parseIgnoreCommentStart);
        }
        if (a2.parseIgnoreCommentStop != null) {
            settings.setParseIgnoreCommentStop(a2.parseIgnoreCommentStop);
        }
        if (a2.parseLocale != null) {
            settings.setParseLocale(a2.parseLocale);
        }
        if (a2.parseNameCase != null) {
            settings.setParseNameCase(a2.parseNameCase);
        }
        if (a2.parseNamedParamPrefix != null) {
            settings.setParseNamedParamPrefix(a2.parseNamedParamPrefix);
        }
        if (a2.parseRetainCommentsBetweenQueries != null) {
            settings.setParseRetainCommentsBetweenQueries(a2.parseRetainCommentsBetweenQueries);
        }
        if (a2.parseSetCommands != null) {
            settings.setParseSetCommands(a2.parseSetCommands);
        }
        if (a2.parseTimestampFormat != null) {
            settings.setParseTimestampFormat(a2.parseTimestampFormat);
        }
        if (a2.parseUnknownFunctions != null) {
            settings.setParseUnknownFunctions(a2.parseUnknownFunctions);
        }
        if (a2.renderCoalesceToEmptyStringInConcat != null) {
            settings.setRenderCoalesceToEmptyStringInConcat(a2.renderCoalesceToEmptyStringInConcat);
        }
        if (a2.renderOptionalInnerKeyword != null) {
            settings.setRenderOptionalInnerKeyword(a2.renderOptionalInnerKeyword);
        }
        if (a2.renderOptionalOuterKeyword != null) {
            settings.setRenderOptionalOuterKeyword(a2.renderOptionalOuterKeyword);
        }
        if (a2.renderOptionalAsKeywordForFieldAliases != null) {
            settings.setRenderOptionalAsKeywordForFieldAliases(a2.renderOptionalAsKeywordForFieldAliases);
        }
        if (a2.renderOptionalAsKeywordForTableAliases != null) {
            settings.setRenderOptionalAsKeywordForTableAliases(a2.renderOptionalAsKeywordForTableAliases);
        }
        if (a2.transformAnsiJoinToTableLists != null) {
            settings.setTransformAnsiJoinToTableLists(a2.transformAnsiJoinToTableLists);
        }
        if (a2.transformTableListsToAnsiJoin != null) {
            settings.setTransformTableListsToAnsiJoin(a2.transformTableListsToAnsiJoin);
        }
        if (a2.transformUnneededArithmetic != null) {
            settings.setTransformUnneededArithmeticExpressions(a2.transformUnneededArithmetic);
        }
        if (a2.transformQualify != null) {
            settings.setTransformRownum(a2.transformQualify);
        }
        if (a2.transformRownum != null) {
            settings.setTransformRownum(a2.transformRownum);
        }
    }

    private static final <E extends Enum<E>> void parseInteractive(Class<E> type, String arg, Consumer<? super E> onSuccess, Runnable display) {
        try {
            if (arg != null) {
                onSuccess.accept(Enum.valueOf(type, arg.toUpperCase()));
            }
            display.run();
        }
        catch (IllegalArgumentException e2) {
            ParserCLI.invalid(arg, type);
        }
    }

    private static final void interactiveMode(DSLContext ctx, Args a2) {
        Scanner scan = new Scanner(System.in);
        System.out.print("> ");
        do {
            String line = scan.nextLine();
            a2.history.add(line);
            boolean leadingSlash = line.matches("^/[^/*].*$");
            if (a2.sql == null && leadingSlash) {
                if ("/q".equals(line) || "/quit".equals(line) || "/e".equals(line) || "/exit".equals(line)) {
                    System.out.println("Bye");
                    break;
                }
                if ("/?".equals(line) || "/h".equals(line) || "/help".equals(line)) {
                    ParserCLI.helpInteractive();
                } else if ("/d".equals(line) || "/display".equals(line)) {
                    ParserCLI.displayArguments(a2);
                } else {
                    Matcher matcher = FLAG.matcher(line);
                    if (matcher.find()) {
                        String flag = matcher.group(1);
                        String arg = matcher.group(2);
                        if (flag != null) {
                            if ("f".equals(flag) || "formatted".equals(flag)) {
                                if (arg != null) {
                                    a2.formatted = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayFormatted(a2);
                            } else if ("k".equals(flag) || "keyword".equals(flag)) {
                                ParserCLI.parseInteractive(RenderKeywordCase.class, arg, e2 -> {
                                    a2.keywords = e2;
                                }, () -> ParserCLI.displayKeywords(a2));
                            } else if ("i".equals(flag) || "identifier".equals(flag)) {
                                ParserCLI.parseInteractive(RenderNameCase.class, arg, e2 -> {
                                    a2.name = e2;
                                }, () -> ParserCLI.displayIdentifiers(a2));
                            } else if ("Q".equals(flag) || "quoted".equals(flag)) {
                                ParserCLI.parseInteractive(RenderQuotedNames.class, arg, e2 -> {
                                    a2.quoted = e2;
                                }, () -> ParserCLI.displayQuoted(a2));
                            } else if ("F".equals(flag) || "from-dialect".equals(flag)) {
                                ParserCLI.parseInteractive(SQLDialect.class, arg, e2 -> {
                                    a2.fromDialect = e2;
                                }, () -> ParserCLI.displayFromDialect(a2));
                            } else if ("render-coalesce-to-empty-string-in-concat".equals(flag)) {
                                if (arg != null) {
                                    a2.renderCoalesceToEmptyStringInConcat = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayRenderCoalesceToEmptyStringInConcat(a2);
                            } else if ("parse-date-format".equals(flag)) {
                                if (arg != null) {
                                    a2.parseDateFormat = arg;
                                }
                                ParserCLI.displayParseDateFormat(a2);
                            } else if ("parse-ignore-comments".equals(flag)) {
                                if (arg != null) {
                                    a2.parseIgnoreComments = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayParseIgnoreComments(a2);
                            } else if ("parse-ignore-comment-start".equals(flag)) {
                                if (arg != null) {
                                    a2.parseIgnoreCommentStart = arg;
                                }
                                ParserCLI.displayParseIgnoreCommentStart(a2);
                            } else if ("parse-ignore-comment-stop".equals(flag)) {
                                if (arg != null) {
                                    a2.parseIgnoreCommentStop = arg;
                                }
                                ParserCLI.displayParseIgnoreCommentStop(a2);
                            } else if ("parse-locale".equals(flag)) {
                                if (arg != null) {
                                    a2.parseLocale = Locale.forLanguageTag(arg);
                                }
                                ParserCLI.displayParseLocale(a2);
                            } else if ("parse-name-case".equals(flag)) {
                                ParserCLI.parseInteractive(ParseNameCase.class, arg, e2 -> {
                                    a2.parseNameCase = e2;
                                }, () -> ParserCLI.displayParseNameCase(a2));
                            } else if ("parse-named-param-prefix".equals(flag)) {
                                if (arg != null) {
                                    a2.parseNamedParamPrefix = arg;
                                }
                                ParserCLI.displayParseNamedParamPrefix(a2);
                            } else if ("parse-retain-comments-between-queries".equals(flag)) {
                                if (arg != null) {
                                    a2.parseRetainCommentsBetweenQueries = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayParseRetainCommentsBetweenQueries(a2);
                            } else if ("parse-set-commands".equals(flag)) {
                                if (arg != null) {
                                    a2.parseSetCommands = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayParseSetCommands(a2);
                            } else if ("parse-timestamp-format".equals(flag)) {
                                if (arg != null) {
                                    a2.parseTimestampFormat = arg;
                                }
                                ParserCLI.displayParseTimestampFormat(a2);
                            } else if ("parse-unknown-functions".equals(flag)) {
                                ParserCLI.parseInteractive(ParseUnknownFunctions.class, arg, e2 -> {
                                    a2.parseUnknownFunctions = e2;
                                }, () -> ParserCLI.displayParseUnknownFunctions(a2));
                            } else if ("parse-unsupported-syntax".equals(flag)) {
                                ParserCLI.parseInteractive(ParseUnsupportedSyntax.class, arg, e2 -> {
                                    a2.parseUnsupportedSyntax = e2;
                                }, () -> ParserCLI.displayParseUnsupportedSyntax(a2));
                            } else if ("render-optional-inner-keyword".equals(flag)) {
                                ParserCLI.parseInteractive(RenderOptionalKeyword.class, arg, e2 -> {
                                    a2.renderOptionalInnerKeyword = e2;
                                }, () -> ParserCLI.displayRenderOptionalInnerKeyword(a2));
                            } else if ("render-optional-outer-keyword".equals(flag)) {
                                ParserCLI.parseInteractive(RenderOptionalKeyword.class, arg, e2 -> {
                                    a2.renderOptionalOuterKeyword = e2;
                                }, () -> ParserCLI.displayRenderOptionalOuterKeyword(a2));
                            } else if ("render-optional-as-keyword-for-field-aliases".equals(flag)) {
                                ParserCLI.parseInteractive(RenderOptionalKeyword.class, arg, e2 -> {
                                    a2.renderOptionalAsKeywordForFieldAliases = e2;
                                }, () -> ParserCLI.displayRenderOptionalAsKeywordForFieldAliases(a2));
                            } else if ("render-optional-as-keyword-for-table-aliases".equals(flag)) {
                                ParserCLI.parseInteractive(RenderOptionalKeyword.class, arg, e2 -> {
                                    a2.renderOptionalAsKeywordForTableAliases = e2;
                                }, () -> ParserCLI.displayRenderOptionalAsKeywordForTableAliases(a2));
                            } else if ("transform-ansi-join-to-table-lists".equals(flag)) {
                                if (arg != null) {
                                    a2.transformAnsiJoinToTableLists = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayTransformAnsiJoinToTablesLists(a2);
                            } else if ("transform-qualify".equals(flag)) {
                                ParserCLI.parseInteractive(Transformation.class, arg, e2 -> {
                                    a2.transformQualify = e2;
                                }, () -> ParserCLI.displayTransformQualify(a2));
                            } else if ("transform-rownum".equals(flag)) {
                                ParserCLI.parseInteractive(Transformation.class, arg, e2 -> {
                                    a2.transformRownum = e2;
                                }, () -> ParserCLI.displayTransformRownum(a2));
                            } else if ("transform-table-lists-to-ansi-join".equals(flag)) {
                                if (arg != null) {
                                    a2.transformTableListsToAnsiJoin = Boolean.parseBoolean(arg.toLowerCase());
                                }
                                ParserCLI.displayTransformTableListsToAnsiJoin(a2);
                            } else if ("transform-unneeded-arithmetic".equals(flag)) {
                                ParserCLI.parseInteractive(TransformUnneededArithmeticExpressions.class, arg, e2 -> {
                                    a2.transformUnneededArithmetic = e2;
                                }, () -> ParserCLI.displayTransformUnneededArithmetic(a2));
                            } else if ("t".equals(flag) || "T".equals(flag) || "to-dialect".equals(flag)) {
                                ParserCLI.parseInteractive(SQLDialect.class, arg, e2 -> {
                                    a2.toDialect = e2;
                                }, () -> ParserCLI.displayToDialect(a2));
                            }
                        }
                    } else {
                        System.out.println("Unrecognised command: " + line);
                        System.out.println("Type /h for help");
                    }
                }
                ParserCLI.settings(a2, ctx.settings());
                ctx = ParserCLI.ctx(a2, ctx.settings());
            }
            if (a2.sql != null || !leadingSlash) {
                a2.sql = a2.sql == null ? line : a2.sql + "\n" + line;
                if (a2.sql.trim().endsWith(";")) {
                    ParserCLI.render(ctx, a2);
                    a2.sql = null;
                    System.out.println();
                }
            }
            System.out.print("> ");
        } while (scan.hasNextLine());
    }

    private static final void displayArguments(Args a2) {
        ParserCLI.displayFormatted(a2);
        ParserCLI.displayFromDialect(a2);
        ParserCLI.displayToDialect(a2);
        ParserCLI.displayKeywords(a2);
        ParserCLI.displayIdentifiers(a2);
        ParserCLI.displayQuoted(a2);
        ParserCLI.displayTransformAnsiJoinToTablesLists(a2);
        ParserCLI.displayTransformQualify(a2);
        ParserCLI.displayTransformRownum(a2);
        ParserCLI.displayTransformTableListsToAnsiJoin(a2);
        ParserCLI.displayTransformUnneededArithmetic(a2);
    }

    private static void displayIdentifiers(Args a2) {
        System.out.println("Identifiers                        : " + a2.name);
    }

    private static void displayQuoted(Args a2) {
        System.out.println("Quoted                             : " + a2.quoted);
    }

    private static void displayKeywords(Args a2) {
        System.out.println("Keywords                           : " + a2.keywords);
    }

    private static void displayToDialect(Args a2) {
        System.out.println("To dialect                         : " + a2.toDialect);
    }

    private static void displayFromDialect(Args a2) {
        System.out.println("From dialect                       : " + a2.fromDialect);
    }

    private static void displayFormatted(Args a2) {
        System.out.println("Formatted                          : " + a2.formatted);
    }

    private static void displayParseDateFormat(Args a2) {
        System.out.println("Parse date format                  : " + a2.parseDateFormat);
    }

    private static void displayParseIgnoreComments(Args a2) {
        System.out.println("Parse ignore comments              : " + a2.parseIgnoreComments);
    }

    private static void displayParseIgnoreCommentStart(Args a2) {
        System.out.println("Parse ignore comment start         : " + a2.parseIgnoreCommentStart);
    }

    private static void displayParseIgnoreCommentStop(Args a2) {
        System.out.println("Parse ignore comment stop          : " + a2.parseIgnoreCommentStop);
    }

    private static void displayParseLocale(Args a2) {
        System.out.println("Parse locale                       : " + a2.parseLocale);
    }

    private static void displayParseNameCase(Args a2) {
        System.out.println("Parse name case                    : " + a2.parseNameCase);
    }

    private static void displayParseNamedParamPrefix(Args a2) {
        System.out.println("Parse named param prefix           : " + a2.parseNamedParamPrefix);
    }

    private static void displayParseRetainCommentsBetweenQueries(Args a2) {
        System.out.println("Retain comments between queries    : " + a2.parseRetainCommentsBetweenQueries);
    }

    private static void displayParseSetCommands(Args a2) {
        System.out.println("Parse set commands                 : " + a2.parseSetCommands);
    }

    private static void displayParseTimestampFormat(Args a2) {
        System.out.println("Parse timestamp format             : " + a2.parseTimestampFormat);
    }

    private static void displayParseUnknownFunctions(Args a2) {
        System.out.println("Parse unknown functions            : " + a2.parseUnknownFunctions);
    }

    private static void displayParseUnsupportedSyntax(Args a2) {
        System.out.println("Parse unsupported syntax           : " + a2.parseUnsupportedSyntax);
    }

    private static void displayRenderCoalesceToEmptyStringInConcat(Args a2) {
        System.out.println("Render COALESCE(X, '') in CONCAT   : " + a2.renderCoalesceToEmptyStringInConcat);
    }

    private static void displayRenderOptionalInnerKeyword(Args a2) {
        System.out.println("Render INNER keyword in INNER JOIN : " + a2.renderOptionalInnerKeyword);
    }

    private static void displayRenderOptionalOuterKeyword(Args a2) {
        System.out.println("Render OUTER keyword in OUTER JOIN : " + a2.renderOptionalOuterKeyword);
    }

    private static void displayRenderOptionalAsKeywordForFieldAliases(Args a2) {
        System.out.println("Render AS keyword to alias fields  :" + a2.renderOptionalAsKeywordForFieldAliases);
    }

    private static void displayRenderOptionalAsKeywordForTableAliases(Args a2) {
        System.out.println("Render AS keyword to alias tables  :" + a2.renderOptionalAsKeywordForTableAliases);
    }

    private static void displayTransformAnsiJoinToTablesLists(Args a2) {
        System.out.println("Transform ANSI join to table lists : " + a2.transformAnsiJoinToTableLists);
    }

    private static void displayTransformQualify(Args a2) {
        System.out.println("Transform QUALIFY                  : " + a2.transformQualify);
    }

    private static void displayTransformRownum(Args a2) {
        System.out.println("Transform ROWNUM                   : " + a2.transformRownum);
    }

    private static void displayTransformTableListsToAnsiJoin(Args a2) {
        System.out.println("Transform table lists to ANSI join : " + a2.transformTableListsToAnsiJoin);
    }

    private static void displayTransformUnneededArithmetic(Args a2) {
        System.out.println("Transform unneeded arithmetic      : " + a2.transformUnneededArithmetic);
    }

    private static final void render(DSLContext ctx, Args a2) {
        String sql = a2.sql.trim();
        try {
            System.out.println(ctx.render(ctx.parser().parse(a2.sql)));
        }
        catch (ParserException e1) {
            ParserException e2 = e1;
            if (!sql.matches("^(?is:(?:ALTER|BEGIN|COMMENT|CREATE|DECLARE|DELETE|DESCRIBE|DROP|GRANT|INSERT|MERGE|RENAME|REVOKE|SELECT|SET|SHOW|TRUNCATE|UPDATE|USE).*)$")) {
                try {
                    System.out.println(ctx.render(ctx.parser().parseField(a2.sql)));
                }
                catch (ParserException e22) {
                    e2 = e1.position() >= e22.position() ? e1 : e22;
                }
            }
            System.out.println(e2.getMessage());
        }
    }

    private static final <E extends Enum<E>> E parse(Class<E> type, String value) {
        try {
            return Enum.valueOf(type, value.toUpperCase());
        }
        catch (IllegalArgumentException e2) {
            ParserCLI.invalid(value, type);
            throw e2;
        }
    }

    private static final <E extends Enum<E>> Args parse(String[] args) {
        Args result = new Args();
        for (int i2 = 0; i2 < args.length; ++i2) {
            Class enumArgument = null;
            try {
                if ("-f".equals(args[i2]) || "--formatted".equals(args[i2])) {
                    result.formatted = true;
                    continue;
                }
                if ("-k".equals(args[i2]) || "--keyword".equals(args[i2])) {
                    enumArgument = RenderKeywordCase.class;
                    result.keywords = ParserCLI.parse(RenderKeywordCase.class, args[++i2]);
                    continue;
                }
                if ("-i".equals(args[i2]) || "--identifier".equals(args[i2])) {
                    enumArgument = RenderNameCase.class;
                    result.name = ParserCLI.parse(RenderNameCase.class, args[++i2]);
                    continue;
                }
                if ("-Q".equals(args[i2]) || "--quoted".equals(args[i2])) {
                    enumArgument = RenderQuotedNames.class;
                    result.quoted = ParserCLI.parse(RenderQuotedNames.class, args[++i2]);
                    continue;
                }
                if ("-F".equals(args[i2]) || "--from-dialect".equals(args[i2])) {
                    enumArgument = SQLDialect.class;
                    result.fromDialect = ParserCLI.parse(SQLDialect.class, args[++i2]);
                    continue;
                }
                if ("-t".equals(args[i2]) || "-T".equals(args[i2]) || "--to-dialect".equals(args[i2])) {
                    enumArgument = SQLDialect.class;
                    result.toDialect = ParserCLI.parse(SQLDialect.class, args[++i2]);
                    continue;
                }
                if ("--parse-date-format".equals(args[i2])) {
                    result.parseDateFormat = args[++i2];
                    continue;
                }
                if ("--parse-ignore-comments".equals(args[i2])) {
                    result.parseIgnoreComments = true;
                    continue;
                }
                if ("--parse-ignore-comment-start".equals(args[i2])) {
                    result.parseIgnoreCommentStart = args[++i2];
                    continue;
                }
                if ("--parse-ignore-comment-stop".equals(args[i2])) {
                    result.parseIgnoreCommentStop = args[++i2];
                    continue;
                }
                if ("--parse-locale".equals(args[i2])) {
                    result.parseLocale = Locale.forLanguageTag(args[++i2]);
                    continue;
                }
                if ("--parse-name-case".equals(args[i2])) {
                    enumArgument = ParseNameCase.class;
                    result.parseNameCase = ParserCLI.parse(ParseNameCase.class, args[++i2]);
                    continue;
                }
                if ("--parse-named-param-prefix".equals(args[i2])) {
                    result.parseNamedParamPrefix = args[++i2];
                    continue;
                }
                if ("--parse-set-commands".equals(args[i2])) {
                    result.parseSetCommands = true;
                    continue;
                }
                if ("--parse-retain-comments-between-queries".equals(args[i2])) {
                    result.parseRetainCommentsBetweenQueries = true;
                    continue;
                }
                if ("--parse-timestamp-format".equals(args[i2])) {
                    result.parseTimestampFormat = args[++i2];
                    continue;
                }
                if ("--parse-unknown-functions".equals(args[i2])) {
                    enumArgument = ParseUnknownFunctions.class;
                    result.parseUnknownFunctions = ParserCLI.parse(ParseUnknownFunctions.class, args[++i2]);
                    continue;
                }
                if ("--parse-unsupported-syntax".equals(args[i2])) {
                    enumArgument = ParseUnsupportedSyntax.class;
                    result.parseUnsupportedSyntax = ParserCLI.parse(ParseUnsupportedSyntax.class, args[++i2]);
                    continue;
                }
                if ("--render-coalesce-to-empty-string-in-concat".equals(args[i2])) {
                    result.renderCoalesceToEmptyStringInConcat = true;
                    continue;
                }
                if ("--render-optional-inner-keyword".equals(args[i2])) {
                    enumArgument = RenderOptionalKeyword.class;
                    result.renderOptionalInnerKeyword = ParserCLI.parse(RenderOptionalKeyword.class, args[++i2]);
                    continue;
                }
                if ("--render-optional-outer-keyword".equals(args[i2])) {
                    enumArgument = RenderOptionalKeyword.class;
                    result.renderOptionalOuterKeyword = ParserCLI.parse(RenderOptionalKeyword.class, args[++i2]);
                    continue;
                }
                if ("--render-optional-as-keyword-for-field-aliases".equals(args[i2])) {
                    enumArgument = RenderOptionalKeyword.class;
                    result.renderOptionalAsKeywordForFieldAliases = ParserCLI.parse(RenderOptionalKeyword.class, args[++i2]);
                    continue;
                }
                if ("--render-optional-as-keyword-for-table-aliases".equals(args[i2])) {
                    enumArgument = RenderOptionalKeyword.class;
                    result.renderOptionalAsKeywordForTableAliases = ParserCLI.parse(RenderOptionalKeyword.class, args[++i2]);
                    continue;
                }
                if ("--transform-ansi-join-to-table-lists".equals(args[i2])) {
                    result.transformAnsiJoinToTableLists = true;
                    continue;
                }
                if ("--transform-qualify".equals(args[i2])) {
                    enumArgument = Transformation.class;
                    result.transformQualify = ParserCLI.parse(Transformation.class, args[++i2]);
                    continue;
                }
                if ("--transform-rownum".equals(args[i2])) {
                    enumArgument = Transformation.class;
                    result.transformRownum = ParserCLI.parse(Transformation.class, args[++i2]);
                    continue;
                }
                if ("--transform-table-lists-to-ansi-join".equals(args[i2])) {
                    result.transformTableListsToAnsiJoin = true;
                    continue;
                }
                if ("--transform-unneeded-arithmetic".equals(args[i2])) {
                    enumArgument = TransformUnneededArithmeticExpressions.class;
                    result.transformUnneededArithmetic = ParserCLI.parse(TransformUnneededArithmeticExpressions.class, args[++i2]);
                    continue;
                }
                if ("-s".equals(args[i2]) || "--sql".equals(args[i2])) {
                    result.sql = args[++i2];
                    continue;
                }
                if ("-I".equals(args[i2]) || "--interactive".equals(args[i2])) {
                    result.interactive = true;
                    continue;
                }
                if ("-h".equals(args[i2]) || "--help".equals(args[i2])) {
                    ParserCLI.help();
                    result.done = true;
                    continue;
                }
                System.out.println("Unknown flag: " + args[i2] + ". Use -h or --help");
                throw new RuntimeException();
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                System.out.println("Flag " + args[i2 - 1] + " requires <" + (enumArgument != null ? enumArgument.getName() : "Unknown") + "> argument");
                throw e2;
            }
        }
        return result;
    }

    private static final void invalid(String string, Class<? extends Enum<?>> type) {
        System.out.println("Invalid " + type.getSimpleName() + ": " + string);
        System.out.println("Possible values:");
        for (Enum<?> e2 : type.getEnumConstants()) {
            System.out.println("  " + e2.name());
        }
    }

    private static final void help() {
        System.out.println("Usage:");
        System.out.println("  -f / --formatted                                                    Format output SQL");
        System.out.println("  -h / --help                                                         Display this help");
        System.out.println("  -k / --keyword                                  <RenderKeywordCase> Specify the output keyword case (org.jooq.conf.RenderKeywordCase)");
        System.out.println("  -i / --identifier                               <RenderNameCase>    Specify the output identifier case (org.jooq.conf.RenderNameCase)");
        System.out.println("  -Q / --quoted                                   <RenderQuotedNames> Specify the output identifier quoting (org.jooq.conf.RenderQuotedNames)");
        System.out.println("  -F / --from-dialect                             <SQLDialect>        Specify the input dialect (org.jooq.SQLDialect)");
        System.out.println("  -T / --to-dialect                               <SQLDialect>        Specify the output dialect (org.jooq.SQLDialect)");
        System.out.println("  -s / --sql                                      <String>            Specify the input SQL string");
        System.out.println("");
        System.out.println("Additional flags:");
        System.out.println("  --parse-date-format                             <String>");
        System.out.println("  --parse-locale                                  <Locale>");
        System.out.println("  --parse-name-case                               <ParseNameCase>");
        System.out.println("  --parse-named-param-prefix                      <String>");
        System.out.println("  --parse-retain-comments-between-queries");
        System.out.println("  --parse-set-commands");
        System.out.println("  --parse-timestamp-format                        <String>");
        System.out.println("  --parse-unknown-functions                       <ParseUnknownFunctions>");
        System.out.println("  --parse-unsupported-syntax                      <ParseUnsupportedSyntax>");
        System.out.println("  --render-optional-inner-keyword                 <RenderOptionalKeyword>");
        System.out.println("  --render-optional-outer-keyword                 <RenderOptionalKeyword>");
        System.out.println("  --render-optional-as-keyword-for-field-aliases  <RenderOptionalKeyword>");
        System.out.println("  --render-optional-as-keyword-for-table-aliases  <RenderOptionalKeyword>");
        System.out.println("");
        System.out.println("Commercial distribution only features:");
        System.out.println("  --render-coalesce-to-empty-string-in-concat");
        System.out.println("  --transform-ansi-join-to-table-lists");
        System.out.println("  --transform-qualify                             <Transformation>");
        System.out.println("  --transform-rownum                              <Transformation>");
        System.out.println("  --transform-table-lists-to-ansi-join");
        System.out.println("  --transform-unneeded-arithmetic                 <TransformUnneededArithmeticExpressions>");
        System.out.println("");
        System.out.println("  -I / --interactive                                               Start interactive mode");
    }

    private static final void helpInteractive() {
        System.out.println("Usage:");
        System.out.println("  /d  or  /display                                                   Display arguments");
        System.out.println("  /f  or  /formatted                             <boolean>           Format output SQL");
        System.out.println("  /h  or  /help                                                      Display this help");
        System.out.println("  /k  or  /keyword                               <RenderKeywordCase> Specify the output keyword case (org.jooq.conf.RenderKeywordCase)");
        System.out.println("  /i  or  /identifier                            <RenderNameCase>    Specify the output identifier case (org.jooq.conf.RenderNameCase)");
        System.out.println("  /Q  or  /quoted                                <RenderQuotedNames> Specify the output identifier quoting (org.jooq.conf.RenderQuotedNames)");
        System.out.println("  /F  or  /from-dialect                          <SQLDialect>        Specify the input dialect (org.jooq.SQLDialect)");
        System.out.println("  /T  or  /to-dialect                            <SQLDialect>        Specify the output dialect (org.jooq.SQLDialect)");
        System.out.println("                                                 <String>            Specify the input SQL string");
        System.out.println("");
        System.out.println("Additional flags:");
        System.out.println("  /parse-date-format                             <String>");
        System.out.println("  /parse-locale                                  <Locale>");
        System.out.println("  /parse-name-case                               <ParseNameCase>");
        System.out.println("  /parse-named-param-prefix                      <String>");
        System.out.println("  /parse-retain-comments-between-queries         <boolean>");
        System.out.println("  /parse-set-commands                            <boolean>");
        System.out.println("  /parse-timestamp-format                        <String>");
        System.out.println("  /parse-unknown-functions                       <ParseUnknownFunctions>");
        System.out.println("  /parse-unsupported-syntax                      <ParseUnsupportedSyntax>");
        System.out.println("  /render-optional-inner-keyword                 <RenderOptionalKeyword>");
        System.out.println("  /render-optional-outer-keyword                 <RenderOptionalKeyword>");
        System.out.println("  /render-optional-as-keyword-for-field-aliases  <RenderOptionalKeyword>");
        System.out.println("  /render-optional-as-keyword-for-table-aliases  <RenderOptionalKeyword>");
        System.out.println("");
        System.out.println("Commercial distribution only features:");
        System.out.println("  /render-coalesce-to-empty-string-in-concat     <boolean>");
        System.out.println("  /transform-ansi-join-to-table-lists            <boolean>");
        System.out.println("  /transform-qualify                             <Transformation>");
        System.out.println("  /transform-rownum                              <Transformation>");
        System.out.println("  /transform-table-lists-to-ansi-join            <boolean>");
        System.out.println("  /transform-unneeded-arithmetic                 <TransformUnneededArithmeticExpressions>");
        System.out.println("");
        System.out.println("  /q  or  /quit   Quit");
        System.out.println("  /e  or  /exit   Also quit");
    }

    public static final class Args {
        Settings d = new Settings();
        List<String> history = new ArrayList<String>();
        boolean interactive;
        boolean done;
        String sql;
        RenderKeywordCase keywords = RenderKeywordCase.LOWER;
        RenderNameCase name = RenderNameCase.LOWER;
        RenderQuotedNames quoted = RenderQuotedNames.EXPLICIT_DEFAULT_UNQUOTED;
        SQLDialect toDialect = SQLDialect.DEFAULT;
        SQLDialect fromDialect = SQLDialect.DEFAULT;
        Boolean formatted = this.d.isRenderFormatted();
        Boolean renderCoalesceToEmptyStringInConcat = this.d.isRenderCoalesceToEmptyStringInConcat();
        RenderOptionalKeyword renderOptionalInnerKeyword = RenderOptionalKeyword.DEFAULT;
        RenderOptionalKeyword renderOptionalOuterKeyword = RenderOptionalKeyword.DEFAULT;
        RenderOptionalKeyword renderOptionalAsKeywordForFieldAliases = RenderOptionalKeyword.DEFAULT;
        RenderOptionalKeyword renderOptionalAsKeywordForTableAliases = RenderOptionalKeyword.DEFAULT;
        String parseDateFormat = this.d.getParseDateFormat();
        Boolean parseIgnoreComments = this.d.isParseIgnoreComments();
        String parseIgnoreCommentStart = this.d.getParseIgnoreCommentStart();
        String parseIgnoreCommentStop = this.d.getParseIgnoreCommentStop();
        Locale parseLocale = this.d.getParseLocale();
        ParseNameCase parseNameCase = this.d.getParseNameCase();
        String parseNamedParamPrefix = this.d.getParseNamedParamPrefix();
        Boolean parseRetainCommentsBetweenQueries = this.d.isParseRetainCommentsBetweenQueries();
        Boolean parseSetCommands = this.d.isParseSetCommands();
        String parseTimestampFormat = this.d.getParseTimestampFormat();
        ParseUnknownFunctions parseUnknownFunctions = this.d.getParseUnknownFunctions();
        ParseUnsupportedSyntax parseUnsupportedSyntax = this.d.getParseUnsupportedSyntax();
        Boolean transformAnsiJoinToTableLists = this.d.isTransformAnsiJoinToTableLists();
        Transformation transformQualify = this.d.getTransformQualify();
        Transformation transformRownum = this.d.getTransformRownum();
        Boolean transformTableListsToAnsiJoin = this.d.isTransformTableListsToAnsiJoin();
        TransformUnneededArithmeticExpressions transformUnneededArithmetic = TransformUnneededArithmeticExpressions.NEVER;
    }
}

