/*
 * Decompiled with CFR 0.152.
 */
package org.jooq;

import org.jooq.CLIUtil;
import org.jooq.DSLContext;
import org.jooq.SQLDialect;
import org.jooq.conf.RenderKeywordCase;
import org.jooq.conf.RenderNameCase;
import org.jooq.conf.Settings;
import org.jooq.impl.DSL;

public final class DiffCLI {
    public static final void main(String ... args) throws Exception {
        CLIUtil.main("https://www.jooq.org/doc/latest/manual/sql-building/schema-diff-cli/", () -> {
            Settings settings = new Settings();
            Args a2 = DiffCLI.parse(args);
            DiffCLI.settings(a2, settings);
            DSLContext ctx = DiffCLI.ctx(a2, settings);
            if (!a2.done) {
                if (a2.toDialect == null || a2.sql1 == null || a2.sql2 == null) {
                    System.out.println("Mandatory arguments: -T and -1, -2. Use -h for help");
                    throw new RuntimeException();
                }
                DiffCLI.render(ctx, a2);
            }
        });
    }

    private static final DSLContext ctx(Args a2, Settings settings) {
        return DSL.using(a2.toDialect, settings);
    }

    private static final void settings(Args a2, Settings settings) {
        if (a2.formatted) {
            settings.setRenderFormatted(true);
        }
        if (a2.keywords != null) {
            settings.setRenderKeywordCase(a2.keywords);
        }
        if (a2.name != null) {
            settings.setRenderNameCase(a2.name);
        }
        if (a2.fromDialect != null) {
            settings.setParseDialect(a2.fromDialect);
        }
    }

    private static final void render(DSLContext ctx, Args a2) {
        String sql1 = a2.sql1.trim();
        String sql2 = a2.sql2.trim();
        System.out.println(ctx.render(ctx.meta(sql1).migrateTo(ctx.meta(sql2))));
    }

    private static final Args parse(String[] args) {
        Args result = new Args();
        for (int i2 = 0; i2 < args.length; ++i2) {
            if ("-f".equals(args[i2]) || "--formatted".equals(args[i2])) {
                result.formatted = true;
                continue;
            }
            if ("-k".equals(args[i2]) || "--keyword".equals(args[i2])) {
                try {
                    result.keywords = RenderKeywordCase.valueOf(args[++i2].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e2) {
                    DiffCLI.invalid(args[i2], RenderKeywordCase.class);
                    throw e2;
                }
                catch (ArrayIndexOutOfBoundsException e3) {
                    System.out.println("Flag -k / --keyword requires <RenderKeywordCase> argument");
                    throw e3;
                }
            }
            if ("-i".equals(args[i2]) || "--identifier".equals(args[i2])) {
                try {
                    result.keywords = RenderKeywordCase.valueOf(args[++i2].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e4) {
                    DiffCLI.invalid(args[i2], RenderKeywordCase.class);
                    throw e4;
                }
                catch (ArrayIndexOutOfBoundsException e5) {
                    System.out.println("Flag -i / --identifier requires <RenderNameCase> argument");
                    throw e5;
                }
            }
            if ("-F".equals(args[i2]) || "--from-dialect".equals(args[i2])) {
                try {
                    result.fromDialect = SQLDialect.valueOf(args[++i2].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e6) {
                    DiffCLI.invalid(args[i2], SQLDialect.class);
                    throw e6;
                }
                catch (ArrayIndexOutOfBoundsException e7) {
                    System.out.println("Flag -F / --from-dialect requires <SQLDialect> argument");
                    throw e7;
                }
            }
            if ("-t".equals(args[i2]) || "-T".equals(args[i2]) || "--to-dialect".equals(args[i2])) {
                try {
                    result.toDialect = SQLDialect.valueOf(args[++i2].toUpperCase());
                    continue;
                }
                catch (IllegalArgumentException e8) {
                    DiffCLI.invalid(args[i2], SQLDialect.class);
                    throw e8;
                }
                catch (ArrayIndexOutOfBoundsException e9) {
                    System.out.println("Flag -T / --to-dialect requires <SQLDialect> argument");
                    throw e9;
                }
            }
            if ("-1".equals(args[i2]) || "--sql1".equals(args[i2])) {
                try {
                    result.sql1 = args[++i2];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e10) {
                    System.out.println("Flag -1 / --sql1 requires <String> argument");
                    throw e10;
                }
            }
            if ("-2".equals(args[i2]) || "--sql2".equals(args[i2])) {
                try {
                    result.sql2 = args[++i2];
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException e11) {
                    System.out.println("Flag -2 / --sql2 requires <String> argument");
                    throw e11;
                }
            }
            if ("-h".equals(args[i2]) || "--help".equals(args[i2])) {
                DiffCLI.help();
                result.done = true;
                continue;
            }
            System.out.println("Unknown flag: " + args[i2] + ". Use -h or --help");
            throw new RuntimeException();
        }
        return result;
    }

    private static final void invalid(String string, Class<? extends Enum<?>> type) {
        System.out.println("Invalid " + type.getSimpleName() + ": " + string);
        System.out.println("Possible values:");
        for (Enum<?> e2 : type.getEnumConstants()) {
            System.out.println("  " + e2.name());
        }
    }

    private static final void help() {
        System.out.println("Usage:");
        System.out.println("  -f / --formatted                        Format output SQL");
        System.out.println("  -h / --help                             Display this help");
        System.out.println("  -k / --keyword      <RenderKeywordCase> Specify the output keyword case (org.jooq.conf.RenderKeywordCase)");
        System.out.println("  -i / --identifier   <RenderNameCase>    Specify the output identifier case (org.jooq.conf.RenderNameCase)");
        System.out.println("  -F / --from-dialect <SQLDialect>        Specify the input dialect (org.jooq.SQLDialect)");
        System.out.println("  -T / --to-dialect   <SQLDialect>        Specify the output dialect (org.jooq.SQLDialect)");
        System.out.println("  -1 / --sql1         <String>            Specify the input SQL string 1 (from SQL)");
        System.out.println("  -2 / --sql2         <String>            Specify the input SQL string 2 (to SQL)");
    }

    public static final class Args {
        String sql1;
        String sql2;
        RenderKeywordCase keywords = RenderKeywordCase.LOWER;
        RenderNameCase name = RenderNameCase.LOWER;
        SQLDialect toDialect = SQLDialect.DEFAULT;
        SQLDialect fromDialect = SQLDialect.DEFAULT;
        boolean formatted;
        boolean done;
    }
}

