/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import org.geolatte.geom.LinearRing;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.codec.sqlserver.AbstractDecoder;
import org.geolatte.geom.codec.sqlserver.IndexRange;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

class PolygonDecoder
extends AbstractDecoder<Polygon> {
    PolygonDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.POLYGON;
    }

    @Override
    protected Polygon createNullGeometry() {
        return Polygon.createEmpty();
    }

    @Override
    protected Polygon createGeometry(SqlServerGeometry nativeGeom) {
        return this.createGeometry(nativeGeom, 0);
    }

    @Override
    protected Polygon createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry();
        }
        IndexRange figureRange = nativeGeom.getFiguresForShape(shapeIndex);
        LinearRing[] rings = new LinearRing[figureRange.length()];
        int i2 = 1;
        for (int figureIdx = figureRange.start; figureIdx < figureRange.end; ++figureIdx) {
            IndexRange pntIndexRange = nativeGeom.getPointsForFigure(figureIdx);
            if (nativeGeom.isFigureInteriorRing(figureIdx)) {
                rings[i2++] = this.toLinearRing(nativeGeom, pntIndexRange);
                continue;
            }
            rings[0] = this.toLinearRing(nativeGeom, pntIndexRange);
        }
        return new Polygon(rings);
    }

    private LinearRing toLinearRing(SqlServerGeometry nativeGeom, IndexRange range) {
        PointSequence pointSequence = nativeGeom.coordinateRange(range);
        return new LinearRing(pointSequence);
    }
}

