/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom.codec.sqlserver;

import org.geolatte.geom.LineString;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.codec.sqlserver.AbstractDecoder;
import org.geolatte.geom.codec.sqlserver.IndexRange;
import org.geolatte.geom.codec.sqlserver.OpenGisType;
import org.geolatte.geom.codec.sqlserver.SqlServerGeometry;

class LineStringDecoder
extends AbstractDecoder<LineString> {
    LineStringDecoder() {
    }

    @Override
    protected OpenGisType getOpenGisType() {
        return OpenGisType.LINESTRING;
    }

    @Override
    protected LineString createNullGeometry() {
        return LineString.createEmpty();
    }

    @Override
    protected LineString createGeometry(SqlServerGeometry nativeGeom) {
        return this.createLineString(nativeGeom, new IndexRange(0, nativeGeom.getNumPoints()));
    }

    @Override
    protected LineString createGeometry(SqlServerGeometry nativeGeom, int shapeIndex) {
        if (nativeGeom.isEmptyShape(shapeIndex)) {
            return this.createNullGeometry();
        }
        int figureOffset = nativeGeom.getFiguresForShape((int)shapeIndex).start;
        IndexRange pntIndexRange = nativeGeom.getPointsForFigure(figureOffset);
        return this.createLineString(nativeGeom, pntIndexRange);
    }

    protected LineString createLineString(SqlServerGeometry nativeGeom, IndexRange pntIndexRange) {
        PointSequence coordinates = nativeGeom.coordinateRange(pntIndexRange);
        return new LineString(coordinates);
    }
}

