/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Iterator;
import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryOperations;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.GeometryVisitor;
import org.geolatte.geom.LinearRing;
import org.geolatte.geom.MultiLineString;
import org.geolatte.geom.Point;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.crs.CrsId;
import org.geolatte.geom.jts.JTS;

public class Polygon
extends Geometry
implements Iterable<LinearRing> {
    private final PointCollection points;
    private final LinearRing[] rings;
    static final Polygon EMPTY = new Polygon(new LinearRing[0]);

    public static Polygon createEmpty() {
        return EMPTY;
    }

    public Polygon(PointSequence pointSequence, GeometryOperations ops) {
        this(new LinearRing[]{new LinearRing(pointSequence, ops)});
    }

    public Polygon(PointSequence pointSequence) {
        this(new LinearRing[]{new LinearRing(pointSequence, null)});
    }

    public Polygon(LinearRing[] rings) {
        super(Polygon.getGeometryOperations(rings));
        this.checkRings(rings);
        this.points = Polygon.collectPointSets(rings);
        this.rings = rings;
    }

    private void checkRings(LinearRing[] rings) {
        CrsId crsId = Polygon.getCrsId(rings);
        for (LinearRing ring : rings) {
            this.checkLinearRing(ring, crsId);
        }
    }

    private void checkLinearRing(LinearRing ring, CrsId crsId) {
        if (ring == null) {
            throw new IllegalArgumentException("NULL linear ring is not valid.");
        }
        if (ring.isEmpty()) {
            throw new IllegalArgumentException("Empty linear ring is not valid.");
        }
        if (!ring.getCrsId().equals(crsId)) {
            throw new IllegalArgumentException("Linear ring with different CRS than exterior boundary.");
        }
    }

    @Override
    public PointCollection getPoints() {
        return this.points;
    }

    public LinearRing getExteriorRing() {
        return this.isEmpty() ? LinearRing.EMPTY : this.rings[0];
    }

    public int getNumInteriorRing() {
        return this.isEmpty() ? 0 : this.rings.length - 1;
    }

    public LinearRing getInteriorRingN(int index) {
        return this.rings[index + 1];
    }

    public double getArea() {
        return JTS.to((Geometry)this).getArea();
    }

    public Point getCentroid() {
        return (Point)JTS.from(JTS.to((Geometry)this).getCentroid());
    }

    public Point getPointOnSurface() {
        return this.getPointN(0);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.POLYGON;
    }

    @Override
    public MultiLineString getBoundary() {
        return this.isEmpty() ? MultiLineString.EMPTY : new MultiLineString(this.rings);
    }

    @Override
    public Iterator<LinearRing> iterator() {
        return new Iterator<LinearRing>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Polygon.this.rings.length;
            }

            @Override
            public LinearRing next() {
                return Polygon.this.rings[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

