/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import java.util.Arrays;
import java.util.Iterator;
import org.geolatte.geom.AbstractPointCollection;
import org.geolatte.geom.ComplexPointCollection;
import org.geolatte.geom.CoordinateComponent;
import org.geolatte.geom.DimensionalFlag;
import org.geolatte.geom.PointCollection;
import org.geolatte.geom.PointCollectionPointEquality;
import org.geolatte.geom.PointSequence;
import org.geolatte.geom.crs.CrsId;

class NestedPointCollection
extends AbstractPointCollection
implements ComplexPointCollection {
    private final int size;
    protected final PointCollection[] children;

    NestedPointCollection(PointCollection[] children) {
        super(NestedPointCollection.extractDimensionalFlag(children), NestedPointCollection.extractCrsId(children));
        this.children = children;
        this.size = this.calculateSize();
    }

    private static DimensionalFlag extractDimensionalFlag(PointCollection[] children) {
        return children == null || children.length == 0 ? DimensionalFlag.d2D : children[0].getDimensionalFlag();
    }

    private static CrsId extractCrsId(PointCollection[] children) {
        return children == null || children.length == 0 ? CrsId.UNDEFINED : children[0].getCrsId();
    }

    private int calculateSize() {
        int size = 0;
        for (PointCollection child : this.getPointSets()) {
            size += child.size();
        }
        return size;
    }

    @Override
    public PointCollection[] getPointSets() {
        return this.children;
    }

    @Override
    public boolean isEmpty() {
        return this.children.length == 0;
    }

    @Override
    public double getCoordinate(int position, CoordinateComponent component) {
        int childOffset = position;
        for (PointCollection child : this.getPointSets()) {
            if (childOffset < child.size()) {
                return child.getCoordinate(childOffset, component);
            }
            childOffset -= child.size();
        }
        throw new ArrayIndexOutOfBoundsException(String.format("Index %d not found in collection of size %d", position, this.size()));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public PointCollection clone() {
        return this;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || !(o2 instanceof PointSequence)) {
            return false;
        }
        PointSequence that = (PointSequence)o2;
        if (this.is3D() != that.is3D()) {
            return false;
        }
        if (this.isMeasured() != that.isMeasured()) {
            return false;
        }
        return new PointCollectionPointEquality().equals(this, that);
    }

    public int hashCode() {
        return Arrays.hashCode(this.children);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (int i2 = 0; i2 < this.children.length; ++i2) {
            if (i2 > 0) {
                builder.append(",");
            }
            builder.append(this.getPointSets()[i2].toString());
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public Iterator<PointCollection> iterator() {
        return new Iterator<PointCollection>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < NestedPointCollection.this.children.length;
            }

            @Override
            public PointCollection next() {
                return NestedPointCollection.this.children[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported on PointSets.");
            }
        };
    }
}

