/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.geom;

import org.geolatte.geom.Geometry;
import org.geolatte.geom.GeometryCollection;
import org.geolatte.geom.GeometryType;
import org.geolatte.geom.Point;
import org.geolatte.geom.Polygon;
import org.geolatte.geom.jts.JTS;

public class MultiPolygon
extends GeometryCollection {
    static final MultiPolygon EMPTY = new MultiPolygon(new Polygon[0]);

    public static MultiPolygon createEmpty() {
        return EMPTY;
    }

    public MultiPolygon(Polygon[] polygons) {
        super(polygons);
    }

    @Override
    public Polygon getGeometryN(int num) {
        return (Polygon)super.getGeometryN(num);
    }

    public double area() {
        double totalArea = 0.0;
        for (int i2 = 0; i2 < this.getNumGeometries(); ++i2) {
            totalArea += this.getGeometryN(i2).getArea();
        }
        return totalArea;
    }

    public Point centroid() {
        if (this.isEmpty()) {
            return Point.EMPTY;
        }
        return (Point)JTS.from(JTS.to((Geometry)this).getCentroid());
    }

    public Point pointOnSurface() {
        for (int i2 = 0; i2 < this.getNumGeometries(); ++i2) {
            if (this.getGeometryN(i2).isEmpty()) continue;
            return this.getGeometryN(i2).getPointOnSurface();
        }
        return Point.EMPTY;
    }

    @Override
    public GeometryType getGeometryType() {
        return GeometryType.MULTI_POLYGON;
    }
}

