/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geolatte.common.transformer.AbstractObservableTransformer;
import org.geolatte.common.transformer.OneToManyTransformation;
import org.geolatte.common.transformer.Transformation;
import org.geolatte.common.transformer.TransformationException;

public class DefaultTransformer<Source, Target>
extends AbstractObservableTransformer<Source, Target> {
    private Transformation<? super Source, ? super Target> transformation;
    private OneToManyTransformation<? super Source, ? super Target> oneToManyTransformation;
    private Iterable<? extends Source> currentInput;
    private Iterable<Target> currentOutput;

    public DefaultTransformer(Transformation<? super Source, ? super Target> transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException("Argument transformation cannot be null");
        }
        this.transformation = transformation;
    }

    public DefaultTransformer(OneToManyTransformation<? super Source, ? super Target> transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException("Argument transformation cannot be null");
        }
        this.oneToManyTransformation = transformation;
    }

    @Override
    protected void setInput(Iterable<? extends Source> input) {
        this.currentInput = input;
        this.currentOutput = null;
    }

    @Override
    protected Iterable<Target> output() {
        if (this.currentInput == null && this.currentOutput == null) {
            return null;
        }
        if (this.currentOutput != null) {
            return this.currentOutput;
        }
        this.currentOutput = new DefaultTransformerIterable(this.currentInput.iterator());
        this.currentInput = null;
        return this.currentOutput;
    }

    private class DefaultOneToManyTransformerIterator<Target>
    implements Iterator<Target> {
        private Iterator<? extends Source> inputIterator;
        private Iterator<? extends Target> currentTargetIterator;

        private DefaultOneToManyTransformerIterator(Iterator<? extends Source> inputIterator) {
            this.inputIterator = inputIterator;
            this.currentTargetIterator = new Iterator<Target>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public Target next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public boolean hasNext() {
            if (this.currentTargetIterator.hasNext()) {
                return true;
            }
            while (this.inputIterator.hasNext()) {
                Object nextElement = null;
                try {
                    nextElement = this.inputIterator.next();
                    this.currentTargetIterator = (Iterator)DefaultTransformer.this.oneToManyTransformation.transform(nextElement);
                    if (!this.currentTargetIterator.hasNext()) continue;
                    return true;
                }
                catch (TransformationException e2) {
                    DefaultTransformer.this.onTransformerErrorOccurred(nextElement, e2);
                }
            }
            return false;
        }

        @Override
        public Target next() {
            if (this.currentTargetIterator.hasNext()) {
                return this.currentTargetIterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class DefaultTransformerIterator<Target>
    implements Iterator<Target> {
        private Iterator<? extends Source> inputIterator;
        private Target cachedElement = null;
        private boolean isCachedElementValid = false;

        private DefaultTransformerIterator(Iterator<? extends Source> inputIterator) {
            this.inputIterator = inputIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.isCachedElementValid) {
                return true;
            }
            while (this.inputIterator.hasNext()) {
                Object nextElement = null;
                try {
                    nextElement = this.inputIterator.next();
                    this.cachedElement = DefaultTransformer.this.transformation.transform(nextElement);
                    this.isCachedElementValid = true;
                    return true;
                }
                catch (TransformationException e2) {
                    DefaultTransformer.this.onTransformerErrorOccurred(nextElement, e2);
                }
            }
            return false;
        }

        @Override
        public Target next() {
            if (this.isCachedElementValid || this.hasNext()) {
                this.isCachedElementValid = false;
                return this.cachedElement;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class DefaultTransformerIterable<Target>
    implements Iterable<Target> {
        private Iterator<? extends Source> inputIterator;

        private DefaultTransformerIterable(Iterator<? extends Source> inputIterator) {
            this.inputIterator = inputIterator;
        }

        @Override
        public Iterator<Target> iterator() {
            if (DefaultTransformer.this.transformation != null) {
                return new DefaultTransformerIterator(this.inputIterator);
            }
            if (DefaultTransformer.this.oneToManyTransformation != null) {
                return new DefaultOneToManyTransformerIterator(this.inputIterator);
            }
            return null;
        }
    }
}

