/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geolatte.common.transformer.AbstractObservableTransformer;
import org.geolatte.common.transformer.Transformation;
import org.geolatte.common.transformer.TransformationException;

public class DefaultFilter<Source>
extends AbstractObservableTransformer<Source, Source> {
    private Transformation<Source, Boolean> filter;
    private Iterable<? extends Source> currentInput;
    private Iterable<Source> currentOutput;

    public DefaultFilter(Transformation<Source, Boolean> transformation) {
        if (transformation == null) {
            throw new IllegalArgumentException("Argument transformation cannot be null");
        }
        this.filter = transformation;
    }

    @Override
    protected void setInput(Iterable<? extends Source> input) {
        this.currentInput = input;
        this.currentOutput = null;
    }

    @Override
    protected Iterable<Source> output() {
        if (this.currentInput == null && this.currentOutput == null) {
            return null;
        }
        if (this.currentOutput != null) {
            return this.currentOutput;
        }
        this.currentOutput = new FilterIterable(this.currentInput.iterator());
        this.currentInput = null;
        return this.currentOutput;
    }

    private class FilterIterator<T>
    implements Iterator<T> {
        private Iterator<? extends T> inputIterator;
        private T cachedElement = null;
        private boolean isCachedElementValid = false;

        private FilterIterator(Iterator<? extends T> inputIterator) {
            this.inputIterator = inputIterator;
        }

        @Override
        public boolean hasNext() {
            if (this.isCachedElementValid) {
                return true;
            }
            while (this.inputIterator.hasNext()) {
                Object nextElement = null;
                try {
                    nextElement = this.inputIterator.next();
                    if (!((Boolean)DefaultFilter.this.filter.transform(nextElement)).booleanValue()) {
                        this.cachedElement = null;
                        this.isCachedElementValid = false;
                        continue;
                    }
                    this.cachedElement = nextElement;
                    this.isCachedElementValid = true;
                    return true;
                }
                catch (TransformationException e2) {
                    DefaultFilter.this.onTransformerErrorOccurred(nextElement, e2);
                }
            }
            return false;
        }

        @Override
        public T next() {
            if (this.isCachedElementValid || this.hasNext()) {
                this.isCachedElementValid = false;
                return this.cachedElement;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class FilterIterable<Source>
    implements Iterable<Source> {
        private Iterator<? extends Source> inputIterator;

        private FilterIterable(Iterator<? extends Source> inputIterator) {
            this.inputIterator = inputIterator;
        }

        @Override
        public Iterator<Source> iterator() {
            return new FilterIterator(this.inputIterator);
        }
    }
}

