/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.transformer;

import java.util.ArrayList;
import org.geolatte.common.transformer.ObservableTransformerSink;
import org.geolatte.common.transformer.TransformerSinkErrorEvent;
import org.geolatte.common.transformer.TransformerSinkEventListener;

public abstract class AbstractObservableTransformerSink<T>
extends ObservableTransformerSink<T> {
    private ArrayList<TransformerSinkEventListener> transformerSinkEventListeners = new ArrayList();

    @Override
    public void addTransformerSinkEventListener(TransformerSinkEventListener listener) {
        if (listener != null) {
            this.transformerSinkEventListeners.add(listener);
        }
    }

    @Override
    public void removeTransformerSinkEventListener(TransformerSinkEventListener listener) {
        this.transformerSinkEventListeners.remove(listener);
    }

    protected void onTransformationSinkErrorOccurred(Exception exception) {
        for (TransformerSinkEventListener listener : this.transformerSinkEventListeners) {
            this.fireErrorEvent(listener, new TransformerSinkErrorEvent(this, exception));
        }
    }

    protected void onTransformationSinkErrorOccurred(TransformerSinkErrorEvent event) {
        for (TransformerSinkEventListener listener : this.transformerSinkEventListeners) {
            this.fireErrorEvent(listener, event);
        }
    }

    private void fireErrorEvent(TransformerSinkEventListener listener, TransformerSinkErrorEvent event) {
        try {
            listener.ErrorOccurred(event);
        }
        catch (RuntimeException e2) {
            System.err.println("Exception thrown while trying to invoke event listener, removing bed behaved listener.");
            e2.printStackTrace();
            this.removeTransformerSinkEventListener(listener);
        }
    }
}

