/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.reflection;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.geolatte.common.Feature;
import org.geolatte.common.reflection.Accessor;
import org.geolatte.common.reflection.InvalidObjectReaderException;
import org.geolatte.geom.Geometry;

public class EntityClassReader {
    private static final String DEFAULT_ID_PROPERTY = "id";
    private static Map<Class, Map<String, EntityClassReader>> allReaders = new HashMap<Class, Map<String, EntityClassReader>>();
    private Map<String, Accessor> accessorMap = new HashMap<String, Accessor>();
    private Accessor geometryAccessor;
    private Accessor idAccessor;
    private Class entityClass;
    private static final Method proxyIdGetMethod;
    private static final Method proxyExistsMethod;
    private static final Method proxyGeomGetMethod;
    private static final Method proxyGeomNameGetMethod;
    private static final Method proxyPropertiesGetMethod;
    private static final Method proxyAttributeGetMethod;
    private static Map<Class, NumberTransformer> transformers;

    private static String determineGeomProperty(Class entityClass) {
        if (entityClass == null) {
            return null;
        }
        for (Method method : EntityClassReader.getPropertyMethods(entityClass)) {
            if (!com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(method.getReturnType()) && !Geometry.class.isAssignableFrom(method.getReturnType())) continue;
            return EntityClassReader.propertyName(method);
        }
        return null;
    }

    private static List<Method> getPropertyMethods(Class entityClass) {
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method m3 : entityClass.getMethods()) {
            if (m3.getParameterTypes().length != 0 || !m3.getName().startsWith("get") || m3.getReturnType() == Void.TYPE || m3.getName().equals("getClass")) continue;
            result.add(m3);
        }
        return result;
    }

    public EntityClassReader(Class entityClass, String geometryPropertyName, String idPropertyName) {
        if (entityClass == null) {
            throw new IllegalArgumentException("Given entityclass may not be null");
        }
        this.entityClass = entityClass;
        for (Method m3 : EntityClassReader.getPropertyMethods(entityClass)) {
            String propertyName = EntityClassReader.propertyName(m3);
            boolean toAdd = true;
            if (this.isPropertyGeometryProperty(geometryPropertyName, m3, propertyName)) {
                this.geometryAccessor = Accessor.newInstance(m3, propertyName);
                toAdd = false;
            }
            if (this.isPropertyIdProperty(idPropertyName, propertyName)) {
                this.idAccessor = Accessor.newInstance(m3, propertyName);
                toAdd = false;
            }
            if (!toAdd) continue;
            this.accessorMap.put(propertyName, Accessor.newInstance(m3, propertyName));
        }
    }

    private boolean isPropertyIdProperty(String idPropertyName, String propertyName) {
        if (this.idAccessor != null) {
            return false;
        }
        return idPropertyName != null && idPropertyName.equals(propertyName);
    }

    private boolean isPropertyGeometryProperty(String geometryPropertyName, Method method, String propertyName) {
        if (this.geometryAccessor != null) {
            return false;
        }
        boolean isGeometry = com.vividsolutions.jts.geom.Geometry.class.isAssignableFrom(method.getReturnType()) || Geometry.class.isAssignableFrom(method.getReturnType());
        return geometryPropertyName != null && geometryPropertyName.equals(propertyName) && isGeometry;
    }

    public static synchronized EntityClassReader getClassReaderFor(Class entityClass) {
        return EntityClassReader.getClassReaderFor(entityClass, EntityClassReader.determineGeomProperty(entityClass), DEFAULT_ID_PROPERTY);
    }

    public static synchronized EntityClassReader getClassReaderFor(Class entityClass, String geometryPropertyName, String idPropertyName) {
        if (entityClass == null) {
            return null;
        }
        String entryKey = "" + geometryPropertyName + "|" + idPropertyName;
        Map<String, EntityClassReader> readersForClass = allReaders.get(entityClass);
        if (readersForClass == null) {
            readersForClass = new HashMap<String, EntityClassReader>();
            allReaders.put(entityClass, readersForClass);
        }
        if (!readersForClass.containsKey(entryKey)) {
            readersForClass.put(entryKey, new EntityClassReader(entityClass, geometryPropertyName, idPropertyName));
        }
        return readersForClass.get(entryKey);
    }

    public String getGeometryName() {
        String result = null;
        if (this.geometryAccessor != null) {
            result = this.geometryAccessor.getPropertyName();
        }
        return result;
    }

    public String getIdName() {
        String result = null;
        if (this.idAccessor != null) {
            result = this.idAccessor.getPropertyName();
        }
        return result;
    }

    public Object getId(Object objectToGet) throws InvalidObjectReaderException {
        if (objectToGet == null) {
            throw new IllegalArgumentException("Given object may not be null");
        }
        if (objectToGet.getClass() != this.entityClass) {
            throw new InvalidObjectReaderException("Class of target object does not correspond with entityclass of this reader.");
        }
        if (this.idAccessor == null) {
            return null;
        }
        return this.idAccessor.getValueFrom(objectToGet);
    }

    public Geometry getGeometry(Object objectToGet) throws InvalidObjectReaderException {
        if (objectToGet == null) {
            throw new IllegalArgumentException("The given object may not be null");
        }
        if (objectToGet.getClass() != this.entityClass) {
            throw new InvalidObjectReaderException("Class of target object does not correspond with entityclass of this reader.");
        }
        if (this.geometryAccessor == null) {
            return null;
        }
        return (Geometry)this.geometryAccessor.getValueFrom(objectToGet);
    }

    public Object getPropertyValue(Object objectToGet, String propertyPath) throws InvalidObjectReaderException {
        if (objectToGet == null || propertyPath == null) {
            throw new IllegalArgumentException("Given object/propertyname may not be null");
        }
        if (objectToGet.getClass() != this.entityClass) {
            throw new InvalidObjectReaderException("Class of target object does not correspond with entityclass of this reader.");
        }
        StringTokenizer tokenizer = new StringTokenizer(propertyPath, ".", false);
        return this.getPropertyValue(objectToGet, tokenizer);
    }

    private Object getPropertyValue(Object objectToGet, StringTokenizer propertyPathParts) {
        String propertyName = propertyPathParts.nextToken();
        Object propertyValue = null;
        if (this.accessorMap.containsKey(propertyName)) {
            propertyValue = this.accessorMap.get(propertyName).getValueFrom(objectToGet);
        }
        if (!propertyPathParts.hasMoreTokens() || propertyValue == null) {
            return propertyValue;
        }
        EntityClassReader currentPathReader = EntityClassReader.getClassReaderFor(propertyValue.getClass());
        return currentPathReader.getPropertyValue(propertyValue, propertyPathParts);
    }

    public Class getPropertyType(String propertyPath) {
        if (propertyPath == null) {
            throw new IllegalArgumentException("Propertyname may not be null");
        }
        StringTokenizer tokenizer = new StringTokenizer(propertyPath, ".", false);
        return this.getPropertyType(tokenizer);
    }

    private Class getPropertyType(StringTokenizer propertyPathParts) {
        String propertyName = propertyPathParts.nextToken();
        Class propertyType = null;
        if (this.accessorMap.containsKey(propertyName)) {
            propertyType = this.accessorMap.get(propertyName).getReturnType();
        } else if (propertyName.equals(this.getIdName())) {
            propertyType = this.idAccessor.getReturnType();
        } else if (propertyName.equals(this.getGeometryName())) {
            propertyType = this.geometryAccessor.getReturnType();
        }
        if (!propertyPathParts.hasMoreTokens() || propertyType == null) {
            return propertyType;
        }
        EntityClassReader currentPathReader = EntityClassReader.getClassReaderFor(propertyType);
        return currentPathReader.getPropertyType(propertyPathParts);
    }

    public boolean exists(String propertyName, boolean trueForSpecialProperties) {
        if (propertyName == null) {
            throw new IllegalArgumentException("Given object may not be null");
        }
        boolean normalProperty = this.accessorMap.containsKey(propertyName);
        return normalProperty || trueForSpecialProperties && (this.getIdName() != null && this.getIdName().equals(propertyName) || this.getGeometryName() != null && this.getGeometryName().equals(propertyName));
    }

    public Collection<String> getProperties() {
        return this.accessorMap.keySet();
    }

    public Feature asFeature(Object objectToTransform) throws InvalidObjectReaderException {
        if (objectToTransform == null) {
            throw new IllegalArgumentException("Given object may not be null");
        }
        if (objectToTransform.getClass() != this.entityClass) {
            throw new InvalidObjectReaderException("Class of target object does not correspond with entityclass of this reader.");
        }
        Feature proxy = (Feature)Proxy.newProxyInstance(this.entityClass.getClassLoader(), new Class[]{Feature.class}, (InvocationHandler)new ObjectInvocationHandler(objectToTransform));
        return proxy;
    }

    private static String propertyName(Method m3) {
        return EntityClassReader.decapitalize(m3.getName().substring(3));
    }

    public Object parseAsPropertyType(String stringToParse, String propertyPath) {
        Class propertyType = this.getPropertyType(propertyPath);
        if (propertyType == null) {
            return null;
        }
        NumberTransformer parser = transformers.get(propertyType);
        return parser == null ? stringToParse : parser.parseObject(stringToParse);
    }

    private static String decapitalize(String inputString) {
        return inputString.length() > 1 ? Character.toLowerCase(inputString.charAt(0)) + inputString.substring(1) : inputString.toUpperCase();
    }

    static {
        Class[] emptyArray = new Class[]{};
        try {
            proxyGeomGetMethod = Feature.class.getDeclaredMethod("getGeometry", emptyArray);
            proxyGeomNameGetMethod = Feature.class.getDeclaredMethod("getGeometryName", emptyArray);
            proxyIdGetMethod = Feature.class.getDeclaredMethod("getId", emptyArray);
            proxyExistsMethod = Feature.class.getDeclaredMethod("hasProperty", String.class, Boolean.TYPE);
            proxyAttributeGetMethod = Feature.class.getDeclaredMethod("getProperty", String.class);
            proxyPropertiesGetMethod = Feature.class.getDeclaredMethod("getProperties", emptyArray);
        }
        catch (NoSuchMethodException e2) {
            throw new RuntimeException("Version mismatch: apparently certain methods are not present in the Feature interface", e2);
        }
        transformers = new HashMap<Class, NumberTransformer>();
        transformers.put(Integer.class, new IntegerTransformer());
        transformers.put(Integer.TYPE, new IntegerTransformer());
        transformers.put(Long.class, new LongTransformer());
        transformers.put(Long.TYPE, new LongTransformer());
        transformers.put(Double.class, new DoubleTransformer());
        transformers.put(Double.TYPE, new DoubleTransformer());
        transformers.put(Short.class, new ShortTransformer());
        transformers.put(Short.TYPE, new ShortTransformer());
        transformers.put(Float.class, new FloatTransformer());
        transformers.put(Float.TYPE, new FloatTransformer());
        transformers.put(Boolean.class, new BooleanTransformer());
        transformers.put(Boolean.TYPE, new BooleanTransformer());
        transformers.put(Byte.class, new ByteTransformer());
        transformers.put(Byte.TYPE, new ByteTransformer());
        transformers.put(BigDecimal.class, new BigDecimalTransformer());
    }

    private static class ShortTransformer
    implements NumberTransformer {
        private ShortTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return Short.valueOf(s2);
        }
    }

    private static class ByteTransformer
    implements NumberTransformer {
        private ByteTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return Byte.valueOf(s2);
        }
    }

    private static class FloatTransformer
    implements NumberTransformer {
        private FloatTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return Float.valueOf(s2);
        }
    }

    private static class BooleanTransformer
    implements NumberTransformer {
        private BooleanTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return Boolean.valueOf(s2);
        }
    }

    private static class LongTransformer
    implements NumberTransformer {
        private LongTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return Long.valueOf(s2);
        }
    }

    private static class DoubleTransformer
    implements NumberTransformer {
        private DoubleTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return Double.valueOf(s2);
        }
    }

    private static class BigDecimalTransformer
    implements NumberTransformer {
        private BigDecimalTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return BigDecimal.valueOf(Double.valueOf(s2));
        }
    }

    private static class IntegerTransformer
    implements NumberTransformer {
        private IntegerTransformer() {
        }

        @Override
        public Object parseObject(String s2) {
            return Integer.valueOf(s2);
        }
    }

    private static interface NumberTransformer {
        public Object parseObject(String var1);
    }

    class ObjectInvocationHandler
    implements InvocationHandler {
        private Object target;

        ObjectInvocationHandler(Object targetObject) {
            this.target = targetObject;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (proxyAttributeGetMethod.equals(method)) {
                return EntityClassReader.this.getPropertyValue(this.target, (String)args[0]);
            }
            if (proxyIdGetMethod.equals(method)) {
                return EntityClassReader.this.getId(this.target);
            }
            if (proxyGeomGetMethod.equals(method)) {
                return EntityClassReader.this.getGeometry(this.target);
            }
            if (proxyGeomNameGetMethod.equals(method)) {
                return EntityClassReader.this.getGeometryName();
            }
            if (proxyPropertiesGetMethod.equals(method)) {
                return EntityClassReader.this.getProperties();
            }
            if (proxyExistsMethod.equals(method)) {
                return EntityClassReader.this.exists((String)args[0], (Boolean)args[1]);
            }
            throw new RuntimeException("Unexisting method invoked on proxy.");
        }
    }
}

