/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.expressions;

import org.geolatte.common.expressions.And;
import org.geolatte.common.expressions.BasicTypeSwitch;
import org.geolatte.common.expressions.ComparableExpression;
import org.geolatte.common.expressions.Expression;
import org.geolatte.common.expressions.Or;

public abstract class BooleanExpression
implements Expression<Boolean>,
ComparableExpression<Boolean> {
    public And and(Expression<Boolean> right) {
        return new And(this, right);
    }

    public Or or(Expression<Boolean> right) {
        return new Or(this, right);
    }

    @Override
    public int compareTo(Object evaluateObject, Boolean value) throws ClassCastException, NullPointerException {
        if (value == null) {
            throw new NullPointerException("Cannot compare boolean to null");
        }
        Boolean thisBoolean = (Boolean)this.evaluate(evaluateObject);
        if (thisBoolean == null) {
            throw new NullPointerException("BooleanExpression evaluates to null, cannot compare this.");
        }
        if (thisBoolean.booleanValue()) {
            return value != false ? 0 : 1;
        }
        return value != false ? -1 : 0;
    }

    @Override
    public void switchOn(BasicTypeSwitch switcher) {
        switcher.caseBoolean(this);
    }
}

