/*
 * Decompiled with CFR 0.152.
 */
package org.geolatte.common.cql;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.HashMap;
import org.geolatte.common.cql.FilterExpressionBuilder;
import org.geolatte.common.cql.lexer.Lexer;
import org.geolatte.common.cql.lexer.LexerException;
import org.geolatte.common.cql.node.Start;
import org.geolatte.common.cql.parser.Parser;
import org.geolatte.common.cql.parser.ParserException;
import org.geolatte.common.expressions.Filter;

public class CqlFilter {
    private String cqlString;
    private final HashMap<Class, Filter> filterExpressions = new HashMap();

    public CqlFilter(String cqlString) throws IllegalArgumentException {
        this.cqlString = cqlString;
    }

    public Boolean evaluate(Object object) throws ParseException {
        Class<?> clazz = object.getClass();
        Filter currentFilter = this.filterExpressions.get(clazz);
        try {
            Parser p2 = new Parser(new Lexer(new PushbackReader(new StringReader(this.cqlString), 1024)));
            Start tree = p2.parse();
            FilterExpressionBuilder builder = new FilterExpressionBuilder(clazz);
            tree.apply(builder);
            currentFilter = new Filter(builder.getExp());
            this.filterExpressions.put(clazz, currentFilter);
        }
        catch (ParserException e2) {
            ParseException parseException = new ParseException(e2.getMessage(), e2.getToken().getPos());
            parseException.initCause(e2);
            throw parseException;
        }
        catch (LexerException e3) {
            ParseException parseException = new ParseException(e3.getMessage(), 0);
            parseException.initCause(e3);
            throw parseException;
        }
        catch (IOException e4) {
            ParseException parseException = new ParseException(e4.getMessage(), 0);
            parseException.initCause(e4);
            throw parseException;
        }
        return currentFilter.evaluate(object);
    }
}

