/*
 * Decompiled with CFR 0.152.
 */
package org.geojson.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.ArrayList;
import org.geojson.LngLatAlt;

public class LngLatAltDeserializer
extends JsonDeserializer<LngLatAlt> {
    @Override
    public LngLatAlt deserialize(JsonParser jp2, DeserializationContext ctxt) throws IOException {
        if (jp2.isExpectedStartArrayToken()) {
            return this.deserializeArray(jp2, ctxt);
        }
        throw ctxt.mappingException(LngLatAlt.class);
    }

    protected LngLatAlt deserializeArray(JsonParser jp2, DeserializationContext ctxt) throws IOException {
        LngLatAlt node = new LngLatAlt();
        node.setLongitude(this.extractDouble(jp2, ctxt, false));
        node.setLatitude(this.extractDouble(jp2, ctxt, false));
        node.setAltitude(this.extractDouble(jp2, ctxt, true));
        ArrayList<Double> additionalElementsList = new ArrayList<Double>();
        while (jp2.hasCurrentToken() && jp2.getCurrentToken() != JsonToken.END_ARRAY) {
            double element = this.extractDouble(jp2, ctxt, true);
            if (Double.isNaN(element)) continue;
            additionalElementsList.add(element);
        }
        double[] additionalElements = new double[additionalElementsList.size()];
        for (int i2 = 0; i2 < additionalElements.length; ++i2) {
            additionalElements[i2] = (Double)additionalElementsList.get(i2);
        }
        node.setAdditionalElements(additionalElements);
        return node;
    }

    private double extractDouble(JsonParser jp2, DeserializationContext ctxt, boolean optional) throws IOException {
        JsonToken token = jp2.nextToken();
        if (token == null) {
            if (optional) {
                return Double.NaN;
            }
            throw ctxt.mappingException("Unexpected end-of-input when binding data into LngLatAlt");
        }
        switch (token) {
            case END_ARRAY: {
                if (optional) {
                    return Double.NaN;
                }
                throw ctxt.mappingException("Unexpected end-of-input when binding data into LngLatAlt");
            }
            case VALUE_NUMBER_FLOAT: {
                return jp2.getDoubleValue();
            }
            case VALUE_NUMBER_INT: {
                return jp2.getLongValue();
            }
            case VALUE_STRING: {
                return jp2.getValueAsDouble();
            }
        }
        throw ctxt.mappingException("Unexpected token (" + token.name() + ") when binding data into LngLatAlt");
    }
}

