/*
 * Decompiled with CFR 0.152.
 */
package org.geojson;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.Map;
import org.geojson.GeoJsonObject;
import org.geojson.GeoJsonObjectVisitor;

public class Feature
extends GeoJsonObject {
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private Map<String, Object> properties = new HashMap<String, Object>();
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    private GeoJsonObject geometry;
    private String id;

    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    public <T> T getProperty(String key) {
        return (T)this.properties.get(key);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public GeoJsonObject getGeometry() {
        return this.geometry;
    }

    public void setGeometry(GeoJsonObject geometry) {
        this.geometry = geometry;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    @Override
    public <T> T accept(GeoJsonObjectVisitor<T> geoJsonObjectVisitor) {
        return geoJsonObjectVisitor.visit(this);
    }

    @Override
    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        if (!super.equals(o2)) {
            return false;
        }
        Feature feature = (Feature)o2;
        if (this.properties != null ? !this.properties.equals(feature.properties) : feature.properties != null) {
            return false;
        }
        if (this.geometry != null ? !this.geometry.equals(feature.geometry) : feature.geometry != null) {
            return false;
        }
        return !(this.id == null ? feature.id != null : !this.id.equals(feature.id));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        result = 31 * result + (this.geometry != null ? this.geometry.hashCode() : 0);
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "Feature{properties=" + this.properties + ", geometry=" + this.geometry + ", id='" + this.id + "'}";
    }
}

