/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.ExceptionHelper;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class MqttInputStream
extends InputStream {
    private final String CLASS_NAME = MqttInputStream.class.getName();
    private final Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", this.CLASS_NAME);
    private ClientState clientState = null;
    private DataInputStream in;
    private ByteArrayOutputStream bais;
    private int remLen;
    private int packetLen;
    private byte[] packet;

    public MqttInputStream(ClientState clientState, InputStream in2) {
        this.clientState = clientState;
        this.in = new DataInputStream(in2);
        this.bais = new ByteArrayOutputStream();
        this.remLen = -1;
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public MqttWireMessage readMqttWireMessage() throws IOException, MqttException {
        String methodName = "readMqttWireMessage";
        MqttWireMessage message = null;
        try {
            if (this.remLen < 0) {
                this.bais.reset();
                byte first = this.in.readByte();
                this.clientState.notifyReceivedBytes(1);
                byte type = (byte)(first >>> 4 & 0xF);
                if (type < 1 || type > 14) {
                    throw ExceptionHelper.createMqttException(32108);
                }
                this.remLen = MqttWireMessage.readMBI(this.in).getValue();
                this.bais.write(first);
                this.bais.write(MqttWireMessage.encodeMBI(this.remLen));
                this.packet = new byte[this.bais.size() + this.remLen];
                this.packetLen = 0;
            }
            if (this.remLen >= 0) {
                this.readFully();
                this.remLen = -1;
                byte[] header = this.bais.toByteArray();
                System.arraycopy(header, 0, this.packet, 0, header.length);
                message = MqttWireMessage.createWireMessage(this.packet);
                this.log.fine(this.CLASS_NAME, "readMqttWireMessage", "301", new Object[]{message});
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            // empty catch block
        }
        return message;
    }

    private void readFully() throws IOException {
        int off = this.bais.size() + this.packetLen;
        int len = this.remLen - this.packetLen;
        if (len < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = 0;
        while (n2 < len) {
            int count = -1;
            try {
                count = this.in.read(this.packet, off + n2, len - n2);
            }
            catch (SocketTimeoutException e2) {
                this.packetLen += n2;
                throw e2;
            }
            if (count < 0) {
                throw new EOFException();
            }
            this.clientState.notifyReceivedBytes(count);
            n2 += count;
        }
    }
}

