/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.internal.ClientComms;
import org.eclipse.paho.client.mqttv3.internal.ClientState;
import org.eclipse.paho.client.mqttv3.internal.CommsTokenStore;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttAck;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttDisconnect;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttOutputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttWireMessage;
import org.eclipse.paho.client.mqttv3.logging.Logger;
import org.eclipse.paho.client.mqttv3.logging.LoggerFactory;

public class CommsSender
implements Runnable {
    private static final String CLASS_NAME = CommsSender.class.getName();
    private Logger log = LoggerFactory.getLogger("org.eclipse.paho.client.mqttv3.internal.nls.logcat", CLASS_NAME);
    private State current_state = State.STOPPED;
    private State target_state = State.STOPPED;
    private final Object lifecycle = new Object();
    private Thread sendThread = null;
    private String threadName;
    private Future<?> senderFuture;
    private ClientState clientState = null;
    private MqttOutputStream out;
    private ClientComms clientComms = null;
    private CommsTokenStore tokenStore = null;

    public CommsSender(ClientComms clientComms, ClientState clientState, CommsTokenStore tokenStore, OutputStream out) {
        this.out = new MqttOutputStream(clientState, out);
        this.clientComms = clientComms;
        this.clientState = clientState;
        this.tokenStore = tokenStore;
        this.log.setResourceName(clientComms.getClient().getClientId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void start(String threadName, ExecutorService executorService) {
        this.threadName = threadName;
        var3_3 = this.lifecycle;
        synchronized (var3_3) {
            if (this.current_state == State.STOPPED && this.target_state == State.STOPPED) {
                this.target_state = State.RUNNING;
                if (executorService == null) {
                    new Thread(this).start();
                } else {
                    this.senderFuture = executorService.submit(this);
                }
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl11 : MonitorExitStatement: MONITOREXIT : var3_3
            if (true) ** GOTO lbl21
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception var3_4) {
                // empty catch block
            }
lbl21:
            // 3 sources

        } while (!this.isRunning());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void stop() {
        methodName = "stop";
        if (!this.isRunning()) {
            return;
        }
        var2_2 = this.lifecycle;
        synchronized (var2_2) {
            if (this.senderFuture != null) {
                this.senderFuture.cancel(true);
            }
            this.log.fine(CommsSender.CLASS_NAME, "stop", "800");
            if (this.isRunning()) {
                this.target_state = State.STOPPED;
                this.clientState.notifyQueueLock();
            }
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl14 : MonitorExitStatement: MONITOREXIT : var2_2
            if (true) ** GOTO lbl25
        }
        do {
            try {
                Thread.sleep(100L);
            }
            catch (Exception var2_3) {
                // empty catch block
            }
            this.clientState.notifyQueueLock();
lbl25:
            // 2 sources

        } while (this.isRunning());
        this.log.fine(CommsSender.CLASS_NAME, "stop", "801");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public void run() {
        this.sendThread = Thread.currentThread();
        this.sendThread.setName(this.threadName);
        methodName = "run";
        message = null;
        var3_3 = this.lifecycle;
        synchronized (var3_3) {
            this.current_state = State.RUNNING;
        }
        try {
            var4_4 = this.lifecycle;
            synchronized (var4_4) {
                my_target = this.target_state;
                // MONITOREXIT @DISABLED, blocks:[1, 2, 11] lbl19 : MonitorExitStatement: MONITOREXIT : var4_4
                if (true) ** GOTO lbl70
            }
            do {
                block32: {
                    try {
                        message = this.clientState.get();
                        if (message != null) {
                            this.log.fine(CommsSender.CLASS_NAME, "run", "802", new Object[]{message.getKey(), message});
                            if (message instanceof MqttAck) {
                                this.out.write(message);
                                this.out.flush();
                                break block32;
                            }
                            token = message.getToken();
                            if (token == null) {
                                token = this.tokenStore.getToken(message);
                            }
                            if (token == null) break block32;
                            var5_7 = token;
                            synchronized (var5_7) {
                                block33: {
                                    this.out.write(message);
                                    try {
                                        this.out.flush();
                                    }
                                    catch (IOException ex) {
                                        if (message instanceof MqttDisconnect) break block33;
                                        throw ex;
                                    }
                                }
                                this.clientState.notifySent(message);
                                break block32;
                            }
                        }
                        this.log.fine(CommsSender.CLASS_NAME, "run", "803");
                        token = this.lifecycle;
                        synchronized (token) {
                            this.target_state = State.STOPPED;
                        }
                    }
                    catch (MqttException me) {
                        this.handleRunException(message, me);
                    }
                    catch (Exception ex) {
                        this.handleRunException(message, ex);
                    }
                }
                var4_4 = this.lifecycle;
                synchronized (var4_4) {
                    my_target = this.target_state;
                }
lbl70:
                // 2 sources

            } while (my_target == State.RUNNING && this.out != null);
        }
        catch (Throwable var7_9) {
            var8_10 = this.lifecycle;
            synchronized (var8_10) {
                this.current_state = State.STOPPED;
                this.sendThread = null;
            }
            throw var7_9;
        }
        var8_11 = this.lifecycle;
        synchronized (var8_11) {
            this.current_state = State.STOPPED;
            this.sendThread = null;
        }
        this.log.fine(CommsSender.CLASS_NAME, "run", "805");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRunException(MqttWireMessage message, Exception ex2) {
        String methodName = "handleRunException";
        this.log.fine(CLASS_NAME, "handleRunException", "804", null, ex2);
        MqttException mex = !(ex2 instanceof MqttException) ? new MqttException(32109, (Throwable)ex2) : (MqttException)ex2;
        Object object = this.lifecycle;
        synchronized (object) {
            this.target_state = State.STOPPED;
        }
        this.clientComms.shutdownConnection(null, mex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        boolean result;
        Object object = this.lifecycle;
        synchronized (object) {
            result = this.current_state == State.RUNNING && this.target_state == State.RUNNING;
        }
        return result;
    }

    private static enum State {
        STOPPED,
        RUNNING,
        STARTING;

    }
}

