/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3;

import java.util.Properties;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.MqttTopic;
import org.eclipse.paho.client.mqttv3.internal.NetworkModuleService;
import org.eclipse.paho.client.mqttv3.util.Debug;

public class MqttConnectOptions {
    public static final int KEEP_ALIVE_INTERVAL_DEFAULT = 60;
    public static final int CONNECTION_TIMEOUT_DEFAULT = 30;
    public static final int MAX_INFLIGHT_DEFAULT = 10;
    public static final boolean CLEAN_SESSION_DEFAULT = true;
    public static final int MQTT_VERSION_DEFAULT = 0;
    public static final int MQTT_VERSION_3_1 = 3;
    public static final int MQTT_VERSION_3_1_1 = 4;
    private int keepAliveInterval = 60;
    private int maxInflight = 10;
    private String willDestination = null;
    private MqttMessage willMessage = null;
    private String userName;
    private char[] password;
    private SocketFactory socketFactory;
    private Properties sslClientProps = null;
    private boolean httpsHostnameVerificationEnabled = true;
    private HostnameVerifier sslHostnameVerifier = null;
    private boolean cleanSession = true;
    private int connectionTimeout = 30;
    private String[] serverURIs = null;
    private int mqttVersion = 0;
    private boolean automaticReconnect = false;
    private int maxReconnectDelay = 128000;
    private Properties customWebSocketHeaders = null;
    private int executorServiceTimeout = 1;

    public char[] getPassword() {
        return this.password;
    }

    public void setPassword(char[] password) {
        this.password = (char[])password.clone();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public int getMaxReconnectDelay() {
        return this.maxReconnectDelay;
    }

    public void setMaxReconnectDelay(int maxReconnectDelay) {
        this.maxReconnectDelay = maxReconnectDelay;
    }

    public void setWill(MqttTopic topic, byte[] payload, int qos, boolean retained) {
        String topicS = topic.getName();
        this.validateWill(topicS, payload);
        this.setWill(topicS, new MqttMessage(payload), qos, retained);
    }

    public void setWill(String topic, byte[] payload, int qos, boolean retained) {
        this.validateWill(topic, payload);
        this.setWill(topic, new MqttMessage(payload), qos, retained);
    }

    private void validateWill(String dest, Object payload) {
        if (dest == null || payload == null) {
            throw new IllegalArgumentException();
        }
        MqttTopic.validate(dest, false);
    }

    protected void setWill(String topic, MqttMessage msg, int qos, boolean retained) {
        this.willDestination = topic;
        this.willMessage = msg;
        this.willMessage.setQos(qos);
        this.willMessage.setRetained(retained);
        this.willMessage.setMutable(false);
    }

    public int getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public int getMqttVersion() {
        return this.mqttVersion;
    }

    public void setKeepAliveInterval(int keepAliveInterval) throws IllegalArgumentException {
        if (keepAliveInterval < 0) {
            throw new IllegalArgumentException();
        }
        this.keepAliveInterval = keepAliveInterval;
    }

    public int getMaxInflight() {
        return this.maxInflight;
    }

    public void setMaxInflight(int maxInflight) {
        if (maxInflight < 0) {
            throw new IllegalArgumentException();
        }
        this.maxInflight = maxInflight;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        if (connectionTimeout < 0) {
            throw new IllegalArgumentException();
        }
        this.connectionTimeout = connectionTimeout;
    }

    public SocketFactory getSocketFactory() {
        return this.socketFactory;
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        this.socketFactory = socketFactory;
    }

    public String getWillDestination() {
        return this.willDestination;
    }

    public MqttMessage getWillMessage() {
        return this.willMessage;
    }

    public Properties getSSLProperties() {
        return this.sslClientProps;
    }

    public void setSSLProperties(Properties props) {
        this.sslClientProps = props;
    }

    public boolean isHttpsHostnameVerificationEnabled() {
        return this.httpsHostnameVerificationEnabled;
    }

    public void setHttpsHostnameVerificationEnabled(boolean httpsHostnameVerificationEnabled) {
        this.httpsHostnameVerificationEnabled = httpsHostnameVerificationEnabled;
    }

    public HostnameVerifier getSSLHostnameVerifier() {
        return this.sslHostnameVerifier;
    }

    public void setSSLHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.sslHostnameVerifier = hostnameVerifier;
    }

    public boolean isCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(boolean cleanSession) {
        this.cleanSession = cleanSession;
    }

    public String[] getServerURIs() {
        return this.serverURIs;
    }

    public void setServerURIs(String[] serverURIs) {
        String[] stringArray = serverURIs;
        int n2 = serverURIs.length;
        int n3 = 0;
        while (n3 < n2) {
            String serverURI = stringArray[n3];
            NetworkModuleService.validateURI(serverURI);
            ++n3;
        }
        this.serverURIs = (String[])serverURIs.clone();
    }

    public void setMqttVersion(int mqttVersion) throws IllegalArgumentException {
        if (mqttVersion != 0 && mqttVersion != 3 && mqttVersion != 4) {
            throw new IllegalArgumentException("An incorrect version was used \"" + mqttVersion + "\". Acceptable version options are " + 0 + ", " + 3 + " and " + 4 + ".");
        }
        this.mqttVersion = mqttVersion;
    }

    public boolean isAutomaticReconnect() {
        return this.automaticReconnect;
    }

    public void setAutomaticReconnect(boolean automaticReconnect) {
        this.automaticReconnect = automaticReconnect;
    }

    public int getExecutorServiceTimeout() {
        return this.executorServiceTimeout;
    }

    public void setExecutorServiceTimeout(int executorServiceTimeout) {
        this.executorServiceTimeout = executorServiceTimeout;
    }

    public Properties getDebug() {
        String strNull = "null";
        Properties p2 = new Properties();
        p2.put("MqttVersion", (Object)this.getMqttVersion());
        p2.put("CleanSession", (Object)this.isCleanSession());
        p2.put("ConTimeout", (Object)this.getConnectionTimeout());
        p2.put("KeepAliveInterval", (Object)this.getKeepAliveInterval());
        p2.put("UserName", this.getUserName() == null ? "null" : this.getUserName());
        p2.put("WillDestination", this.getWillDestination() == null ? "null" : this.getWillDestination());
        if (this.getSocketFactory() == null) {
            p2.put("SocketFactory", "null");
        } else {
            p2.put("SocketFactory", this.getSocketFactory());
        }
        if (this.getSSLProperties() == null) {
            p2.put("SSLProperties", "null");
        } else {
            p2.put("SSLProperties", this.getSSLProperties());
        }
        return p2;
    }

    public void setCustomWebSocketHeaders(Properties props) {
        this.customWebSocketHeaders = props;
    }

    public Properties getCustomWebSocketHeaders() {
        return this.customWebSocketHeaders;
    }

    public String toString() {
        return Debug.dumpProperties(this.getDebug(), "Connection options");
    }
}

