/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import net.time4j.CalendarUnit;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.Weekday;
import net.time4j.base.GregorianMath;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.SPX;

final class DayOfWeekInMonthPattern
extends GregorianTimezoneRule {
    private static final long serialVersionUID = -7354650946442523175L;
    private final transient byte dayOfMonth;
    private final transient byte dayOfWeek;
    private final transient boolean after;

    DayOfWeekInMonthPattern(Month month, int n2, Weekday weekday, int n3, OffsetIndicator offsetIndicator, int n4, boolean bl2) {
        super(month, n3, offsetIndicator, n4);
        GregorianMath.checkDate(2000, month.getValue(), n2);
        this.dayOfMonth = (byte)n2;
        this.dayOfWeek = (byte)weekday.getValue();
        this.after = bl2;
    }

    @Override
    protected PlainDate getDate0(int n2) {
        byte by2 = this.getMonthValue();
        int n3 = GregorianMath.getDayOfWeek(n2, by2, this.dayOfMonth);
        PlainDate plainDate = PlainDate.of(n2, (int)by2, (int)this.dayOfMonth);
        if (n3 == this.dayOfWeek) {
            return plainDate;
        }
        int n4 = n3 - this.dayOfWeek;
        int n5 = -1;
        if (this.after) {
            n4 = -n4;
            n5 = 1;
        }
        if (n4 < 0) {
            n4 += 7;
        }
        return plainDate.plus((long)(n4 * n5), CalendarUnit.DAYS);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DayOfWeekInMonthPattern) {
            DayOfWeekInMonthPattern dayOfWeekInMonthPattern = (DayOfWeekInMonthPattern)object;
            return this.dayOfMonth == dayOfWeekInMonthPattern.dayOfMonth && this.dayOfWeek == dayOfWeekInMonthPattern.dayOfWeek && this.after == dayOfWeekInMonthPattern.after && super.isEqual(dayOfWeekInMonthPattern);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.dayOfMonth;
        return (n2 += 17 * (this.dayOfWeek + 37 * this.getMonthValue())) + (this.after ? 1 : 0);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("DayOfWeekInMonthPattern:[month=");
        stringBuilder.append(this.getMonthValue());
        stringBuilder.append(",dayOfMonth=");
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append(",dayOfWeek=");
        stringBuilder.append(Weekday.valueOf(this.dayOfWeek));
        stringBuilder.append(",day-overflow=");
        stringBuilder.append(this.getDayOverflow());
        stringBuilder.append(",time-of-day=");
        stringBuilder.append(this.getTimeOfDay());
        stringBuilder.append(",offset-indicator=");
        stringBuilder.append((Object)this.getIndicator());
        stringBuilder.append(",dst-offset=");
        stringBuilder.append(this.getSavings());
        stringBuilder.append(",after=");
        stringBuilder.append(this.after);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    int getDayOfMonth() {
        return this.dayOfMonth;
    }

    byte getDayOfWeek() {
        return this.dayOfWeek;
    }

    boolean isAfter() {
        return this.after;
    }

    @Override
    int getType() {
        return 121;
    }

    private Object writeReplace() {
        return new SPX(this, this.getType());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

