/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.ArrayTransitionModel;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.RuleBasedTransitionModel;
import net.time4j.tz.model.SPX;
import net.time4j.tz.model.TransitionModel;

final class CompositeTransitionModel
extends TransitionModel {
    private static final long serialVersionUID = 1749643877954103721L;
    private final transient int size;
    private final transient ArrayTransitionModel arrayModel;
    private final transient RuleBasedTransitionModel ruleModel;
    private final transient ZonalTransition last;
    private transient int hash = 0;

    CompositeTransitionModel(int n2, List<ZonalTransition> list, List<DaylightSavingRule> list2, boolean bl2, boolean bl3) {
        this.size = n2;
        this.arrayModel = new ArrayTransitionModel(list, bl2, bl3);
        this.last = this.arrayModel.getLastTransition();
        this.ruleModel = new RuleBasedTransitionModel(this.last, list2, bl2);
    }

    @Override
    public ZonalOffset getInitialOffset() {
        return this.arrayModel.getInitialOffset();
    }

    @Override
    public ZonalTransition getStartTransition(UnixTime unixTime) {
        if (unixTime.getPosixTime() < this.last.getPosixTime()) {
            return this.arrayModel.getStartTransition(unixTime);
        }
        ZonalTransition zonalTransition = this.ruleModel.getStartTransition(unixTime);
        return zonalTransition == null ? this.last : zonalTransition;
    }

    @Override
    public ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        return this.arrayModel.getConflictTransition(gregorianDate, wallTime, this.ruleModel);
    }

    @Override
    public Optional<ZonalTransition> findNextTransition(UnixTime unixTime) {
        Optional<ZonalTransition> optional = this.arrayModel.findNextTransition(unixTime);
        if (!optional.isPresent()) {
            optional = this.ruleModel.findNextTransition(unixTime);
        }
        return optional;
    }

    @Override
    public List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime) {
        return this.arrayModel.getValidOffsets(gregorianDate, wallTime, this.ruleModel);
    }

    @Override
    public List<ZonalTransition> getStdTransitions() {
        return this.arrayModel.getStdTransitions();
    }

    @Override
    public List<ZonalTransition> getTransitions(UnixTime unixTime, UnixTime unixTime2) {
        ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>();
        arrayList.addAll(this.arrayModel.getTransitions(unixTime, unixTime2));
        arrayList.addAll(this.ruleModel.getTransitions(unixTime, unixTime2));
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public void dump(Appendable appendable) throws IOException {
        this.arrayModel.dump(this.size, appendable);
        this.ruleModel.dump(appendable);
    }

    @Override
    public boolean hasNegativeDST() {
        return this.ruleModel.hasNegativeDST() || this.arrayModel.hasNegativeDST();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CompositeTransitionModel) {
            CompositeTransitionModel compositeTransitionModel = (CompositeTransitionModel)object;
            return this.arrayModel.equals(compositeTransitionModel.arrayModel, this.size, compositeTransitionModel.size) && this.ruleModel.getRules().equals(compositeTransitionModel.ruleModel.getRules());
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            n2 = this.arrayModel.hashCode(this.size);
            this.hash = n2 += 37 * this.ruleModel.getRules().hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[transition-count=");
        stringBuilder.append(this.size);
        stringBuilder.append(",hash=");
        stringBuilder.append(this.hashCode());
        stringBuilder.append(",last-rules=");
        stringBuilder.append(this.ruleModel.getRules());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    void writeTransitions(ObjectOutput objectOutput) throws IOException {
        this.arrayModel.writeTransitions(this.size, objectOutput);
    }

    List<DaylightSavingRule> getRules() {
        return this.ruleModel.getRules();
    }

    private Object writeReplace() {
        return new SPX(this, 127);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

