/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.time4j.Moment;
import net.time4j.base.GregorianDate;
import net.time4j.base.UnixTime;
import net.time4j.base.WallTime;
import net.time4j.scale.TimeScale;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.model.RuleBasedTransitionModel;
import net.time4j.tz.model.SPX;
import net.time4j.tz.model.TransitionModel;

final class ArrayTransitionModel
extends TransitionModel {
    private static final long serialVersionUID = -5264909488983076587L;
    private final transient ZonalTransition[] transitions;
    private final transient boolean negativeDST;
    private final transient List<ZonalTransition> stdTransitions;
    private transient int hash = 0;

    ArrayTransitionModel(List<ZonalTransition> list) {
        this(list, true, true);
    }

    ArrayTransitionModel(List<ZonalTransition> list, boolean bl2, boolean bl3) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Missing timezone transitions.");
        }
        int n2 = list.size();
        Object[] objectArray = new ZonalTransition[n2];
        objectArray = list.toArray(objectArray);
        boolean bl4 = false;
        for (ZonalTransition zonalTransition : objectArray) {
            bl4 = bl4 || zonalTransition.getExtraOffset() < 0;
        }
        this.negativeDST = bl4;
        if (bl2) {
            Arrays.sort(objectArray);
        }
        if (bl3) {
            ArrayTransitionModel.checkSanity((ZonalTransition[])objectArray, list);
        }
        this.transitions = objectArray;
        long l2 = TransitionModel.getFutureMoment(1);
        this.stdTransitions = ArrayTransitionModel.getTransitions(this.transitions, 0L, l2);
    }

    @Override
    public ZonalOffset getInitialOffset() {
        return ZonalOffset.ofTotalSeconds(this.transitions[0].getPreviousOffset());
    }

    @Override
    public ZonalTransition getStartTransition(UnixTime unixTime) {
        int n2 = ArrayTransitionModel.search(unixTime.getPosixTime(), this.transitions);
        return n2 == 0 ? null : this.transitions[n2 - 1];
    }

    @Override
    public ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime) {
        return this.getConflictTransition(gregorianDate, wallTime, null);
    }

    @Override
    public Optional<ZonalTransition> findNextTransition(UnixTime unixTime) {
        int n2 = ArrayTransitionModel.search(unixTime.getPosixTime(), this.transitions);
        return n2 == this.transitions.length ? Optional.empty() : Optional.of(this.transitions[n2]);
    }

    @Override
    public List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime) {
        return this.getValidOffsets(gregorianDate, wallTime, null);
    }

    @Override
    public List<ZonalTransition> getStdTransitions() {
        return this.stdTransitions;
    }

    @Override
    public List<ZonalTransition> getTransitions(UnixTime unixTime, UnixTime unixTime2) {
        return ArrayTransitionModel.getTransitions(this.transitions, unixTime.getPosixTime(), unixTime2.getPosixTime());
    }

    @Override
    public void dump(Appendable appendable) throws IOException {
        this.dump(this.transitions.length, appendable);
    }

    @Override
    public boolean hasNegativeDST() {
        return this.negativeDST;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ArrayTransitionModel) {
            ArrayTransitionModel arrayTransitionModel = (ArrayTransitionModel)object;
            return Arrays.equals(this.transitions, arrayTransitionModel.transitions);
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.hash;
        if (n2 == 0) {
            this.hash = n2 = Arrays.hashCode(this.transitions);
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[transition-count=");
        stringBuilder.append(this.transitions.length);
        stringBuilder.append(",hash=");
        stringBuilder.append(this.hashCode());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    ZonalTransition getConflictTransition(GregorianDate gregorianDate, WallTime wallTime, RuleBasedTransitionModel ruleBasedTransitionModel) {
        long l2 = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        int n2 = ArrayTransitionModel.searchLocal(l2, this.transitions);
        if (n2 == this.transitions.length) {
            return ruleBasedTransitionModel == null ? null : ruleBasedTransitionModel.getConflictTransition(gregorianDate, l2);
        }
        ZonalTransition zonalTransition = this.transitions[n2];
        if (zonalTransition.isGap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() > l2);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() <= l2) {
                return zonalTransition;
            }
        } else if (zonalTransition.isOverlap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() > l2);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() <= l2) {
                return zonalTransition;
            }
        }
        return null;
    }

    List<ZonalOffset> getValidOffsets(GregorianDate gregorianDate, WallTime wallTime, RuleBasedTransitionModel ruleBasedTransitionModel) {
        long l2 = TransitionModel.toLocalSecs(gregorianDate, wallTime);
        int n2 = ArrayTransitionModel.searchLocal(l2, this.transitions);
        if (n2 == this.transitions.length) {
            if (ruleBasedTransitionModel == null) {
                ZonalTransition zonalTransition = this.transitions[this.transitions.length - 1];
                return TransitionModel.toList(zonalTransition.getTotalOffset());
            }
            return ruleBasedTransitionModel.getValidOffsets(gregorianDate, l2);
        }
        ZonalTransition zonalTransition = this.transitions[n2];
        if (zonalTransition.isGap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() > l2);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() <= l2) {
                return Collections.emptyList();
            }
        } else if (zonalTransition.isOverlap()) {
            assert (zonalTransition.getPosixTime() + (long)zonalTransition.getPreviousOffset() > l2);
            if (zonalTransition.getPosixTime() + (long)zonalTransition.getTotalOffset() <= l2) {
                return TransitionModel.toList(zonalTransition.getTotalOffset(), zonalTransition.getPreviousOffset());
            }
        }
        return TransitionModel.toList(zonalTransition.getPreviousOffset());
    }

    void dump(int n2, Appendable appendable) throws IOException {
        for (int i2 = 0; i2 < n2; ++i2) {
            ZonalTransition zonalTransition = this.transitions[i2];
            TransitionModel.dump(zonalTransition, appendable);
        }
    }

    ZonalTransition getLastTransition() {
        return this.transitions[this.transitions.length - 1];
    }

    boolean equals(ArrayTransitionModel arrayTransitionModel, int n2, int n3) {
        int n4;
        int n5 = Math.min(n2, this.transitions.length);
        if (n5 != (n4 = Math.min(n3, arrayTransitionModel.transitions.length))) {
            return false;
        }
        for (int i2 = 0; i2 < n5; ++i2) {
            if (this.transitions[i2].equals(arrayTransitionModel.transitions[i2])) continue;
            return false;
        }
        return true;
    }

    int hashCode(int n2) {
        int n3 = Math.min(n2, this.transitions.length);
        Object[] objectArray = new ZonalTransition[n3];
        System.arraycopy(this.transitions, 0, objectArray, 0, n3);
        return Arrays.hashCode(objectArray);
    }

    void writeTransitions(ObjectOutput objectOutput) throws IOException {
        this.writeTransitions(this.transitions.length, objectOutput);
    }

    void writeTransitions(int n2, ObjectOutput objectOutput) throws IOException {
        SPX.writeTransitions(this.transitions, n2, objectOutput);
    }

    private static void checkSanity(ZonalTransition[] zonalTransitionArray, List<ZonalTransition> list) {
        int n2 = zonalTransitionArray[0].getTotalOffset();
        for (int i2 = 1; i2 < zonalTransitionArray.length; ++i2) {
            if (n2 != zonalTransitionArray[i2].getPreviousOffset()) {
                Moment moment = Moment.of(zonalTransitionArray[i2].getPosixTime(), TimeScale.POSIX);
                throw new IllegalArgumentException("Model inconsistency detected at: " + moment + " (" + zonalTransitionArray[i2].getPosixTime() + ")  in transitions: " + list);
            }
            n2 = zonalTransitionArray[i2].getTotalOffset();
        }
    }

    private static List<ZonalTransition> getTransitions(ZonalTransition[] zonalTransitionArray, long l2, long l3) {
        if (l2 > l3) {
            throw new IllegalArgumentException("Start after end.");
        }
        int n2 = ArrayTransitionModel.search(l2, zonalTransitionArray);
        int n3 = ArrayTransitionModel.search(l3, zonalTransitionArray);
        if (n3 == 0) {
            return Collections.emptyList();
        }
        if (n2 > 0 && zonalTransitionArray[n2 - 1].getPosixTime() == l2) {
            --n2;
        }
        if (zonalTransitionArray[--n3].getPosixTime() == l3) {
            --n3;
        }
        if (n2 > n3) {
            return Collections.emptyList();
        }
        ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>(n3 - n2 + 1);
        for (int i2 = n2; i2 <= n3; ++i2) {
            arrayList.add(zonalTransitionArray[i2]);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static int search(long l2, ZonalTransition[] zonalTransitionArray) {
        int n2 = 0;
        int n3 = zonalTransitionArray.length - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            if (zonalTransitionArray[n4].getPosixTime() <= l2) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    private static int searchLocal(long l2, ZonalTransition[] zonalTransitionArray) {
        int n2 = 0;
        int n3 = zonalTransitionArray.length - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            ZonalTransition zonalTransition = zonalTransitionArray[n4];
            int n5 = Math.max(zonalTransition.getTotalOffset(), zonalTransition.getPreviousOffset());
            if (zonalTransition.getPosixTime() + (long)n5 <= l2) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4 - 1;
        }
        return n2;
    }

    private Object writeReplace() {
        return new SPX(this, 126);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

