/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.SPX;
import net.time4j.tz.SingleOffsetTimezone;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class ZonalOffset
implements Comparable<ZonalOffset>,
TZID,
Serializable {
    private static final ConcurrentMap<Integer, ZonalOffset> OFFSET_CACHE = new ConcurrentHashMap<Integer, ZonalOffset>();
    private static final BigDecimal DECIMAL_60 = new BigDecimal(60);
    private static final BigDecimal DECIMAL_3600 = new BigDecimal(3600);
    private static final BigDecimal DECIMAL_NEG_180 = new BigDecimal(-180);
    private static final BigDecimal DECIMAL_POS_180 = new BigDecimal(180);
    private static final BigDecimal DECIMAL_240 = new BigDecimal(240);
    private static final BigDecimal MRD = new BigDecimal(1000000000);
    public static final ZonalOffset UTC = new ZonalOffset(0, 0);
    private static final long serialVersionUID = -1410512619471503090L;
    private final transient int total;
    private final transient int fraction;
    private final transient String name;

    private ZonalOffset(int n2, int n3) {
        if (n3 == 0) {
            if (n2 < -64800 || n2 > 64800) {
                throw new IllegalArgumentException("Total seconds out of range: " + n2);
            }
        } else {
            if (Math.abs(n3) > 999999999) {
                throw new IllegalArgumentException("Fraction out of range: " + n3);
            }
            if (n2 <= -43200 || n2 >= 43200) {
                throw new IllegalArgumentException("Total seconds out of range while fraction is non-zero: " + n2);
            }
            if (n2 < 0 && n3 > 0 || n2 > 0 && n3 < 0) {
                throw new IllegalArgumentException("Different signs: offset=" + n2 + ", fraction=" + n3);
            }
        }
        boolean bl2 = n2 < 0 || n3 < 0;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(bl2 ? (char)'-' : '+');
        int n4 = Math.abs(n2);
        int n5 = n4 / 3600;
        int n6 = n4 / 60 % 60;
        int n7 = n4 % 60;
        if (n5 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n5);
        stringBuilder.append(':');
        if (n6 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n6);
        if (n7 != 0 || n3 != 0) {
            stringBuilder.append(':');
            if (n7 < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n7);
            if (n3 != 0) {
                stringBuilder.append('.');
                String string = String.valueOf(Math.abs(n3));
                int n8 = 9 - string.length();
                for (int i2 = 0; i2 < n8; ++i2) {
                    stringBuilder.append('0');
                }
                stringBuilder.append(string);
            }
        }
        this.name = stringBuilder.toString();
        this.total = n2;
        this.fraction = n3;
    }

    public static ZonalOffset atLongitude(BigDecimal bigDecimal) {
        if (bigDecimal.compareTo(DECIMAL_POS_180) > 0 || bigDecimal.compareTo(DECIMAL_NEG_180) < 0) {
            throw new IllegalArgumentException("Out of range: " + bigDecimal);
        }
        BigDecimal bigDecimal2 = bigDecimal.multiply(DECIMAL_240);
        BigDecimal bigDecimal3 = bigDecimal2.setScale(0, RoundingMode.DOWN);
        BigDecimal bigDecimal4 = bigDecimal2.subtract(bigDecimal3);
        BigDecimal bigDecimal5 = bigDecimal4.setScale(9, RoundingMode.HALF_UP).multiply(MRD);
        int n2 = bigDecimal3.intValueExact();
        int n3 = bigDecimal5.intValueExact();
        if (n3 == 0) {
            return ZonalOffset.ofTotalSeconds(n2);
        }
        if (n3 == 1000000000) {
            return ZonalOffset.ofTotalSeconds(n2 + 1);
        }
        if (n3 == -1000000000) {
            return ZonalOffset.ofTotalSeconds(n2 - 1);
        }
        return new ZonalOffset(n2, n3);
    }

    public static ZonalOffset atLongitude(OffsetSign offsetSign, int n2, int n3, double d2) {
        BigDecimal bigDecimal;
        if (offsetSign == null) {
            throw new NullPointerException("Missing sign.");
        }
        if (n2 < 0 || n2 > 180) {
            throw new IllegalArgumentException("Degrees of longitude out of range (0 <= degrees <= 180).");
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("Arc minute out of range (0 <= arcMinutes <= 59).");
        }
        if (Double.compare(d2, 0.0) < 0 || Double.compare(d2, 60.0) >= 0) {
            throw new IllegalArgumentException("Arc second out of range (0.0 <= arcSeconds < 60.0).");
        }
        BigDecimal bigDecimal2 = BigDecimal.valueOf(n2);
        if (n3 != 0) {
            bigDecimal = BigDecimal.valueOf(n3).setScale(15, RoundingMode.UNNECESSARY).divide(DECIMAL_60, RoundingMode.HALF_UP);
            bigDecimal2 = bigDecimal2.add(bigDecimal);
        }
        if (d2 != 0.0) {
            bigDecimal = BigDecimal.valueOf(d2).setScale(15, RoundingMode.FLOOR).divide(DECIMAL_3600, RoundingMode.HALF_UP);
            bigDecimal2 = bigDecimal2.add(bigDecimal);
        }
        if (offsetSign == OffsetSign.BEHIND_UTC) {
            bigDecimal2 = bigDecimal2.negate();
        }
        return ZonalOffset.atLongitude(bigDecimal2);
    }

    public static ZonalOffset ofHours(OffsetSign offsetSign, int n2) {
        return ZonalOffset.ofHoursMinutes(offsetSign, n2, 0);
    }

    public static ZonalOffset ofHoursMinutes(OffsetSign offsetSign, int n2, int n3) {
        if (offsetSign == null) {
            throw new NullPointerException("Missing sign.");
        }
        if (n2 < 0 || n2 > 18) {
            throw new IllegalArgumentException("Hour part out of range (0 <= hours <= 18) in: " + ZonalOffset.format(n2, n3));
        }
        if (n3 < 0 || n3 > 59) {
            throw new IllegalArgumentException("Minute part out of range (0 <= minutes <= 59) in: " + ZonalOffset.format(n2, n3));
        }
        if (n2 == 18 && n3 != 0) {
            throw new IllegalArgumentException("Time zone offset out of range (-18:00:00 <= offset <= 18:00:00) in: " + ZonalOffset.format(n2, n3));
        }
        int n4 = n2 * 3600 + n3 * 60;
        if (offsetSign == OffsetSign.BEHIND_UTC) {
            n4 = -n4;
        }
        return ZonalOffset.ofTotalSeconds(n4);
    }

    public static ZonalOffset ofTotalSeconds(int n2) {
        return ZonalOffset.ofTotalSeconds(n2, 0);
    }

    public static ZonalOffset ofTotalSeconds(int n2, int n3) {
        if (n3 != 0) {
            return new ZonalOffset(n2, n3);
        }
        if (n2 == 0) {
            return UTC;
        }
        if (n2 % 900 == 0) {
            Integer n4 = n2;
            ZonalOffset zonalOffset = (ZonalOffset)OFFSET_CACHE.get(n4);
            if (zonalOffset == null) {
                zonalOffset = new ZonalOffset(n2, 0);
                OFFSET_CACHE.putIfAbsent(n4, zonalOffset);
                zonalOffset = (ZonalOffset)OFFSET_CACHE.get(n4);
            }
            return zonalOffset;
        }
        return new ZonalOffset(n2, 0);
    }

    public OffsetSign getSign() {
        return this.total < 0 || this.fraction < 0 ? OffsetSign.BEHIND_UTC : OffsetSign.AHEAD_OF_UTC;
    }

    public int getAbsoluteHours() {
        return Math.abs(this.total) / 3600;
    }

    public int getAbsoluteMinutes() {
        return Math.abs(this.total) / 60 % 60;
    }

    public int getAbsoluteSeconds() {
        return Math.abs(this.total) % 60;
    }

    public int getIntegralAmount() {
        return this.total;
    }

    public int getFractionalAmount() {
        return this.fraction;
    }

    @Override
    public int compareTo(ZonalOffset zonalOffset) {
        if (this.total < zonalOffset.total) {
            return -1;
        }
        if (this.total > zonalOffset.total) {
            return 1;
        }
        int n2 = this.fraction - zonalOffset.fraction;
        return n2 < 0 ? -1 : (n2 == 0 ? 0 : 1);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonalOffset) {
            ZonalOffset zonalOffset = (ZonalOffset)object;
            return this.total == zonalOffset.total && this.fraction == zonalOffset.fraction;
        }
        return false;
    }

    public int hashCode() {
        return ~this.total + this.fraction % 64000;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String canonical() {
        if (this.total == 0 && this.fraction == 0) {
            return "Z";
        }
        return "UTC" + this.name;
    }

    public static ZonalOffset parse(String string) {
        return ZonalOffset.parse(string, true);
    }

    public String getStdFormatPattern(Locale locale) {
        return Timezone.NAME_PROVIDER.getStdFormatPattern(this.total == 0 && this.fraction == 0, locale);
    }

    static ZonalOffset parse(String string, boolean bl2) {
        if (string.equals("Z")) {
            return UTC;
        }
        int n2 = string.length();
        String string2 = string;
        if (n2 >= 3) {
            if (string2.startsWith("UTC")) {
                string2 = string.substring(3);
                n2 -= 3;
            } else if (string2.startsWith("GMT")) {
                if (bl2) {
                    throw new IllegalArgumentException("Use UTC-prefix for canonical offset instead: " + string);
                }
                return null;
            }
        }
        if (n2 >= 2) {
            OffsetSign offsetSign = null;
            if (string2.charAt(0) == '-') {
                offsetSign = OffsetSign.BEHIND_UTC;
            } else if (string2.charAt(0) == '+') {
                offsetSign = OffsetSign.AHEAD_OF_UTC;
            }
            int n3 = ZonalOffset.parse(string2, 1, 2);
            if (n3 >= 0) {
                if (n2 <= 3) {
                    return ZonalOffset.ofHours(offsetSign, n3);
                }
                int n4 = 4;
                if (string2.charAt(2) == ':') {
                    n4 = 3;
                }
                int n5 = ZonalOffset.parse(string2, n4, 2);
                if (string2.charAt(n4 - 1) == ':' && n5 >= 0) {
                    int n6;
                    if (n2 == n4 + 2) {
                        return ZonalOffset.ofHoursMinutes(offsetSign, n3, n5);
                    }
                    if (n2 >= n4 + 5 && string2.charAt(n4 + 2) == ':' && (n6 = ZonalOffset.parse(string2, n4 + 3, 2)) >= 0) {
                        int n7;
                        int n8 = n3 * 3600 + n5 * 60 + n6;
                        if (offsetSign == OffsetSign.BEHIND_UTC) {
                            n8 = -n8;
                        }
                        if (n2 == n4 + 5) {
                            return ZonalOffset.ofTotalSeconds(n8);
                        }
                        if (n2 == n4 + 15 && string2.charAt(n4 + 5) == '.' && (n7 = ZonalOffset.parse(string2, n4 + 6, 9)) >= 0) {
                            if (offsetSign == OffsetSign.BEHIND_UTC) {
                                n7 = -n7;
                            }
                            return ZonalOffset.ofTotalSeconds(n8, n7);
                        }
                    }
                }
            }
        }
        if (bl2) {
            throw new IllegalArgumentException("No canonical zonal offset: " + string);
        }
        return null;
    }

    SingleOffsetTimezone getModel() {
        return SingleOffsetTimezone.of(this);
    }

    private static int parse(String string, int n2, int n3) {
        char c2;
        int n4 = -1;
        int n5 = Math.min(string.length() - n2, n3);
        for (int i2 = 0; i2 < n5 && (c2 = string.charAt(n2 + i2)) >= '0' && c2 <= '9'; ++i2) {
            n4 = n4 == -1 ? c2 - 48 : n4 * 10 + (c2 - 48);
        }
        return n4;
    }

    private static String format(int n2, int n3) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[hours=");
        stringBuilder.append(n2);
        stringBuilder.append(",minutes=");
        stringBuilder.append(n3);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private Object writeReplace() {
        return new SPX(this, 15);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        OFFSET_CACHE.put(0, UTC);
    }
}

