/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.Duration;
import net.time4j.IsoDateUnit;
import net.time4j.PrettyTime;
import net.time4j.base.MathUtils;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.TextWidth;

public abstract class SingleUnitTimeSpan<U extends IsoDateUnit, D extends SingleUnitTimeSpan<U, D>>
implements TimeSpan<U>,
Comparable<D>,
Serializable {
    private final int amount;
    private final U unit;

    SingleUnitTimeSpan(int n2, U u2) {
        this.amount = n2;
        this.unit = u2;
        this.checkConsistency(u2);
    }

    public int getAmount() {
        return this.amount;
    }

    public U getUnit() {
        return this.unit;
    }

    @Override
    public int compareTo(D d2) {
        if (this.unit.equals(((SingleUnitTimeSpan)d2).getUnit())) {
            return this.amount < ((SingleUnitTimeSpan)d2).getAmount() ? -1 : (this.amount == ((SingleUnitTimeSpan)d2).getAmount() ? 0 : 1);
        }
        throw new ClassCastException("Durations with different units are not comparable.");
    }

    @Override
    public List<TimeSpan.Item<U>> getTotalLength() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        long l2 = this.amount;
        TimeSpan.Item<U> item = TimeSpan.Item.of(Math.abs(l2), this.unit);
        return Collections.singletonList(item);
    }

    @Override
    public boolean contains(IsoDateUnit isoDateUnit) {
        return this.unit.equals(isoDateUnit) && this.amount != 0;
    }

    @Override
    public long getPartialAmount(IsoDateUnit isoDateUnit) {
        return this.unit.equals(isoDateUnit) ? this.amount : 0;
    }

    @Override
    public boolean isNegative() {
        return this.amount < 0;
    }

    @Override
    public boolean isPositive() {
        return this.amount > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.amount == 0;
    }

    @Override
    public <T extends TimePoint<? super U, T>> T addTo(T t2) {
        return t2.plus(this.amount, this.unit);
    }

    @Override
    public <T extends TimePoint<? super U, T>> T subtractFrom(T t2) {
        return t2.minus(this.amount, this.unit);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SingleUnitTimeSpan) {
            SingleUnitTimeSpan singleUnitTimeSpan = (SingleUnitTimeSpan)SingleUnitTimeSpan.class.cast(object);
            return this.amount == singleUnitTimeSpan.amount && this.unit.equals(singleUnitTimeSpan.unit);
        }
        return false;
    }

    public int hashCode() {
        return this.amount ^ this.unit.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.amount < 0) {
            stringBuilder.append('-');
        }
        stringBuilder.append('P');
        long l2 = this.amount;
        stringBuilder.append(Math.abs(l2));
        stringBuilder.append(this.unit.getSymbol());
        return stringBuilder.toString();
    }

    public String toString(Locale locale, TextWidth textWidth) {
        return PrettyTime.of(locale).print(this.toStdDuration(), textWidth);
    }

    public D abs() {
        long l2 = this.amount;
        return this.with(MathUtils.safeCast(Math.abs(l2)));
    }

    public D inverse() {
        return this.with(MathUtils.safeNegate(this.amount));
    }

    public D plus(int n2) {
        if (n2 == 0) {
            return this.self();
        }
        long l2 = this.amount;
        return this.with(MathUtils.safeCast(l2 + (long)n2));
    }

    public D plus(D d2) {
        if (((SingleUnitTimeSpan)d2).isEmpty()) {
            return this.self();
        }
        long l2 = this.amount;
        return this.with(MathUtils.safeCast(l2 + (long)((SingleUnitTimeSpan)d2).getAmount()));
    }

    public D minus(int n2) {
        if (n2 == 0) {
            return this.self();
        }
        long l2 = this.amount;
        return this.with(MathUtils.safeCast(l2 - (long)n2));
    }

    public D minus(D d2) {
        if (((SingleUnitTimeSpan)d2).isEmpty()) {
            return this.self();
        }
        long l2 = this.amount;
        return this.with(MathUtils.safeCast(l2 - (long)((SingleUnitTimeSpan)d2).getAmount()));
    }

    public D multipliedBy(int n2) {
        switch (n2) {
            case -1: {
                return this.inverse();
            }
            case 1: {
                return this.self();
            }
        }
        return this.with(MathUtils.safeMultiply(this.amount, n2));
    }

    public Duration<U> toStdDuration() {
        return Duration.of(this.amount, this.unit);
    }

    abstract D with(int var1);

    abstract D self();

    static int parsePeriod(String string, char c2) throws ParseException {
        char c3;
        if (string.isEmpty()) {
            throw new ParseException("Empty period.", 0);
        }
        boolean bl2 = false;
        int n2 = 0;
        int n3 = string.length();
        if (string.charAt(0) == '-') {
            ++n2;
            bl2 = true;
        }
        if (n2 < n3 && string.charAt(n2) != 'P') {
            throw new ParseException("Missing P-literal: " + string, n2);
        }
        long l2 = 0L;
        int n4 = ++n2;
        int n5 = Math.min(n3, 10);
        for (int i2 = n2; i2 < n5 && (c3 = string.charAt(i2)) >= '0' && c3 <= '9'; ++i2) {
            int n6 = c3 - 48;
            l2 = l2 * 10L + (long)n6;
            ++n2;
        }
        if (n2 == n4) {
            throw new ParseException("Missing digits: " + string, n2);
        }
        if (n3 == n2 + 1 && string.charAt(n2) == c2) {
            ++n2;
            try {
                if (bl2) {
                    l2 = MathUtils.safeNegate(l2);
                }
                return MathUtils.safeCast(l2);
            }
            catch (ArithmeticException arithmeticException) {
                throw new ParseException(arithmeticException.getMessage(), n2);
            }
        }
        throw new ParseException("Unparseable format: " + string, n2);
    }

    final void readObject(ObjectInputStream objectInputStream) throws IOException {
        this.checkConsistency(this.unit);
    }

    void checkConsistency(U u2) {
        if (u2 == null) {
            throw new NullPointerException("Missing unit.");
        }
    }
}

