/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.text.ParseException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoDateUnit;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.ZonalDateTime;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.range.Boundary;
import net.time4j.range.DateInterval;
import net.time4j.range.DateIntervalFactory;
import net.time4j.range.MomentInterval;
import net.time4j.range.MomentIntervalFactory;
import net.time4j.range.TimestampInterval;
import net.time4j.range.TimestampIntervalFactory;
import net.time4j.tz.ZonalOffset;

public class IsoRecurrence<I>
implements Iterable<I> {
    private static final int INFINITE = -1;
    private static final int TYPE_START_END = 0;
    private static final int TYPE_START_DURATION = 1;
    private static final int TYPE_DURATION_END = 2;
    private final int count;
    private final int type;

    private IsoRecurrence(int n2, int n3) {
        this.count = n2;
        this.type = n3;
    }

    public static IsoRecurrence<DateInterval> of(int n2, PlainDate plainDate, Duration<? extends IsoDateUnit> duration) {
        IsoRecurrence.check(n2);
        if (plainDate == null) {
            throw new NullPointerException("Missing start of recurrent interval.");
        }
        return new RecurrentDateIntervals(n2, 1, plainDate, duration);
    }

    public static IsoRecurrence<DateInterval> of(int n2, Duration<? extends IsoDateUnit> duration, PlainDate plainDate) {
        IsoRecurrence.check(n2);
        if (plainDate == null) {
            throw new NullPointerException("Missing end of recurrent interval.");
        }
        return new RecurrentDateIntervals(n2, 2, plainDate, duration);
    }

    public static IsoRecurrence<DateInterval> of(int n2, PlainDate plainDate, PlainDate plainDate2) {
        IsoRecurrence.check(n2);
        if (!plainDate2.isAfter(plainDate)) {
            throw new IllegalArgumentException("End is not after start.");
        }
        return new RecurrentDateIntervals(n2, 0, plainDate, Duration.inYearsMonthsDays().between(plainDate, plainDate2.plus(1L, CalendarUnit.DAYS)));
    }

    public static IsoRecurrence<TimestampInterval> of(int n2, PlainTimestamp plainTimestamp, Duration<?> duration) {
        IsoRecurrence.check(n2);
        if (plainTimestamp == null) {
            throw new NullPointerException("Missing start of recurrent interval.");
        }
        return new RecurrentTimestampIntervals(n2, 1, plainTimestamp, duration);
    }

    public static IsoRecurrence<TimestampInterval> of(int n2, Duration<?> duration, PlainTimestamp plainTimestamp) {
        IsoRecurrence.check(n2);
        if (plainTimestamp == null) {
            throw new NullPointerException("Missing end of recurrent interval.");
        }
        return new RecurrentTimestampIntervals(n2, 2, plainTimestamp, duration);
    }

    public static IsoRecurrence<TimestampInterval> of(int n2, PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
        IsoRecurrence.check(n2);
        if (!plainTimestamp2.isAfter(plainTimestamp)) {
            throw new IllegalArgumentException("End is not after start.");
        }
        return new RecurrentTimestampIntervals(n2, 0, plainTimestamp, (Duration)Duration.in((IsoUnit[])new Enum[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS}).between(plainTimestamp, plainTimestamp2));
    }

    public static IsoRecurrence<MomentInterval> of(int n2, Moment moment, Duration<?> duration, ZonalOffset zonalOffset) {
        IsoRecurrence.check(n2);
        return new RecurrentMomentIntervals(n2, 1, moment.toZonalTimestamp(zonalOffset), zonalOffset, duration);
    }

    public static IsoRecurrence<MomentInterval> of(int n2, Duration<?> duration, Moment moment, ZonalOffset zonalOffset) {
        IsoRecurrence.check(n2);
        return new RecurrentMomentIntervals(n2, 2, moment.toZonalTimestamp(zonalOffset), zonalOffset, duration);
    }

    public static IsoRecurrence<MomentInterval> of(int n2, Moment moment, Moment moment2, ZonalOffset zonalOffset) {
        IsoRecurrence.check(n2);
        if (!moment2.isAfter(moment)) {
            throw new IllegalArgumentException("End is not after start.");
        }
        PlainTimestamp plainTimestamp = moment.toZonalTimestamp(zonalOffset);
        PlainTimestamp plainTimestamp2 = moment2.toZonalTimestamp(zonalOffset);
        return new RecurrentMomentIntervals(n2, 0, plainTimestamp, zonalOffset, (Duration)Duration.in((IsoUnit[])new Enum[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS, ClockUnit.NANOS}).between(plainTimestamp, plainTimestamp2));
    }

    public int getCount() {
        return this.count;
    }

    public IsoRecurrence<I> withCount(int n2) {
        if (n2 == this.count) {
            return this;
        }
        IsoRecurrence.check(n2);
        return this.copyWithCount(n2);
    }

    public IsoRecurrence<I> withInfiniteCount() {
        if (this.count == -1) {
            return this;
        }
        return this.copyWithCount(-1);
    }

    public boolean isBackwards() {
        return this.type == 2;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean isInfinite() {
        return this.count == -1;
    }

    public static IsoRecurrence<DateInterval> parseDateIntervals(String string) throws ParseException {
        IsoRecurrence<DateInterval> isoRecurrence;
        String[] stringArray = string.split("/");
        int n2 = IsoRecurrence.parseCount(stringArray);
        boolean bl2 = false;
        if (n2 == -1) {
            n2 = 0;
            bl2 = true;
        }
        if (stringArray[2].charAt(0) == 'P') {
            PlainDate plainDate = Iso8601Format.parseDate(stringArray[1]);
            Duration<CalendarUnit> duration = Duration.parseCalendarPeriod(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n2, plainDate, duration);
        } else if (stringArray[1].charAt(0) == 'P') {
            Duration<CalendarUnit> duration = Duration.parseCalendarPeriod(stringArray[1]);
            PlainDate plainDate = Iso8601Format.parseDate(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n2, duration, plainDate);
        } else {
            DateInterval dateInterval = DateInterval.parseISO(string.substring(IsoRecurrence.getFirstSlash(string) + 1));
            PlainDate plainDate = (PlainDate)dateInterval.getStart().getTemporal();
            PlainDate plainDate2 = (PlainDate)dateInterval.getEnd().getTemporal();
            isoRecurrence = IsoRecurrence.of(n2, plainDate, plainDate2);
        }
        if (bl2) {
            isoRecurrence = isoRecurrence.withInfiniteCount();
        }
        return isoRecurrence;
    }

    public static IsoRecurrence<TimestampInterval> parseTimestampIntervals(String string) throws ParseException {
        IsoRecurrence<TimestampInterval> isoRecurrence;
        String[] stringArray = string.split("/");
        int n2 = IsoRecurrence.parseCount(stringArray);
        boolean bl2 = false;
        if (n2 == -1) {
            n2 = 0;
            bl2 = true;
        }
        if (stringArray[2].charAt(0) == 'P') {
            boolean bl3 = IsoRecurrence.isExtendedFormat(stringArray[1]);
            PlainTimestamp plainTimestamp = IsoRecurrence.timestampFormatter(bl3).parse(stringArray[1]);
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n2, plainTimestamp, duration);
        } else if (stringArray[1].charAt(0) == 'P') {
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[1]);
            boolean bl4 = IsoRecurrence.isExtendedFormat(stringArray[2]);
            PlainTimestamp plainTimestamp = IsoRecurrence.timestampFormatter(bl4).parse(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n2, duration, plainTimestamp);
        } else {
            TimestampInterval timestampInterval = TimestampInterval.parseISO(string.substring(IsoRecurrence.getFirstSlash(string) + 1));
            PlainTimestamp plainTimestamp = (PlainTimestamp)timestampInterval.getStart().getTemporal();
            PlainTimestamp plainTimestamp2 = (PlainTimestamp)timestampInterval.getEnd().getTemporal();
            isoRecurrence = IsoRecurrence.of(n2, plainTimestamp, plainTimestamp2);
        }
        if (bl2) {
            isoRecurrence = isoRecurrence.withInfiniteCount();
        }
        return isoRecurrence;
    }

    public static IsoRecurrence<MomentInterval> parseMomentIntervals(String string) throws ParseException {
        IsoRecurrence<MomentInterval> isoRecurrence;
        String[] stringArray = string.split("/");
        int n2 = IsoRecurrence.parseCount(stringArray);
        boolean bl2 = false;
        if (n2 == -1) {
            n2 = 0;
            bl2 = true;
        }
        if (stringArray[2].charAt(0) == 'P') {
            boolean bl3 = IsoRecurrence.isExtendedFormat(stringArray[1]);
            ZonalDateTime zonalDateTime = ZonalDateTime.parse(stringArray[1], IsoRecurrence.momentFormatter(bl3));
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[2]);
            isoRecurrence = IsoRecurrence.of(n2, zonalDateTime.toMoment(), duration, zonalDateTime.getOffset());
        } else if (stringArray[1].charAt(0) == 'P') {
            Duration<IsoUnit> duration = Duration.parsePeriod(stringArray[1]);
            boolean bl4 = IsoRecurrence.isExtendedFormat(stringArray[2]);
            ZonalDateTime zonalDateTime = ZonalDateTime.parse(stringArray[2], IsoRecurrence.momentFormatter(bl4));
            isoRecurrence = IsoRecurrence.of(n2, duration, zonalDateTime.toMoment(), zonalDateTime.getOffset());
        } else {
            String string2 = string.substring(IsoRecurrence.getFirstSlash(string) + 1);
            MomentInterval momentInterval = MomentInterval.parseISO(string2);
            Moment moment = (Moment)momentInterval.getStart().getTemporal();
            Moment moment2 = (Moment)momentInterval.getEnd().getTemporal();
            ZonalOffset zonalOffset = null;
            int n3 = -1;
            int n4 = string2.length();
            for (int i2 = 1; i2 < n4; ++i2) {
                char c2 = string2.charAt(i2);
                if (c2 == 'Z') {
                    zonalOffset = ZonalOffset.UTC;
                    break;
                }
                if (c2 == '-' || c2 == '+') {
                    n3 = i2;
                    continue;
                }
                if (c2 != '/') continue;
                if ((string2 = string2.substring(n3, i2)).charAt(3) != ':') {
                    string2 = string2.substring(0, 3) + ":" + string2.substring(3);
                }
                zonalOffset = ZonalOffset.parse(string2);
                break;
            }
            isoRecurrence = IsoRecurrence.of(n2, moment, moment2, zonalOffset);
        }
        if (bl2) {
            isoRecurrence = isoRecurrence.withInfiniteCount();
        }
        return isoRecurrence;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            IsoRecurrence isoRecurrence = (IsoRecurrence)IsoRecurrence.class.cast(object);
            return this.count == isoRecurrence.count && this.type == isoRecurrence.type;
        }
        return false;
    }

    public int hashCode() {
        return this.count;
    }

    public String toString() {
        throw new AbstractMethodError();
    }

    @Override
    public Iterator<I> iterator() {
        throw new AbstractMethodError();
    }

    public Stream<I> intervalStream() {
        long l2 = this.isInfinite() ? Long.MAX_VALUE : (long)this.getCount();
        int n2 = 17745;
        Spliterator<I> spliterator = Spliterators.spliterator(this.iterator(), l2, n2);
        return StreamSupport.stream(spliterator, false);
    }

    IsoRecurrence<I> copyWithCount(int n2) {
        throw new AbstractMethodError();
    }

    int getType() {
        return this.type;
    }

    private static void check(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Count of recurrent intervals must be postive or zero: " + n2);
        }
    }

    private static int parseCount(String[] stringArray) throws ParseException {
        if (stringArray.length != 3) {
            throw new ParseException("Recurrent interval format must contain exactly 3 chars '/'.", 0);
        }
        if (stringArray[0].isEmpty() || stringArray[0].charAt(0) != 'R') {
            throw new ParseException("Recurrent interval format must start with char 'R'.", 0);
        }
        int n2 = -1;
        for (int i2 = 1; i2 < stringArray[0].length(); ++i2) {
            int n3;
            if (i2 == 1) {
                n2 = 0;
            }
            if ((n3 = stringArray[0].charAt(i2) - 48) < 0 || n3 > 9) {
                throw new ParseException("Digit 0-9 is missing.", i2);
            }
            n2 = n2 * 10 + n3;
        }
        return n2;
    }

    private static boolean isExtendedFormat(String string) {
        char c2;
        int n2 = string.length();
        for (int i2 = 1; i2 < n2 && (c2 = string.charAt(i2)) != 'T'; ++i2) {
            if (c2 != '-') continue;
            return true;
        }
        return false;
    }

    private static int getFirstSlash(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != '/') continue;
            return i2;
        }
        return -1;
    }

    private static ChronoFormatter<PlainTimestamp> timestampFormatter(boolean bl2) {
        return bl2 ? Iso8601Format.EXTENDED_DATE_TIME : Iso8601Format.BASIC_DATE_TIME;
    }

    private static ChronoFormatter<Moment> momentFormatter(boolean bl2) {
        return bl2 ? Iso8601Format.EXTENDED_DATE_TIME_OFFSET : Iso8601Format.BASIC_DATE_TIME_OFFSET;
    }

    private static class RecurrentDateIntervals
    extends IsoRecurrence<DateInterval> {
        private final PlainDate ref;
        private final Duration<? extends IsoDateUnit> duration;

        private RecurrentDateIntervals(int n2, int n3, PlainDate plainDate, Duration<? extends IsoDateUnit> duration) {
            super(n2, n3);
            this.ref = plainDate;
            this.duration = duration;
            if (!duration.isPositive()) {
                throw new IllegalArgumentException("Duration must be positive: " + duration);
            }
        }

        @Override
        public Iterator<DateInterval> iterator() {
            return new ReadOnlyIterator<DateInterval, RecurrentDateIntervals>(this){
                private PlainDate current;
                {
                    super(recurrentDateIntervals2);
                    this.current = ref;
                }

                @Override
                protected DateInterval nextInterval() {
                    Boundary<PlainDate> boundary;
                    Boundary<PlainDate> boundary2;
                    PlainDate plainDate;
                    if (this.isBackwards()) {
                        plainDate = (PlainDate)this.current.minus(duration);
                        boundary2 = Boundary.ofClosed(plainDate.plus(1L, CalendarUnit.DAYS));
                        boundary = Boundary.ofClosed(this.current);
                    } else {
                        plainDate = (PlainDate)this.current.plus(duration);
                        boundary2 = Boundary.ofClosed(this.current);
                        boundary = Boundary.ofClosed(plainDate.minus(1L, CalendarUnit.DAYS));
                    }
                    this.current = plainDate;
                    return DateIntervalFactory.INSTANCE.between((Boundary)boundary2, (Boundary)boundary);
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                RecurrentDateIntervals recurrentDateIntervals = (RecurrentDateIntervals)object;
                return this.ref.equals(recurrentDateIntervals.ref) && this.duration.equals(recurrentDateIntervals.duration);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.ref.hashCode() + 37 * this.duration.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('R');
            int n2 = this.getCount();
            if (n2 != -1) {
                stringBuilder.append(this.getCount());
            }
            stringBuilder.append('/');
            switch (this.getType()) {
                case 1: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(this.duration);
                    break;
                }
                case 2: {
                    stringBuilder.append(this.duration);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref);
                    break;
                }
                case 0: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(((PlainDate)this.ref.plus(this.duration)).minus(1L, CalendarUnit.DAYS));
                }
            }
            return stringBuilder.toString();
        }

        @Override
        IsoRecurrence<DateInterval> copyWithCount(int n2) {
            return new RecurrentDateIntervals(n2, this.getType(), this.ref, this.duration);
        }
    }

    private static class RecurrentTimestampIntervals
    extends IsoRecurrence<TimestampInterval> {
        private final PlainTimestamp ref;
        private final Duration<?> duration;

        private RecurrentTimestampIntervals(int n2, int n3, PlainTimestamp plainTimestamp, Duration<?> duration) {
            super(n2, n3);
            this.ref = plainTimestamp;
            this.duration = duration;
            if (!duration.isPositive()) {
                throw new IllegalArgumentException("Duration must be positive: " + duration);
            }
        }

        @Override
        public Iterator<TimestampInterval> iterator() {
            return new ReadOnlyIterator<TimestampInterval, RecurrentTimestampIntervals>(this){
                private PlainTimestamp current;
                {
                    super(recurrentTimestampIntervals2);
                    this.current = ref;
                }

                @Override
                protected TimestampInterval nextInterval() {
                    Boundary<PlainTimestamp> boundary;
                    Boundary<PlainTimestamp> boundary2;
                    PlainTimestamp plainTimestamp;
                    if (this.isBackwards()) {
                        plainTimestamp = (PlainTimestamp)this.current.minus(duration);
                        boundary2 = Boundary.ofClosed(plainTimestamp);
                        boundary = Boundary.ofOpen(this.current);
                    } else {
                        plainTimestamp = (PlainTimestamp)this.current.plus(duration);
                        boundary2 = Boundary.ofClosed(this.current);
                        boundary = Boundary.ofOpen(plainTimestamp);
                    }
                    this.current = plainTimestamp;
                    return TimestampIntervalFactory.INSTANCE.between((Boundary)boundary2, (Boundary)boundary);
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                RecurrentTimestampIntervals recurrentTimestampIntervals = (RecurrentTimestampIntervals)object;
                return this.ref.equals(recurrentTimestampIntervals.ref) && this.duration.equals(recurrentTimestampIntervals.duration);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 31 * this.ref.hashCode() + 37 * this.duration.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('R');
            int n2 = this.getCount();
            if (n2 != -1) {
                stringBuilder.append(this.getCount());
            }
            stringBuilder.append('/');
            switch (this.getType()) {
                case 1: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(this.duration);
                    break;
                }
                case 2: {
                    stringBuilder.append(this.duration);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref);
                    break;
                }
                case 0: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref.plus(this.duration));
                }
            }
            return stringBuilder.toString();
        }

        @Override
        IsoRecurrence<TimestampInterval> copyWithCount(int n2) {
            return new RecurrentTimestampIntervals(n2, this.getType(), this.ref, this.duration);
        }
    }

    private static class RecurrentMomentIntervals
    extends IsoRecurrence<MomentInterval> {
        private final PlainTimestamp ref;
        private final ZonalOffset offset;
        private final Duration<?> duration;

        private RecurrentMomentIntervals(int n2, int n3, PlainTimestamp plainTimestamp, ZonalOffset zonalOffset, Duration<?> duration) {
            super(n2, n3);
            this.ref = plainTimestamp;
            this.offset = zonalOffset;
            this.duration = duration;
            if (!duration.isPositive()) {
                throw new IllegalArgumentException("Duration must be positive: " + duration);
            }
            if (zonalOffset.getIntegralAmount() % 60 != 0 || zonalOffset.getFractionalAmount() != 0) {
                throw new IllegalArgumentException("Offset with seconds is invalid in ISO-8601: " + zonalOffset);
            }
        }

        @Override
        public Iterator<MomentInterval> iterator() {
            return new ReadOnlyIterator<MomentInterval, RecurrentMomentIntervals>(this){
                private PlainTimestamp current;
                private ZonalOffset offset;
                {
                    super(recurrentMomentIntervals2);
                    this.current = ref;
                    this.offset = offset;
                }

                @Override
                protected MomentInterval nextInterval() {
                    Boundary<Moment> boundary;
                    Boundary<Moment> boundary2;
                    PlainTimestamp plainTimestamp;
                    if (this.isBackwards()) {
                        plainTimestamp = (PlainTimestamp)this.current.minus(duration);
                        boundary2 = Boundary.ofClosed(plainTimestamp.at(this.offset));
                        boundary = Boundary.ofOpen(this.current.at(this.offset));
                    } else {
                        plainTimestamp = (PlainTimestamp)this.current.plus(duration);
                        boundary2 = Boundary.ofClosed(this.current.at(this.offset));
                        boundary = Boundary.ofOpen(plainTimestamp.at(this.offset));
                    }
                    this.current = plainTimestamp;
                    return MomentIntervalFactory.INSTANCE.between((Boundary)boundary2, (Boundary)boundary);
                }
            };
        }

        @Override
        public boolean equals(Object object) {
            if (super.equals(object)) {
                RecurrentMomentIntervals recurrentMomentIntervals = (RecurrentMomentIntervals)object;
                return this.ref.equals(recurrentMomentIntervals.ref) && this.duration.equals(recurrentMomentIntervals.duration) && this.offset.equals(recurrentMomentIntervals.offset);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + 7 * this.ref.hashCode() + 31 * this.offset.hashCode() + 37 * this.duration.hashCode();
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('R');
            int n2 = this.getCount();
            if (n2 != -1) {
                stringBuilder.append(this.getCount());
            }
            stringBuilder.append('/');
            switch (this.getType()) {
                case 1: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append(this.getOffsetAsString());
                    stringBuilder.append('/');
                    stringBuilder.append(this.duration);
                    break;
                }
                case 2: {
                    stringBuilder.append(this.duration);
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref);
                    stringBuilder.append(this.getOffsetAsString());
                    break;
                }
                case 0: {
                    stringBuilder.append(this.ref);
                    stringBuilder.append(this.getOffsetAsString());
                    stringBuilder.append('/');
                    stringBuilder.append(this.ref.plus(this.duration));
                    stringBuilder.append(this.getOffsetAsString());
                }
            }
            return stringBuilder.toString();
        }

        @Override
        IsoRecurrence<MomentInterval> copyWithCount(int n2) {
            return new RecurrentMomentIntervals(n2, this.getType(), this.ref, this.offset, this.duration);
        }

        private String getOffsetAsString() {
            if (this.offset.getIntegralAmount() == 0 && this.offset.getFractionalAmount() == 0) {
                return "Z";
            }
            return this.offset.toString();
        }
    }

    private static abstract class ReadOnlyIterator<I, R extends IsoRecurrence<?>>
    implements Iterator<I> {
        private int index = 0;
        private R recurrence;

        ReadOnlyIterator(R r2) {
            this.recurrence = r2;
        }

        @Override
        public final boolean hasNext() {
            int n2 = ((IsoRecurrence)this.recurrence).getCount();
            return n2 == -1 || this.index < n2;
        }

        @Override
        public final I next() {
            int n2 = ((IsoRecurrence)this.recurrence).getCount();
            if (n2 != -1 && this.index >= n2) {
                throw new NoSuchElementException("After end of interval recurrence.");
            }
            I i2 = this.nextInterval();
            ++this.index;
            return i2;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract I nextInterval();
    }
}

