/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Comparator;
import java.util.List;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalCollection;
import net.time4j.range.IntervalComparator;
import net.time4j.range.SPX;
import net.time4j.range.SimpleInterval;

final class GenericWindows<T>
extends IntervalCollection<T> {
    private static final long serialVersionUID = 7068295351485872982L;
    private final transient TimeLine<T> timeLine;

    GenericWindows(TimeLine<T> timeLine, List<ChronoInterval<T>> list) {
        super(list);
        if (timeLine == null) {
            throw new NullPointerException("Missing timeline.");
        }
        this.timeLine = timeLine;
    }

    @Override
    ChronoInterval<T> newInterval(Boundary<T> boundary, Boundary<T> boundary2) {
        SimpleInterval.Factory<T> factory = SimpleInterval.on(this.timeLine);
        if (boundary.isInfinite()) {
            T t2 = boundary2.getTemporal();
            if (t2 != null) {
                if (this.timeLine.isCalendrical()) {
                    if (boundary2.isOpen()) {
                        t2 = this.timeLine.stepBackwards(t2);
                    }
                } else if (boundary2.isClosed()) {
                    t2 = this.timeLine.stepForward(t2);
                }
            }
            if (t2 == null) {
                return new SimpleInterval<T>(boundary, Boundary.infiniteFuture(), this.timeLine);
            }
            return factory.until(t2);
        }
        if (boundary2.isInfinite()) {
            T t3 = boundary.getTemporal();
            if (boundary.isOpen()) {
                t3 = this.timeLine.stepForward(t3);
            }
            return factory.since(t3);
        }
        T t4 = boundary.getTemporal();
        if (boundary.isOpen()) {
            t4 = this.timeLine.stepForward(t4);
        }
        T t5 = boundary2.getTemporal();
        if (this.timeLine.isCalendrical()) {
            if (boundary2.isOpen()) {
                t5 = this.timeLine.stepBackwards(t5);
            }
        } else if (boundary2.isClosed()) {
            t5 = this.timeLine.stepForward(t5);
        }
        return factory.between(t4, t5);
    }

    @Override
    Comparator<ChronoInterval<T>> getComparator() {
        return new IntervalComparator<T>(this.timeLine);
    }

    @Override
    IntervalCollection<T> create(List<ChronoInterval<T>> list) {
        return new GenericWindows<T>(this.timeLine, list);
    }

    @Override
    TimeLine<T> getTimeLine() {
        return this.timeLine;
    }

    private Object writeReplace() {
        return new SPX(this, 44);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

