/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearRule;

public final class NewYearStrategy {
    static final NewYearStrategy DEFAULT = new NewYearStrategy(NewYearRule.BEGIN_OF_JANUARY, Integer.MAX_VALUE);
    private static final Comparator<NewYearStrategy> STD_ORDER = new NYSComparator();
    private final List<NewYearStrategy> strategies;
    private final NewYearRule lastRule;
    private final int lastAnnoDomini;

    NewYearStrategy(NewYearRule newYearRule, int n2) {
        this.strategies = Collections.emptyList();
        this.lastRule = newYearRule;
        this.lastAnnoDomini = n2;
    }

    NewYearStrategy(List<NewYearStrategy> list) {
        Collections.sort(list, STD_ORDER);
        NewYearStrategy newYearStrategy = null;
        Iterator<NewYearStrategy> iterator = list.iterator();
        while (iterator.hasNext()) {
            NewYearStrategy newYearStrategy2 = iterator.next();
            if (newYearStrategy != null && newYearStrategy2.lastAnnoDomini == newYearStrategy.lastAnnoDomini) {
                if (newYearStrategy2.lastRule == newYearStrategy.lastRule) {
                    iterator.remove();
                    continue;
                }
                throw new IllegalArgumentException("Multiple strategies with overlapping validity range: " + list);
            }
            newYearStrategy = newYearStrategy2;
        }
        assert (list.size() >= 2);
        this.strategies = Collections.unmodifiableList(list);
        this.lastRule = NewYearRule.BEGIN_OF_JANUARY;
        this.lastAnnoDomini = Integer.MAX_VALUE;
    }

    public NewYearStrategy and(NewYearStrategy newYearStrategy) {
        ArrayList<NewYearStrategy> arrayList = new ArrayList<NewYearStrategy>();
        arrayList.addAll(this.strategies);
        if (arrayList.isEmpty()) {
            arrayList.add(this);
        }
        if (newYearStrategy.strategies.isEmpty()) {
            arrayList.add(newYearStrategy);
        } else {
            arrayList.addAll(newYearStrategy.strategies);
        }
        return new NewYearStrategy(arrayList);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NewYearStrategy) {
            NewYearStrategy newYearStrategy = (NewYearStrategy)object;
            return this.strategies.equals(newYearStrategy.strategies) && this.lastRule == newYearStrategy.lastRule && this.lastAnnoDomini == newYearStrategy.lastAnnoDomini;
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.strategies.hashCode() + 37 * this.lastRule.hashCode() + this.lastAnnoDomini;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.strategies.isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append((Object)this.lastRule);
            if (this.lastAnnoDomini != Integer.MAX_VALUE) {
                stringBuilder.append("->");
                stringBuilder.append(this.lastAnnoDomini);
            }
        } else {
            boolean bl2 = true;
            for (NewYearStrategy newYearStrategy : this.strategies) {
                if (bl2) {
                    stringBuilder.append('[');
                    bl2 = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append((Object)newYearStrategy.lastRule);
                stringBuilder.append("->");
                stringBuilder.append(newYearStrategy.lastAnnoDomini);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    HistoricDate newYear(HistoricEra historicEra, int n2) {
        return this.rule(historicEra, n2).newYear(historicEra, n2);
    }

    NewYearRule rule(HistoricEra historicEra, int n2) {
        int n3 = historicEra.annoDomini(n2);
        int n4 = Integer.MIN_VALUE;
        NewYearRule newYearRule = null;
        int n5 = this.strategies.size();
        for (int i2 = 0; i2 < n5; ++i2) {
            NewYearStrategy newYearStrategy = this.strategies.get(i2);
            if (n3 >= n4 && n3 < newYearStrategy.lastAnnoDomini) {
                return newYearStrategy.lastRule;
            }
            n4 = newYearStrategy.lastAnnoDomini;
            newYearRule = newYearStrategy.lastRule;
        }
        if (n3 == n4 && historicEra == HistoricEra.BYZANTINE && newYearRule == NewYearRule.BEGIN_OF_SEPTEMBER) {
            return newYearRule;
        }
        return this.lastRule;
    }

    int displayedYear(HistoricDate historicDate) {
        HistoricEra historicEra = historicDate.getEra();
        int n2 = historicDate.getYearOfEra();
        int n3 = historicEra.annoDomini(n2);
        int n4 = Integer.MIN_VALUE;
        int n5 = this.strategies.size();
        for (int i2 = 0; i2 < n5; ++i2) {
            NewYearStrategy newYearStrategy = this.strategies.get(i2);
            if (n3 >= n4 && n3 < newYearStrategy.lastAnnoDomini) {
                return newYearStrategy.lastRule.displayedYear(this, historicDate);
            }
            n4 = newYearStrategy.lastAnnoDomini;
        }
        return this.lastRule.displayedYear(this, historicDate);
    }

    void writeToStream(DataOutput dataOutput) throws IOException {
        int n2 = this.strategies.size();
        dataOutput.writeInt(n2);
        if (n2 == 0) {
            dataOutput.writeUTF(this.lastRule.name());
            dataOutput.writeInt(this.lastAnnoDomini);
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            NewYearStrategy newYearStrategy = this.strategies.get(i2);
            dataOutput.writeUTF(newYearStrategy.lastRule.name());
            dataOutput.writeInt(newYearStrategy.lastAnnoDomini);
        }
    }

    static NewYearStrategy readFromStream(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        if (n2 == 0) {
            NewYearRule newYearRule = NewYearRule.valueOf(dataInput.readUTF());
            int n3 = dataInput.readInt();
            if (n3 == Integer.MAX_VALUE && newYearRule == NewYearRule.BEGIN_OF_JANUARY) {
                return DEFAULT;
            }
            return new NewYearStrategy(newYearRule, n3);
        }
        ArrayList<NewYearStrategy> arrayList = new ArrayList<NewYearStrategy>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            NewYearRule newYearRule = NewYearRule.valueOf(dataInput.readUTF());
            int n4 = dataInput.readInt();
            arrayList.add(new NewYearStrategy(newYearRule, n4));
        }
        return new NewYearStrategy(arrayList);
    }

    private static class NYSComparator
    implements Comparator<NewYearStrategy> {
        private NYSComparator() {
        }

        @Override
        public int compare(NewYearStrategy newYearStrategy, NewYearStrategy newYearStrategy2) {
            return newYearStrategy.lastAnnoDomini < newYearStrategy2.lastAnnoDomini ? -1 : (newYearStrategy.lastAnnoDomini > newYearStrategy2.lastAnnoDomini ? 1 : 0);
        }
    }
}

