/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearRule;
import net.time4j.history.NewYearStrategy;
import net.time4j.history.YearDefinition;

public final class HistoricDate
implements Comparable<HistoricDate> {
    private final HistoricEra era;
    private final int yearOfEra;
    private final int month;
    private final int dom;

    HistoricDate(HistoricEra historicEra, int n2, int n3, int n4) {
        this.era = historicEra;
        this.yearOfEra = n2;
        this.month = n3;
        this.dom = n4;
    }

    public static HistoricDate of(HistoricEra historicEra, int n2, int n3, int n4) {
        return HistoricDate.of(historicEra, n2, n3, n4, YearDefinition.DUAL_DATING, NewYearStrategy.DEFAULT);
    }

    public static HistoricDate of(HistoricEra historicEra, int n2, int n3, int n4, YearDefinition yearDefinition, NewYearStrategy newYearStrategy) {
        if (historicEra == null) {
            throw new NullPointerException("Missing historic era.");
        }
        if (n4 < 1 || n4 > 31) {
            throw new IllegalArgumentException("Day of month out of range: " + HistoricDate.toString(historicEra, n2, n3, n4));
        }
        if (n3 < 1 || n3 > 12) {
            throw new IllegalArgumentException("Month out of range: " + HistoricDate.toString(historicEra, n2, n3, n4));
        }
        if (historicEra == HistoricEra.BYZANTINE) {
            if (n2 < 0 || n2 == 0 && n3 < 9) {
                throw new IllegalArgumentException("Before creation of the world: " + HistoricDate.toString(historicEra, n2, n3, n4));
            }
        } else if (n2 < 1) {
            throw new IllegalArgumentException("Year of era must be positive: " + HistoricDate.toString(historicEra, n2, n3, n4));
        }
        if (!yearDefinition.equals((Object)YearDefinition.DUAL_DATING)) {
            NewYearRule newYearRule = newYearStrategy.rule(historicEra, n2);
            n2 = newYearRule.standardYear(yearDefinition == YearDefinition.AFTER_NEW_YEAR, newYearStrategy, historicEra, n2, n3, n4);
        }
        return new HistoricDate(historicEra, n2, n3, n4);
    }

    public HistoricEra getEra() {
        return this.era;
    }

    public int getYearOfEra() {
        return this.yearOfEra;
    }

    public int getYearOfEra(NewYearStrategy newYearStrategy) {
        return newYearStrategy.displayedYear(this);
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dom;
    }

    @Override
    public int compareTo(HistoricDate historicDate) {
        int n2;
        int n3 = this.era.annoDomini(this.yearOfEra);
        if (n3 < (n2 = historicDate.era.annoDomini(historicDate.yearOfEra))) {
            return -1;
        }
        if (n3 > n2) {
            return 1;
        }
        int n4 = this.getMonth() - historicDate.getMonth();
        if (n4 == 0) {
            n4 = this.getDayOfMonth() - historicDate.getDayOfMonth();
        }
        return n4 < 0 ? -1 : (n4 > 0 ? 1 : 0);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HistoricDate) {
            HistoricDate historicDate = (HistoricDate)object;
            return this.era == historicDate.era && this.yearOfEra == historicDate.yearOfEra && this.month == historicDate.month && this.dom == historicDate.dom;
        }
        return false;
    }

    public int hashCode() {
        int n2 = this.yearOfEra * 1000 + this.month * 32 + this.dom;
        return this.era == HistoricEra.AD ? n2 : -n2;
    }

    public String toString() {
        return HistoricDate.toString(this.era, this.yearOfEra, this.month, this.dom);
    }

    private static String toString(HistoricEra historicEra, int n2, int n3, int n4) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(historicEra);
        stringBuilder.append('-');
        String string = String.valueOf(n2);
        for (int i2 = 4 - string.length(); i2 > 0; --i2) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        stringBuilder.append('-');
        if (n3 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n3);
        stringBuilder.append('-');
        if (n4 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n4);
        return stringBuilder.toString();
    }
}

