/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.PlainDate;
import net.time4j.engine.EpochDays;
import net.time4j.history.JulianMath;

public enum Computus {
    WESTERN,
    EASTERN;


    public PlainDate easterSunday(int n2) {
        int n3 = this.marchDay(n2);
        int n4 = 3;
        if (n3 > 31) {
            ++n4;
            n3 -= 31;
        }
        return this == WESTERN && n2 > 1582 ? PlainDate.of(n2, n4, n3) : PlainDate.of(JulianMath.toMJD(n2, n4, n3), EpochDays.MODIFIED_JULIAN_DATE);
    }

    int marchDay(int n2) {
        if (n2 < 532) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        int n3 = n2 / 100;
        int n4 = 15;
        int n5 = 0;
        if (this == WESTERN && n2 > 1582) {
            n4 += (3 * n3 + 3) / 4;
            n4 -= (8 * n3 + 13) / 25;
            n5 = 2 - (3 * n3 + 3) / 4;
        }
        int n6 = n2 % 19;
        int n7 = (19 * n6 + n4) % 30;
        int n8 = n7 / 29 + (n7 / 28 - n7 / 29) * (n6 / 11);
        int n9 = 21 + n7 - n8;
        int n10 = 7 - (n2 + n2 / 4 + n5) % 7;
        int n11 = 7 - (n9 - n10) % 7;
        return n9 + n11;
    }
}

