/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.util.Arrays;
import net.time4j.history.Calculus;
import net.time4j.history.CalendarAlgorithm;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

public final class AncientJulianLeapYears {
    private static final int[] SEQUENCE_SCALIGER = new int[]{42, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9};
    private static final HistoricDate AD8 = HistoricDate.of(HistoricEra.AD, 8, 1, 1);
    private static final HistoricDate BC45 = HistoricDate.of(HistoricEra.BC, 45, 1, 1);
    private static final long MJD_OF_AD8 = -676021L;
    public static final AncientJulianLeapYears SCALIGER = new AncientJulianLeapYears(SEQUENCE_SCALIGER);
    private final int[] leaps;
    private final Calculus calculus;

    private AncientJulianLeapYears(int ... nArray) {
        int n2;
        int[] nArray2 = new int[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray2[n2] = 1 - nArray[n2];
        }
        Arrays.sort(nArray2);
        this.leaps = nArray2;
        if (this.leaps.length == 0) {
            throw new IllegalArgumentException("Missing leap years.");
        }
        if (this.leaps[0] < -44 || this.leaps[this.leaps.length - 1] >= 8) {
            throw new IllegalArgumentException("Out of range: " + Arrays.toString(nArray));
        }
        n2 = nArray2[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray2[i2] == n2) {
                throw new IllegalArgumentException("Contains duplicates: " + Arrays.toString(nArray));
            }
            n2 = nArray2[i2];
        }
        this.calculus = new Calculus(){

            @Override
            public long toMJD(HistoricDate historicDate) {
                int n2;
                if (historicDate.compareTo(AD8) >= 0) {
                    return CalendarAlgorithm.JULIAN.toMJD(historicDate);
                }
                if (historicDate.compareTo(BC45) < 0) {
                    throw new IllegalArgumentException("Not valid before 45 BC: " + historicDate);
                }
                long l2 = -676021L;
                int n3 = this.getProlepticYear(historicDate);
                for (n2 = 7; n2 >= n3; --n2) {
                    if (this.isLeapYear(n2)) {
                        l2 -= 366L;
                        continue;
                    }
                    l2 -= 365L;
                }
                for (n2 = 1; n2 < historicDate.getMonth(); ++n2) {
                    l2 += (long)this.getMaximumDayOfMonth(n3, n2);
                }
                return l2 + (long)historicDate.getDayOfMonth() - 1L;
            }

            @Override
            public HistoricDate fromMJD(long l2) {
                if (l2 >= -676021L) {
                    return CalendarAlgorithm.JULIAN.fromMJD(l2);
                }
                long l3 = -676021L;
                for (int i2 = 7; i2 >= -44; --i2) {
                    l3 = this.isLeapYear(i2) ? (l3 -= 366L) : (l3 -= 365L);
                    if (l3 > l2) continue;
                    for (int i3 = 1; i3 <= 12; ++i3) {
                        int n2 = this.getMaximumDayOfMonth(i2, i3);
                        if (l3 + (long)n2 > l2) {
                            HistoricEra historicEra = i2 <= 0 ? HistoricEra.BC : HistoricEra.AD;
                            int n3 = i2 <= 0 ? 1 - i2 : i2;
                            return HistoricDate.of(historicEra, n3, i3, (int)(l2 - l3 + 1L));
                        }
                        l3 += (long)n2;
                    }
                }
                throw new IllegalArgumentException("Not valid before 45 BC: " + l2);
            }

            @Override
            public boolean isValid(HistoricDate historicDate) {
                int n2;
                if (historicDate != null && (n2 = this.getProlepticYear(historicDate)) >= -44) {
                    if (n2 >= 8) {
                        return CalendarAlgorithm.JULIAN.isValid(historicDate);
                    }
                    return historicDate.getDayOfMonth() <= this.getMaximumDayOfMonth(n2, historicDate.getMonth());
                }
                return false;
            }

            @Override
            public int getMaximumDayOfMonth(HistoricDate historicDate) {
                if (historicDate.compareTo(AD8) >= 0) {
                    return CalendarAlgorithm.JULIAN.getMaximumDayOfMonth(historicDate);
                }
                if (historicDate.compareTo(BC45) < 0) {
                    throw new IllegalArgumentException("Not valid before 45 BC: " + historicDate);
                }
                return this.getMaximumDayOfMonth(this.getProlepticYear(historicDate), historicDate.getMonth());
            }

            private int getMaximumDayOfMonth(int n2, int n3) {
                switch (n3) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 12: {
                        return 31;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        return 30;
                    }
                    case 2: {
                        return this.isLeapYear(n2) ? 29 : 28;
                    }
                }
                throw new IllegalArgumentException("Invalid month: " + n3);
            }

            private int getProlepticYear(HistoricDate historicDate) {
                return historicDate.getEra().annoDomini(historicDate.getYearOfEra());
            }

            private boolean isLeapYear(int n2) {
                return Arrays.binarySearch(AncientJulianLeapYears.this.leaps, n2) >= 0;
            }
        };
    }

    public static AncientJulianLeapYears of(int ... nArray) {
        if (Arrays.equals(nArray, SEQUENCE_SCALIGER)) {
            return SCALIGER;
        }
        return new AncientJulianLeapYears(nArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AncientJulianLeapYears) {
            AncientJulianLeapYears ancientJulianLeapYears = (AncientJulianLeapYears)object;
            return this.leaps == ancientJulianLeapYears.leaps;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.leaps);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.leaps.length; ++i2) {
            int n2;
            if (i2 > 0) {
                stringBuilder.append(", ");
            }
            if ((n2 = 1 - this.leaps[i2]) > 0) {
                stringBuilder.append("BC ");
                stringBuilder.append(n2);
                continue;
            }
            stringBuilder.append("AD ");
            stringBuilder.append(this.leaps[i2]);
        }
        return stringBuilder.toString();
    }

    int[] getPattern() {
        return this.leaps;
    }

    Calculus getCalculus() {
        return this.calculus;
    }
}

