/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.format.expert.TimezoneOffsetProcessor;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

enum TimezoneIDProcessor implements FormatProcessor<TZID>
{
    INSTANCE;


    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl2) throws IOException {
        if (!chronoDisplay.hasTimezone()) {
            throw new IllegalArgumentException("Cannot extract timezone id from: " + chronoDisplay);
        }
        int n2 = -1;
        if (appendable instanceof CharSequence) {
            n2 = ((CharSequence)((Object)appendable)).length();
        }
        String string = chronoDisplay.getTimezone().canonical();
        appendable.append(string);
        int n3 = string.length();
        if (n2 != -1 && n3 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n2, n2 + n3));
        }
        return n3;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl2) {
        String string;
        char c2;
        int n2 = charSequence.length();
        int n3 = parseLog.getPosition();
        int n4 = n3;
        if (n4 >= n2) {
            parseLog.setError(n3, "Missing timezone name.");
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while (n4 < n2 && ((c2 = charSequence.charAt(n4)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' || c2 == '-' || c2 == '_' || c2 == '/')) {
            stringBuilder.append(c2);
            ++n4;
        }
        if (!Character.isLetter(stringBuilder.charAt(stringBuilder.length() - 1))) {
            stringBuilder.deleteCharAt(stringBuilder.length() - 1);
            --n4;
        }
        if ((string = stringBuilder.toString()).isEmpty()) {
            parseLog.setError(n3, "Missing valid timezone id.");
            return;
        }
        if (string.startsWith("Etc/GMT")) {
            parseLog.setError(n3, "Inverse Etc/GMT-Offsets are not supported, use UTC-Offsets instead.");
            return;
        }
        if (string.equals("Z")) {
            parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
            parseLog.setPosition(n4);
            return;
        }
        if (string.equals("UTC") || string.equals("GMT") || string.equals("UT")) {
            char c3;
            if (n2 > n4 && ((c3 = charSequence.charAt(n4)) == '+' || c3 == '-')) {
                parseLog.setPosition(n4);
                TimezoneOffsetProcessor.EXTENDED_LONG_PARSER.parse(charSequence, parseLog, attributeQuery, parsedEntity, bl2);
                return;
            }
            parsedEntity.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
            parseLog.setPosition(n4);
            return;
        }
        List<TZID> list = Timezone.getAvailableIDs("INCLUDE_ALIAS");
        int n5 = 0;
        int n6 = list.size() - 1;
        while (n5 <= n6) {
            int n7 = n5 + n6 >>> 1;
            TZID tZID = list.get(n7);
            int n8 = tZID.canonical().compareTo(string);
            if (n8 < 0) {
                n5 = n7 + 1;
                continue;
            }
            if (n8 > 0) {
                n6 = n7 - 1;
                continue;
            }
            parsedEntity.put(TimezoneElement.TIMEZONE_ID, tZID);
            parseLog.setPosition(n4);
            return;
        }
        parseLog.setError(n3, "Cannot parse to timezone id: " + string);
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_ID;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return INSTANCE;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<TZID> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n2) {
        return INSTANCE;
    }
}

