/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.time4j.engine.AttributeQuery;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;

public final class TextAccessor {
    private static final char PROTECTED_SPACE = '\u00a0';
    private final List<String> textForms;

    TextAccessor(String[] stringArray) {
        this.textForms = Collections.unmodifiableList(Arrays.asList(stringArray));
    }

    public String print(Enum<?> enum_) {
        int n2 = enum_.ordinal();
        if (this.textForms.size() <= n2) {
            return enum_.name();
        }
        return this.textForms.get(n2);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz) {
        return this.parse(charSequence, parsePosition, clazz, true, false, true);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, Leniency leniency) {
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = true;
        if (leniency == Leniency.STRICT) {
            bl2 = false;
            bl4 = false;
        } else if (leniency == Leniency.LAX) {
            bl3 = true;
        }
        return this.parse(charSequence, parsePosition, clazz, bl2, bl3, bl4);
    }

    public <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, AttributeQuery attributeQuery) {
        boolean bl2 = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
        boolean bl3 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
        boolean bl4 = attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, Boolean.TRUE);
        return this.parse(charSequence, parsePosition, clazz, bl2, bl3, bl4);
    }

    public List<String> getTextForms() {
        return this.textForms;
    }

    public String toString() {
        int n2 = this.textForms.size();
        StringBuilder stringBuilder = new StringBuilder(n2 * 16 + 2);
        stringBuilder.append('{');
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.textForms.get(i2));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    private <V extends Enum<V>> V parse(CharSequence charSequence, ParsePosition parsePosition, Class<V> clazz, boolean bl2, boolean bl3, boolean bl4) {
        Enum[] enumArray = (Enum[])clazz.getEnumConstants();
        int n2 = this.textForms.size();
        int n3 = parsePosition.getIndex();
        int n4 = charSequence.length();
        String string = "";
        int n5 = 0;
        Enum enum_ = null;
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            int n6;
            boolean bl5 = string.isEmpty();
            String string2 = bl5 ? (i2 >= n2 ? enumArray[i2].name() : this.textForms.get(i2)) : string;
            int n7 = n3;
            int n8 = string2.length();
            boolean bl6 = true;
            for (n6 = 0; bl6 && n6 < n8; ++n6) {
                if (n3 + n6 >= n4) {
                    bl6 = false;
                    continue;
                }
                char c2 = charSequence.charAt(n3 + n6);
                char c3 = string2.charAt(n6);
                if (bl4) {
                    if (c2 == '\u00a0') {
                        c2 = ' ';
                    }
                    if (c3 == '\u00a0') {
                        c3 = ' ';
                    }
                }
                if (bl2) {
                    bl6 = c2 == c3 || this.compareIgnoreCase(c2, c3);
                } else {
                    boolean bl7 = bl6 = c2 == c3;
                }
                if (!bl6) continue;
                ++n7;
            }
            if (bl4 && bl5 && n8 == 5 && string2.charAt(4) == '.' && n7 == (n6 = n3 + 3) && n6 < n4 && charSequence.charAt(n6) == '.') {
                string = string2.subSequence(n3, n6) + ".";
                --i2;
                continue;
            }
            string = "";
            if (bl3 || n8 == 1) {
                if (n5 < n7 - n3) {
                    n5 = n7 - n3;
                    enum_ = enumArray[i2];
                    continue;
                }
                if (n5 != n7 - n3) continue;
                enum_ = null;
                continue;
            }
            if (!bl6) continue;
            assert (n7 == n3 + n8);
            parsePosition.setIndex(n7);
            return (V)enumArray[i2];
        }
        if (enum_ == null) {
            parsePosition.setErrorIndex(n3);
        } else {
            parsePosition.setIndex(n3 + n5);
        }
        return (V)enum_;
    }

    private boolean compareIgnoreCase(char c2, char c3) {
        if (c2 >= 'a' && c2 <= 'z') {
            if (c3 >= 'A' && c3 <= 'Z') {
                c3 = (char)(c3 + 97 - 65);
            }
            return c2 == c3;
        }
        if (c2 >= 'A' && c2 <= 'Z') {
            c2 = (char)(c2 + 97 - 65);
            if (c3 >= 'A' && c3 <= 'Z') {
                c3 = (char)(c3 + 97 - 65);
            }
            return c2 == c3;
        }
        return Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3);
    }
}

