/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.Locale;
import net.time4j.format.Leniency;

public enum NumberSystem {
    ARABIC("latn"){

        @Override
        public String toNumeral(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot convert: " + n2);
            }
            return Integer.toString(n2);
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n2 = Math.toIntExact(Long.parseLong(string));
            if (n2 < 0) {
                throw new NumberFormatException("Cannot convert negative number: " + string);
            }
            return n2;
        }

        @Override
        public boolean contains(char c2) {
            return c2 >= '0' && c2 <= '9';
        }

        @Override
        public String getDigits() {
            return "0123456789";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }

        @Override
        public boolean hasDecimalCodepoints() {
            return true;
        }
    }
    ,
    ARABIC_INDIC("arab"){

        @Override
        public String getDigits() {
            return "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    ARABIC_INDIC_EXT("arabext"){

        @Override
        public String getDigits() {
            return "\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    BENGALI("beng"){

        @Override
        public String getDigits() {
            return "\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    CHINESE_DECIMAL("hanidec"){

        @Override
        public String toNumeral(int n2) {
            String string = this.getDigits();
            String string2 = Integer.toString(n2);
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = string2.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = string2.charAt(i2) - 48;
                int n5 = n4 == 0 ? 0 : n4 + 1;
                stringBuilder.append(string.charAt(n5));
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            String string2 = this.getDigits();
            int n2 = 1;
            long l2 = 0L;
            for (int i2 = string.length() - 1; i2 >= 0; --i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\u96f6' || c2 == '\u3007') {
                    n2 *= 10;
                    continue;
                }
                boolean bl2 = false;
                for (int i3 = string2.length() - 1; i3 >= 2; --i3) {
                    if (string2.charAt(i3) != c2) continue;
                    l2 += (long)((i3 - 1) * n2);
                    bl2 = true;
                    break;
                }
                if (bl2) {
                    n2 *= 10;
                    continue;
                }
                throw new NumberFormatException("Invalid numeral: " + string);
            }
            return Math.toIntExact(l2);
        }

        @Override
        public String getDigits() {
            return "\u96f6\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }

        @Override
        public boolean hasDecimalCodepoints() {
            return false;
        }
    }
    ,
    CHINESE_MANDARIN("hans"){

        @Override
        public String toNumeral(int n2) {
            if (n2 == 0) {
                return "\u96f6";
            }
            if (n2 < 1 || n2 > 9999) {
                throw new IllegalArgumentException("Cannot convert: " + n2);
            }
            String string = CHINESE_DECIMAL.getDigits();
            int n3 = n2 / 1000;
            int n4 = n2 % 1000;
            int n5 = n4 / 100;
            int n6 = (n4 %= 100) / 10;
            int n7 = n4 % 10;
            StringBuilder stringBuilder = new StringBuilder();
            if (n3 >= 1) {
                stringBuilder.append(n3 == 2 ? (char)'\u5169' : string.charAt(n3 + 1));
                stringBuilder.append('\u5343');
                if (n5 == 0 && (n6 > 0 || n7 > 0)) {
                    stringBuilder.append('\u96f6');
                }
            }
            if (n5 >= 1) {
                stringBuilder.append(n5 == 2 ? (char)'\u5169' : string.charAt(n5 + 1));
                stringBuilder.append('\u767e');
            }
            if (n6 == 0 && stringBuilder.length() != 0 && n7 > 0) {
                if (stringBuilder.charAt(stringBuilder.length() - 1) != '\u96f6') {
                    stringBuilder.append('\u96f6');
                }
            } else if (n6 == 1 && n5 == 0 && n3 == 0) {
                stringBuilder.append('\u5341');
            } else if (n6 >= 1) {
                stringBuilder.append(string.charAt(n6 + 1));
                stringBuilder.append('\u5341');
            }
            if (n7 > 0) {
                stringBuilder.append(string.charAt(n7 + 1));
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            String string2 = string.replace('\u3007', '\u96f6').replace('\u5169', '\u4e8c');
            if (string2.length() == 1 && string2.charAt(0) == '\u96f6') {
                return 0;
            }
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            String string3 = CHINESE_DECIMAL.getDigits();
            block6: for (int i2 = string2.length() - 1; i2 >= 0; --i2) {
                char c2 = string2.charAt(i2);
                switch (c2) {
                    case '\u96f6': {
                        continue block6;
                    }
                    case '\u5341': {
                        if (n3 == 0 && n4 == 0 && n5 == 0) {
                            ++n3;
                            continue block6;
                        }
                        throw new IllegalArgumentException("Invalid Chinese numeral: " + string);
                    }
                    case '\u767e': {
                        if (n4 == 0 && n5 == 0) {
                            ++n4;
                            continue block6;
                        }
                        throw new IllegalArgumentException("Invalid Chinese numeral: " + string);
                    }
                    case '\u5343': {
                        if (n5 == 0) {
                            ++n5;
                            continue block6;
                        }
                        throw new IllegalArgumentException("Invalid Chinese numeral: " + string);
                    }
                    default: {
                        boolean bl2 = false;
                        for (int i3 = 1; i3 <= 9; ++i3) {
                            if (string3.charAt(i3 + 1) != c2) continue;
                            if (n5 == 1) {
                                n2 += i3 * 1000;
                                n5 = -1;
                            } else if (n4 == 1) {
                                n2 += i3 * 100;
                                n4 = -1;
                            } else if (n3 == 1) {
                                n2 += i3 * 10;
                                n3 = -1;
                            } else {
                                n2 += i3;
                            }
                            bl2 = true;
                            break;
                        }
                        if (bl2) continue block6;
                        throw new IllegalArgumentException("Invalid Chinese numeral: " + string);
                    }
                }
            }
            if (n3 == 1) {
                n2 += 10;
            }
            if (n4 == 1) {
                n2 += 100;
            }
            if (n5 == 1) {
                n2 += 1000;
            }
            return n2;
        }

        @Override
        public String getDigits() {
            return "\u96f6\u3007\u4e00\u4e8c\u5169\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    DEVANAGARI("deva"){

        @Override
        public String getDigits() {
            return "\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    DOZENAL("dozenal"){

        @Override
        public String toNumeral(int n2) {
            if (n2 < 0) {
                throw new IllegalArgumentException("Cannot convert: " + n2);
            }
            return Integer.toString(n2, 12).replace('a', '\u218a').replace('b', '\u218b');
        }

        @Override
        public int toNumeral(int n2, Appendable appendable) throws IOException {
            if (n2 >= 0) {
                int n3;
                int n4 = 0;
                for (n3 = 1; n3 <= 4; ++n3) {
                    if (n2 >= D_FACTORS[n3]) continue;
                    n4 = n3;
                    break;
                }
                if (n4 > 0) {
                    n3 = n4 - 1;
                    do {
                        int n5;
                        appendable.append((char)((n5 = n2 / D_FACTORS[n3]) == 11 ? 8587 : (char)(n5 == 10 ? 8586 : (char)(n5 + 48))));
                        n2 -= n5 * D_FACTORS[n3];
                    } while (--n3 >= 0);
                    return n4;
                }
            }
            return super.toNumeral(n2, appendable);
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n2 = Integer.parseInt(string.replace('\u218a', 'a').replace('\u218b', 'b'), 12);
            if (n2 < 0) {
                throw new NumberFormatException("Cannot convert negative number: " + string);
            }
            return n2;
        }

        @Override
        public boolean contains(char c2) {
            return c2 >= '0' && c2 <= '9' || c2 == '\u218a' || c2 == '\u218b';
        }

        @Override
        public String getDigits() {
            return "0123456789\u218a\u218b";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    ETHIOPIC("ethiopic"){

        @Override
        public String toNumeral(int n2) {
            if (n2 < 1) {
                throw new IllegalArgumentException("Can only convert positive numbers: " + n2);
            }
            String string = String.valueOf(n2);
            int n3 = string.length() - 1;
            if (n3 % 2 == 0) {
                string = "0" + string;
                ++n3;
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = n3; i2 >= 0; --i2) {
                char c2;
                char c3 = '\u0000';
                char c4 = '\u0000';
                char c5 = string.charAt(n3 - i2);
                if ((c2 = string.charAt(n3 - --i2)) != '0') {
                    c4 = (char)(c2 + 4920);
                }
                if (c5 != '0') {
                    c3 = (char)(c5 + 4929);
                }
                int n4 = i2 % 4 / 2;
                char c6 = '\u0000';
                if (i2 != 0) {
                    char c7 = n4 != 0 ? (c4 != '\u0000' || c3 != '\u0000' ? (char)'\u137b' : '\u0000') : (c6 = '\u137c');
                }
                if (c4 == '\u1369' && c3 == '\u0000' && n3 > 1 && (c6 == '\u137b' || i2 + 1 == n3)) {
                    c4 = '\u0000';
                }
                if (c3 != '\u0000') {
                    stringBuilder.append(c3);
                }
                if (c4 != '\u0000') {
                    stringBuilder.append(c4);
                }
                if (c6 == '\u0000') continue;
                stringBuilder.append(c6);
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 1;
            boolean bl2 = false;
            boolean bl3 = false;
            for (int i2 = n2 = string.length() - 1; i2 >= 0; --i2) {
                char c2 = string.charAt(i2);
                if (c2 >= '\u1369' && c2 < '\u1372') {
                    n4 += '\u0001' + c2 - 4969;
                    continue;
                }
                if (c2 >= '\u1372' && c2 < '\u137b') {
                    n4 += ('\u0001' + c2 - 4978) * 10;
                    continue;
                }
                if (c2 == '\u137c') {
                    if (bl2 && n4 == 0) {
                        n4 = 1;
                    }
                    n3 = NumberSystem.addEthiopic(n3, n4, n5);
                    n5 = bl2 ? (n5 *= 100) : (n5 *= 10000);
                    n4 = 0;
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                if (c2 != '\u137b') continue;
                n3 = NumberSystem.addEthiopic(n3, n4, n5);
                n5 *= 100;
                n4 = 0;
                bl2 = true;
                bl3 = false;
            }
            if ((bl2 || bl3) && n4 == 0) {
                n4 = 1;
            }
            n3 = NumberSystem.addEthiopic(n3, n4, n5);
            return n3;
        }

        @Override
        public boolean contains(char c2) {
            return c2 >= '\u1369' && c2 <= '\u137c';
        }

        @Override
        public String getDigits() {
            return "\u1369\u136a\u136b\u136c\u136d\u136e\u136f\u1370\u1371\u1372\u1373\u1374\u1375\u1376\u1377\u1378\u1379\u137a\u137b\u137c";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    GUJARATI("gujr"){

        @Override
        public String getDigits() {
            return "\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    GURMUKHI("guru"){

        @Override
        public String getDigits() {
            return "\u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    JAPANESE("jpan"){

        @Override
        public String toNumeral(int n2) {
            return NumberSystem.japkorToNumeral(n2, this.getDigits(), false);
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            return NumberSystem.japKorToInteger(string, this.getDigits(), leniency, false);
        }

        @Override
        public String getDigits() {
            return "\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u767e\u5343";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    KHMER("khmr"){

        @Override
        public String getDigits() {
            return "\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    KOREAN_NATIVE("korean"){

        @Override
        public String toNumeral(int n2) {
            if (n2 < 1 || n2 > 99) {
                throw new IllegalArgumentException("Cannot convert: " + n2);
            }
            int n3 = n2 / 10;
            int n4 = n2 % 10;
            StringBuilder stringBuilder = new StringBuilder();
            if (n3 >= 1) {
                stringBuilder.append(KOREAN_NATIVE_NUMBERS[n3 + 8]);
            }
            if (n4 > 0) {
                stringBuilder.append(KOREAN_NATIVE_NUMBERS[n4 - 1]);
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            int n2;
            String string2;
            int n3;
            int n4 = 0;
            String string3 = string;
            for (n3 = 0; n3 < 9; ++n3) {
                string2 = KOREAN_NATIVE_NUMBERS[n3];
                if (!string3.endsWith(string2)) continue;
                n2 = string3.length() - string2.length();
                n4 = n3 + 1;
                if (n2 == 0) {
                    return n4;
                }
                string3 = string3.substring(0, n2);
                break;
            }
            for (n3 = 9; n3 < 18; ++n3) {
                string2 = KOREAN_NATIVE_NUMBERS[n3];
                if (!string3.endsWith(string2)) continue;
                n2 = string3.length() - string2.length();
                string3 = string3.substring(0, n2);
                n4 += 10 * (n3 - 8);
                break;
            }
            if (string3.isEmpty()) {
                return n4;
            }
            throw new IllegalArgumentException("Cannot convert: " + string);
        }

        @Override
        public String getDigits() {
            StringBuilder stringBuilder = new StringBuilder(18);
            for (String string : KOREAN_NATIVE_NUMBERS) {
                stringBuilder.append(string);
            }
            return stringBuilder.toString();
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    KOREAN_SINO("koreansino"){

        @Override
        public String toNumeral(int n2) {
            return NumberSystem.japkorToNumeral(n2, this.getDigits(), true);
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            return NumberSystem.japKorToInteger(string, this.getDigits(), leniency, true);
        }

        @Override
        public String getDigits() {
            return "\uc601\uc77c\uc774\uc0bc\uc0ac\uc624\uc721\uce60\ud314\uad6c\uc2ed\ubc31\ucc9c";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    LAO("laoo"){

        @Override
        public String getDigits() {
            return "\u0ed0\u0ed1\u0ed2\u0ed3\u0ed4\u0ed5\u0ed6\u0ed7\u0ed8\u0ed9";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    MYANMAR("mymr"){

        @Override
        public String getDigits() {
            return "\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    ORYA("orya"){

        @Override
        public String getDigits() {
            return "\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    ROMAN("roman"){

        @Override
        public String toNumeral(int n2) {
            if (n2 < 1 || n2 > 3999) {
                throw new IllegalArgumentException("Out of range (1-3999): " + n2);
            }
            int n3 = n2;
            StringBuilder stringBuilder = new StringBuilder();
            for (int i2 = 0; i2 < NUMBERS.length; ++i2) {
                while (n3 >= NUMBERS[i2]) {
                    stringBuilder.append(LETTERS[i2]);
                    n3 -= NUMBERS[i2];
                }
            }
            return stringBuilder.toString();
        }

        @Override
        public int toInteger(String string, Leniency leniency) {
            if (string.isEmpty()) {
                throw new NumberFormatException("Empty Roman numeral.");
            }
            String string2 = string.toUpperCase(Locale.US);
            boolean bl2 = leniency.isStrict();
            int n2 = string.length();
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                int n5;
                char c2 = string2.charAt(n3);
                int n6 = NumberSystem.getValue(c2);
                int n7 = 1;
                if (n5 == n2) {
                    n4 += n6;
                } else {
                    for (n5 = n3 + 1; n5 < n2; ++n5) {
                        char c3 = string2.charAt(n5);
                        if (c3 == c2) {
                            if (++n7 < 4 || !bl2) continue;
                            throw new NumberFormatException("Roman numeral contains more than 3 equal letters in sequence: " + string);
                        }
                        int n8 = NumberSystem.getValue(c3);
                        if (n8 < n6) {
                            n4 += n6 * n7;
                            break;
                        }
                        if (bl2 && (n7 > 1 || !NumberSystem.isValidRomanCombination(c2, c3))) {
                            throw new NumberFormatException("Not conform with modern usage: " + string);
                        }
                        n4 = n4 + n8 - n6 * n7;
                        break;
                    }
                }
                n3 = --n5;
            }
            if (n4 > 3999) {
                throw new NumberFormatException("Roman numbers bigger than 3999 not supported.");
            }
            if (bl2) {
                if (n4 >= 900 && string2.contains("DCD")) {
                    throw new NumberFormatException("Roman number contains invalid sequence DCD.");
                }
                if (n4 >= 90 && string2.contains("LXL")) {
                    throw new NumberFormatException("Roman number contains invalid sequence LXL.");
                }
                if (n4 >= 9 && string2.contains("VIV")) {
                    throw new NumberFormatException("Roman number contains invalid sequence VIV.");
                }
            }
            return n4;
        }

        @Override
        public boolean contains(char c2) {
            char c3 = Character.toUpperCase(c2);
            return c3 == 'I' || c3 == 'V' || c3 == 'X' || c3 == 'L' || c3 == 'C' || c3 == 'D' || c3 == 'M';
        }

        @Override
        public String getDigits() {
            return "IVXLCDM";
        }

        @Override
        public boolean isDecimal() {
            return false;
        }
    }
    ,
    TELUGU("telu"){

        @Override
        public String getDigits() {
            return "\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    }
    ,
    THAI("thai"){

        @Override
        public String getDigits() {
            return "\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59";
        }

        @Override
        public boolean isDecimal() {
            return true;
        }
    };

    private static final char ETHIOPIC_ONE = '\u1369';
    private static final char ETHIOPIC_TEN = '\u1372';
    private static final char ETHIOPIC_HUNDRED = '\u137b';
    private static final char ETHIOPIC_TEN_THOUSAND = '\u137c';
    private static final char CHINESE_TWO_ALT = '\u5169';
    private static final char CHINESE_TWO_STD = '\u4e8c';
    private static final char CHINESE_ZERO_ALT = '\u3007';
    private static final char CHINESE_ZERO_STD = '\u96f6';
    private static final char CHINESE_TEN = '\u5341';
    private static final char CHINESE_HUNDRED = '\u767e';
    private static final char CHINESE_THOUSAND = '\u5343';
    private static final int[] NUMBERS;
    private static final String[] LETTERS;
    private static final int[] D_FACTORS;
    private static final String[] KOREAN_NATIVE_NUMBERS;
    private final String code;

    private NumberSystem(String string2) {
        this.code = string2;
    }

    public String toNumeral(int n2) {
        String string;
        if (this.isDecimal() && n2 >= 0 && (string = this.getDigits()).length() == 10) {
            String string2 = Integer.toString(n2);
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = string2.length();
            for (int i2 = 0; i2 < n3; ++i2) {
                int n4 = string2.charAt(i2) - 48;
                stringBuilder.append(string.charAt(n4));
            }
            return stringBuilder.toString();
        }
        throw new IllegalArgumentException("Cannot convert: " + n2);
    }

    public int toNumeral(int n2, Appendable appendable) throws IOException {
        String string = this.toNumeral(n2);
        appendable.append(string);
        return string.length();
    }

    public final int toInteger(String string) {
        return this.toInteger(string, Leniency.SMART);
    }

    public int toInteger(String string, Leniency leniency) {
        if (this.isDecimal()) {
            int n2;
            String string2 = this.getDigits();
            StringBuilder stringBuilder = new StringBuilder();
            int n3 = string.length();
            for (n2 = 0; n2 < n3; ++n2) {
                char c2 = string.charAt(n2);
                boolean bl2 = false;
                for (int i2 = string2.length() - 1; i2 >= 0; --i2) {
                    if (string2.charAt(i2) != c2) continue;
                    char c3 = (char)(i2 + 48);
                    stringBuilder.append(c3);
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                throw new NumberFormatException("Invalid numeral: " + string);
            }
            n2 = Math.toIntExact(Long.parseLong(stringBuilder.toString()));
            if (n2 < 0) {
                throw new NumberFormatException("Cannot convert negative number: " + string);
            }
            return n2;
        }
        throw new NumberFormatException("Cannot convert: " + string);
    }

    public boolean contains(char c2) {
        String string = this.getDigits();
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) != c2) continue;
            return true;
        }
        return false;
    }

    public String getDigits() {
        throw new AbstractMethodError();
    }

    public boolean isDecimal() {
        throw new AbstractMethodError();
    }

    public boolean hasDecimalCodepoints() {
        return this.isDecimal();
    }

    public String getCode() {
        return this.code;
    }

    private static int addEthiopic(int n2, int n3, int n4) {
        return Math.addExact(n2, Math.multiplyExact(n3, n4));
    }

    private static int getValue(char c2) {
        switch (c2) {
            case 'I': {
                return 1;
            }
            case 'V': {
                return 5;
            }
            case 'X': {
                return 10;
            }
            case 'L': {
                return 50;
            }
            case 'C': {
                return 100;
            }
            case 'D': {
                return 500;
            }
            case 'M': {
                return 1000;
            }
        }
        throw new NumberFormatException("Invalid Roman digit: " + c2);
    }

    private static boolean isValidRomanCombination(char c2, char c3) {
        switch (c2) {
            case 'C': {
                return c3 == 'M' || c3 == 'D';
            }
            case 'X': {
                return c3 == 'C' || c3 == 'L';
            }
            case 'I': {
                return c3 == 'X' || c3 == 'V';
            }
        }
        return false;
    }

    private static String japkorToNumeral(int n2, String string, boolean bl2) {
        int n3;
        if (bl2 && n2 == 0) {
            return String.valueOf(string.charAt(0));
        }
        if (n2 < 1 || n2 > 9999) {
            throw new IllegalArgumentException("Cannot convert: " + n2);
        }
        int n4 = n2 / 1000;
        int n5 = n2 % 1000;
        int n6 = n5 / 100;
        int n7 = (n5 %= 100) / 10;
        int n8 = n5 % 10;
        int n9 = string.length();
        StringBuilder stringBuilder = new StringBuilder();
        int n10 = n3 = bl2 ? 0 : 1;
        if (n4 >= 1) {
            if (n4 > 1) {
                stringBuilder.append(string.charAt(n4 - n3));
            }
            stringBuilder.append(string.charAt(n9 - 1));
        }
        if (n6 >= 1) {
            if (n6 > 1) {
                stringBuilder.append(string.charAt(n6 - n3));
            }
            stringBuilder.append(string.charAt(n9 - 2));
        }
        if (n7 >= 1) {
            if (n7 > 1) {
                stringBuilder.append(string.charAt(n7 - n3));
            }
            stringBuilder.append(string.charAt(n9 - 3));
        }
        if (n8 > 0) {
            stringBuilder.append(string.charAt(n8 - n3));
        }
        return stringBuilder.toString();
    }

    private static int japKorToInteger(String string, String string2, Leniency leniency, boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string2.length();
        boolean bl3 = false;
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (!leniency.isStrict() && c2 == '\ub959') {
                c2 = '\uc721';
            }
            if (c2 == string2.charAt(n6 - 3)) {
                if (n3 == 0 && n4 == 0 && n5 == 0) {
                    ++n3;
                } else {
                    bl3 = true;
                }
            } else if (c2 == string2.charAt(n6 - 2)) {
                if (n4 == 0 && n5 == 0) {
                    ++n4;
                } else {
                    bl3 = true;
                }
            } else if (c2 == string2.charAt(n6 - 1)) {
                if (n5 == 0) {
                    ++n5;
                } else {
                    bl3 = true;
                }
            } else if (bl2 && c2 == '\uc601') {
                if (string.length() == 1) {
                    return 0;
                }
                bl3 = true;
            } else if (bl2 && !leniency.isStrict() && (c2 == '\ub839' || c2 == '\uacf5')) {
                if (string.length() == 1) {
                    return 0;
                }
                bl3 = true;
            } else {
                bl3 = true;
                int n7 = bl2 ? 1 : 0;
                for (int i3 = 0; i3 < 9; ++i3) {
                    if (string2.charAt(i3 + n7) != c2) continue;
                    int n8 = i3 + 1;
                    if (n5 == 1) {
                        n2 += n8 * 1000;
                        n5 = -1;
                    } else if (n4 == 1) {
                        n2 += n8 * 100;
                        n4 = -1;
                    } else if (n3 == 1) {
                        n2 += n8 * 10;
                        n3 = -1;
                    } else {
                        n2 += n8;
                    }
                    bl3 = false;
                    break;
                }
            }
            if (!bl3) continue;
            throw new IllegalArgumentException("Invalid numeral: " + string);
        }
        if (n3 == 1) {
            n2 += 10;
        }
        if (n4 == 1) {
            n2 += 100;
        }
        if (n5 == 1) {
            n2 += 1000;
        }
        return n2;
    }

    static {
        NUMBERS = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
        LETTERS = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};
        D_FACTORS = new int[]{1, 12, 144, 1728, 20736};
        KOREAN_NATIVE_NUMBERS = new String[]{"\ud558\ub098", "\ub458", "\uc14b", "\ub137", "\ub2e4\uc12f", "\uc5ec\uc12f", "\uc77c\uacf1", "\uc5ec\ub35f", "\uc544\ud649", "\uc5f4", "\uc2a4\ubb3c", "\uc11c\ub978", "\ub9c8\ud754", "\uc270", "\uc608\uc21c", "\uc77c\ud754", "\uc5ec\ub4e0", "\uc544\ud754"};
    }
}

