/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.clock;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.ServiceLoader;
import net.time4j.Moment;
import net.time4j.SystemClock;
import net.time4j.clock.NetTimeConnector;
import net.time4j.clock.SntpConfiguration;
import net.time4j.clock.SntpMessage;
import net.time4j.scale.TimeScale;

public class SntpConnector
extends NetTimeConnector<SntpConfiguration> {
    private static final int MIO = 1000000;
    private volatile SntpMessage lastReply = null;

    public SntpConnector() {
        super(SntpConnector.initConfiguration());
    }

    public SntpConnector(SntpConfiguration sntpConfiguration) {
        super(sntpConfiguration);
    }

    public SntpConnector(String string) {
        super(new SimpleNtpConfiguration(string));
    }

    public long currentTimeInMillis() {
        if (!this.isRunning()) {
            Moment moment = this.currentTime();
            return moment.getPosixTime() * 1000L + (long)(moment.getNanosecond() / 1000000);
        }
        long l2 = SystemClock.MONOTONIC.currentTimeInMillis();
        return l2 + this.getLastOffset(l2 * 1000L) / 1000L;
    }

    public long currentTimeInMicros() {
        if (!this.isRunning()) {
            Moment moment = this.currentTime();
            return moment.getPosixTime() * 1000000L + (long)(moment.getNanosecond() / 1000);
        }
        long l2 = SystemClock.MONOTONIC.currentTimeInMicros();
        return l2 + this.getLastOffset(l2);
    }

    public SntpMessage getLastReply() {
        return this.lastReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Moment doConnect() throws IOException {
        byte by2;
        SntpConfiguration sntpConfiguration = (SntpConfiguration)this.getNetTimeConfiguration();
        int n2 = sntpConfiguration.getRequestCount();
        if (n2 <= 0) {
            return SystemClock.MONOTONIC.currentTime();
        }
        String string = sntpConfiguration.getTimeServerAddress();
        int n3 = sntpConfiguration.getTimeServerPort();
        int n4 = sntpConfiguration.getConnectionTimeout();
        boolean bl2 = sntpConfiguration.isNTP4();
        long l2 = sntpConfiguration.getRequestInterval() * 1000;
        long l3 = 0L;
        long l4 = 0L;
        try (DatagramSocket datagramSocket = null;){
            datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(n4 * 1000);
            for (int i2 = 1; i2 <= n2; ++i2) {
                SntpMessage sntpMessage;
                this.log(null, "Connecting NTP-Server, waiting for reply...");
                InetAddress inetAddress = InetAddress.getByName(string);
                SntpMessage sntpMessage2 = new SntpMessage(bl2);
                double d2 = sntpMessage2.getTransmitTimestamp();
                by2 = sntpMessage2.getVersion();
                byte[] byArray = sntpMessage2.getBytes();
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, inetAddress, n3);
                datagramSocket.send(datagramPacket);
                DatagramPacket datagramPacket2 = new DatagramPacket(byArray, byArray.length);
                datagramSocket.receive(datagramPacket2);
                double d3 = SntpMessage.getLocalTimestamp();
                this.lastReply = sntpMessage = new SntpMessage(datagramPacket2.getData(), d2, by2);
                if (this.isLogEnabled()) {
                    this.log("NTP-Server connected: ", sntpMessage.toString());
                }
                double d4 = (sntpMessage.getReceiveTimestamp() - sntpMessage.getOriginateTimestamp() + sntpMessage.getTransmitTimestamp() - d3) / 2.0;
                l3 = (long)((double)l3 + d4 * 1000000.0);
                l4 = l3 / (long)i2;
                if (sntpMessage.getStratum() == 0) {
                    this.log("NTP-Server replied: ", "<kiss-o'-death>");
                    break;
                }
                if (i2 <= 1 || i2 >= n2) continue;
                try {
                    Thread.sleep(l2);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    this.log(null, "NTP-Connection interrupted.");
                    break;
                }
            }
        }
        long l5 = SystemClock.MONOTONIC.currentTimeInMicros() + l4;
        long l6 = l5 / 1000000L;
        int n5 = (int)(l5 % 1000000L * 1000L);
        by2 = this.lastReply.getLeapIndicator();
        if (by2 == 3) {
            throw new IOException("Alarm condition: NTP-Server is not synchronized with any clock source.");
        }
        if (by2 == 1) {
            this.log(null, "Positive leap second announced.");
        } else if (by2 == 2) {
            this.log(null, "Negative leap second announced.");
        }
        return Moment.of(l6, n5, TimeScale.POSIX);
    }

    @Override
    protected SntpConfiguration loadNetTimeConfiguration() {
        SntpConfiguration sntpConfiguration = (SntpConfiguration)super.loadNetTimeConfiguration();
        short s2 = sntpConfiguration.getRequestCount();
        int n2 = sntpConfiguration.getRequestInterval();
        if (s2 < 0 || s2 >= 1000) {
            throw new IllegalStateException("Wrong request count: " + s2);
        }
        if (n2 <= 0) {
            throw new IllegalStateException("Wrong request interval.");
        }
        return sntpConfiguration;
    }

    @Override
    protected Class<SntpConfiguration> getConfigurationType() {
        return SntpConfiguration.class;
    }

    private static SntpConfiguration initConfiguration() {
        ServiceLoader<SntpConfiguration> serviceLoader = ServiceLoader.load(SntpConfiguration.class);
        for (SntpConfiguration sntpConfiguration : serviceLoader) {
            if (sntpConfiguration == null) continue;
            return sntpConfiguration;
        }
        throw new IllegalStateException("SNTP-configuration not found.");
    }

    private static class SimpleNtpConfiguration
    implements SntpConfiguration {
        private final String server;

        SimpleNtpConfiguration(String string) {
            if (string == null) {
                throw new NullPointerException("Missing time server address.");
            }
            this.server = string;
        }

        @Override
        public String getTimeServerAddress() {
            return this.server;
        }

        @Override
        public int getTimeServerPort() {
            return 123;
        }

        @Override
        public int getConnectionTimeout() {
            return 60;
        }

        @Override
        public boolean isNTP4() {
            return true;
        }

        @Override
        public int getRequestInterval() {
            return 240;
        }

        @Override
        public short getRequestCount() {
            return 1;
        }

        @Override
        public int getClockShiftWindow() {
            return 0;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SimpleNtpConfiguration:[server=");
            stringBuilder.append(this.server);
            stringBuilder.append(",port=");
            stringBuilder.append(this.getTimeServerPort());
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

