/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.util.function.Function;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ElementRule;

public class WeekdayRule<D extends CalendarDate>
implements ElementRule<D, Weekday> {
    private final Weekmodel stdWeekmodel;
    private final Function<D, CalendarSystem<D>> calsysFunc;

    public WeekdayRule(Weekmodel weekmodel, Function<D, CalendarSystem<D>> function) {
        this.stdWeekmodel = weekmodel;
        this.calsysFunc = function;
    }

    @Override
    public Weekday getValue(D d2) {
        return WeekdayRule.getWeekday(d2.getDaysSinceEpochUTC());
    }

    @Override
    public Weekday getMinimum(D d2) {
        CalendarSystem<D> calendarSystem = this.calsysFunc.apply(d2);
        int n2 = this.getValue(d2).getValue(this.stdWeekmodel);
        if (d2.getDaysSinceEpochUTC() + 1L - (long)n2 < calendarSystem.getMinimumSinceUTC()) {
            return WeekdayRule.getWeekday(calendarSystem.getMinimumSinceUTC());
        }
        return this.stdWeekmodel.getFirstDayOfWeek();
    }

    @Override
    public Weekday getMaximum(D d2) {
        CalendarSystem<D> calendarSystem = this.calsysFunc.apply(d2);
        int n2 = this.getValue(d2).getValue(this.stdWeekmodel);
        if (d2.getDaysSinceEpochUTC() + 7L - (long)n2 > calendarSystem.getMaximumSinceUTC()) {
            return WeekdayRule.getWeekday(calendarSystem.getMaximumSinceUTC());
        }
        return this.stdWeekmodel.getFirstDayOfWeek().roll(6);
    }

    @Override
    public boolean isValid(D d2, Weekday weekday) {
        CalendarSystem<D> calendarSystem;
        if (weekday == null) {
            return false;
        }
        int n2 = this.getValue(d2).getValue(this.stdWeekmodel);
        int n3 = weekday.getValue(this.stdWeekmodel);
        long l2 = d2.getDaysSinceEpochUTC() + (long)n3 - (long)n2;
        return l2 >= (calendarSystem = this.calsysFunc.apply(d2)).getMinimumSinceUTC() && l2 <= calendarSystem.getMaximumSinceUTC();
    }

    @Override
    public D withValue(D d2, Weekday weekday, boolean bl2) {
        CalendarSystem<D> calendarSystem;
        if (weekday == null) {
            throw new IllegalArgumentException("Missing weekday.");
        }
        int n2 = this.getValue(d2).getValue(this.stdWeekmodel);
        int n3 = weekday.getValue(this.stdWeekmodel);
        long l2 = d2.getDaysSinceEpochUTC() + (long)n3 - (long)n2;
        if (l2 >= (calendarSystem = this.calsysFunc.apply(d2)).getMinimumSinceUTC() && l2 <= calendarSystem.getMaximumSinceUTC()) {
            return (D)((CalendarDate)calendarSystem.transform(l2));
        }
        throw new IllegalArgumentException("New day out of supported range.");
    }

    @Override
    public ChronoElement<?> getChildAtFloor(D d2) {
        return null;
    }

    @Override
    public ChronoElement<?> getChildAtCeiling(D d2) {
        return null;
    }

    private static Weekday getWeekday(long l2) {
        return Weekday.valueOf(MathUtils.floorModulo(l2 + 5L, 7) + 1);
    }
}

