/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.service;

import java.util.Collections;
import java.util.Map;
import net.time4j.base.MathUtils;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;

public final class RelatedGregorianYearRule<T extends ChronoEntity<T>>
implements ElementRule<T, Integer> {
    private static final String KEY_CALENDRICAL = "calendrical";
    private final Map<String, ? extends CalendarSystem<T>> map;
    private final ChronoElement<Integer> dayOfYear;

    public RelatedGregorianYearRule(CalendarSystem<T> calendarSystem, ChronoElement<Integer> chronoElement) {
        this.map = Collections.singletonMap(KEY_CALENDRICAL, calendarSystem);
        this.dayOfYear = chronoElement;
    }

    public RelatedGregorianYearRule(Map<String, ? extends CalendarSystem<T>> map, ChronoElement<Integer> chronoElement) {
        this.map = map;
        this.dayOfYear = chronoElement;
    }

    @Override
    public Integer getValue(T t2) {
        CalendarSystem<T> calendarSystem = this.getCalendarSystem(t2);
        Object t3 = ((ChronoEntity)t2).with(this.dayOfYear, 1);
        return RelatedGregorianYearRule.toGregorianYear(calendarSystem.transform(t3));
    }

    @Override
    public Integer getMinimum(T t2) {
        CalendarSystem<T> calendarSystem = this.getCalendarSystem(t2);
        long l2 = calendarSystem.getMinimumSinceUTC();
        Object t3 = ((ChronoEntity)calendarSystem.transform(l2)).with(this.dayOfYear, 1);
        return RelatedGregorianYearRule.toGregorianYear(calendarSystem.transform(t3));
    }

    @Override
    public Integer getMaximum(T t2) {
        CalendarSystem<T> calendarSystem = this.getCalendarSystem(t2);
        long l2 = calendarSystem.getMaximumSinceUTC();
        Object t3 = ((ChronoEntity)calendarSystem.transform(l2)).with(this.dayOfYear, 1);
        return RelatedGregorianYearRule.toGregorianYear(calendarSystem.transform(t3));
    }

    @Override
    public boolean isValid(T t2, Integer n2) {
        return this.getValue(t2).equals(n2);
    }

    @Override
    public T withValue(T t2, Integer n2, boolean bl2) {
        if (this.isValid(t2, n2)) {
            return t2;
        }
        throw new IllegalArgumentException("The related gregorian year is read-only.");
    }

    @Override
    public ChronoElement<?> getChildAtFloor(T t2) {
        return null;
    }

    @Override
    public ChronoElement<?> getChildAtCeiling(T t2) {
        return null;
    }

    private CalendarSystem<T> getCalendarSystem(T t2) {
        if (t2 instanceof CalendarVariant) {
            return this.map.get(((CalendarVariant)CalendarVariant.class.cast(t2)).getVariant());
        }
        return this.map.get(KEY_CALENDRICAL);
    }

    private static Integer toGregorianYear(long l2) {
        long l3;
        long l4 = EpochDays.MODIFIED_JULIAN_DATE.transform(l2, EpochDays.UTC);
        long l5 = MathUtils.safeAdd(l4, 678881L);
        long l6 = MathUtils.floorDivide(l5, 146097);
        int n2 = MathUtils.floorModulo(l5, 146097);
        if (n2 == 146096) {
            l3 = (l6 + 1L) * 400L;
        } else {
            int n3 = n2 / 36524;
            int n4 = n2 % 36524;
            int n5 = n4 / 1461;
            int n6 = n4 % 1461;
            if (n6 == 1460) {
                l3 = l6 * 400L + (long)(n3 * 100) + (long)((n5 + 1) * 4);
            } else {
                int n7 = n6 / 365;
                int n8 = n6 % 365;
                l3 = l6 * 400L + (long)(n3 * 100) + (long)(n5 * 4) + (long)n7;
                int n9 = (n8 + 31) * 5 / 153 + 2;
                if (n9 > 12) {
                    ++l3;
                }
            }
        }
        return MathUtils.safeCast(l3);
    }
}

