/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.hindu;

import java.io.Serializable;
import net.time4j.calendar.hindu.HinduCalendar;
import net.time4j.calendar.hindu.HinduPrimitive;
import net.time4j.engine.ChronoCondition;

public final class HinduDay
extends HinduPrimitive
implements Comparable<HinduDay>,
ChronoCondition<HinduCalendar>,
Serializable {
    private final int value;
    private final boolean leap;

    private HinduDay(int n2, boolean bl2) {
        if (n2 < 1 || n2 > 32) {
            throw new IllegalArgumentException("Day-of-month value out of range: " + n2);
        }
        this.value = n2;
        this.leap = bl2;
    }

    public static HinduDay valueOf(int n2) {
        return new HinduDay(n2, false);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public boolean isLeap() {
        return this.leap;
    }

    public HinduDay withLeap() {
        return this.leap ? this : new HinduDay(this.value, true);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HinduDay) {
            HinduDay hinduDay = (HinduDay)object;
            return this.value == hinduDay.value && this.leap == hinduDay.leap;
        }
        return false;
    }

    public int hashCode() {
        return this.value + (this.leap ? 12 : 0);
    }

    public String toString() {
        String string = String.valueOf(this.value);
        return this.leap ? "*" + string : string;
    }

    @Override
    public int compareTo(HinduDay hinduDay) {
        int n2 = this.value - hinduDay.value;
        if (n2 == 0) {
            n2 = this.leap ? (hinduDay.leap ? 0 : 1) : (hinduDay.leap ? -1 : 0);
        }
        return n2;
    }

    @Override
    public boolean test(HinduCalendar hinduCalendar) {
        return this.equals(hinduCalendar.getDayOfMonth());
    }
}

