/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

public interface GeoLocation {
    public static GeoLocation of(double d2, double d3) {
        return GeoLocation.of(d2, d3, 0);
    }

    public static GeoLocation of(final double d2, final double d3, final int n2) {
        if (!Double.isFinite(d2)) {
            throw new IllegalArgumentException("Latitude must be a finite value: " + d2);
        }
        if (!Double.isFinite(d3)) {
            throw new IllegalArgumentException("Longitude must be a finite value: " + d3);
        }
        if (Double.compare(d2, 90.0) > 0 || Double.compare(d2, -90.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -90.0 <= latitude <= +90.0: " + d2);
        }
        if (Double.compare(d3, 180.0) >= 0 || Double.compare(d3, -180.0) < 0) {
            throw new IllegalArgumentException("Degrees out of range -180.0 <= longitude < +180.0: " + d3);
        }
        if (n2 < 0 || n2 >= 11000) {
            throw new IllegalArgumentException("Meters out of range 0 <= altitude < +11,000: " + n2);
        }
        return new GeoLocation(){

            @Override
            public double getLatitude() {
                return d2;
            }

            @Override
            public double getLongitude() {
                return d3;
            }

            @Override
            public int getAltitude() {
                return n2;
            }
        };
    }

    public double getLatitude();

    public double getLongitude();

    public int getAltitude();
}

