/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.base.MathUtils;
import net.time4j.format.CalendarText;

public class SexagesimalName
implements Comparable<SexagesimalName>,
Serializable {
    private static final String[] STEMS_SIMPLE = new String[]{"jia", "yi", "bing", "ding", "wu", "ji", "geng", "xin", "ren", "gui"};
    private static final String[] STEMS_PINYIN = new String[]{"ji\u01ce", "y\u01d0", "b\u01d0ng", "d\u012bng", "w\u00f9", "j\u01d0", "g\u0113ng", "x\u012bn", "r\u00e9n", "gu\u01d0"};
    private static final String[] STEMS_CHINESE = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] STEMS_KOREAN = new String[]{"\uac11", "\uc744", "\ubcd1", "\uc815", "\ubb34", "\uae30", "\uacbd", "\uc2e0", "\uc784", "\uacc4"};
    private static final String[] STEMS_VIETNAMESE = new String[]{"gi\u00e1p", "\u1ea5t", "b\u00ednh", "\u0111inh", "m\u1eadu", "k\u1ef7", "canh", "t\u00e2n", "nh\u00e2m", "qu\u00fd"};
    private static final String[] STEMS_RUSSIAN = new String[]{"\u0426\u0437\u044f", "\u0418", "\u0411\u0438\u043d", "\u0414\u0438\u043d", "\u0423", "\u0426\u0437\u0438", "\u0413\u044d\u043d", "\u0421\u0438\u043d\u044c", "\u0416\u044d\u043d\u044c", "\u0413\u0443\u0439"};
    private static final String[] BRANCHES_SIMPLE = new String[]{"zi", "chou", "yin", "mao", "chen", "si", "wu", "wei", "shen", "you", "xu", "hai"};
    private static final String[] BRANCHES_PINYIN = new String[]{"z\u01d0", "ch\u01d2u", "y\u00edn", "m\u01ceo", "ch\u00e9n", "s\u00ec", "w\u01d4", "w\u00e8i", "sh\u0113n", "y\u01d2u", "x\u016b", "h\u00e0i"};
    private static final String[] BRANCHES_CHINESE = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] BRANCHES_KOREAN = new String[]{"\uc790", "\ucd95", "\uc778", "\ubb18", "\uc9c4", "\uc0ac", "\uc624", "\ubbf8", "\uc2e0", "\uc720", "\uc220", "\ud574"};
    private static final String[] BRANCHES_VIETNAMESE = new String[]{"t\u00ed", "s\u1eedu", "d\u1ea7n", "m\u00e3o", "th\u00ecn", "t\u1ecb", "ng\u1ecd", "m\u00f9i", "th\u00e2n", "d\u1eadu", "tu\u1ea5t", "h\u1ee3i"};
    private static final String[] BRANCHES_RUSSIAN = new String[]{"\u0426\u0437\u044b", "\u0427\u043e\u0443", "\u0418\u043d\u044c", "\u041c\u0430\u043e", "\u0427\u044d\u043d\u044c", "\u0421\u044b", "\u0423", "\u0412\u044d\u0439", "\u0428\u044d\u043d\u044c", "\u042e", "\u0421\u044e\u0439", "\u0425\u0430\u0439"};
    private static final SexagesimalName[] INSTANCES;
    private static final Map<String, String[]> LANG_2_STEM;
    private static final Map<String, String[]> LANG_2_BRANCH;
    private static final Set<String> LANGS_WITHOUT_SEP;
    private static final long serialVersionUID = -4556668597489844917L;
    private final int number;

    SexagesimalName(int n2) {
        this.number = n2;
    }

    public static SexagesimalName of(int n2) {
        if (n2 < 1 || n2 > 60) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        return INSTANCES[n2 - 1];
    }

    public static SexagesimalName of(Stem stem, Branch branch) {
        int n2;
        int n3 = stem.ordinal();
        int n4 = n3 + 1 + MathUtils.floorModulo(25 * ((n2 = branch.ordinal()) - n3), 60);
        SexagesimalName sexagesimalName = SexagesimalName.of(n4);
        if (sexagesimalName.getStem() == stem && sexagesimalName.getBranch() == branch) {
            return sexagesimalName;
        }
        throw new IllegalArgumentException("Invalid combination of stem and branch.");
    }

    public int getNumber() {
        return this.number;
    }

    public Stem getStem() {
        int n2 = this.number % 10;
        if (n2 == 0) {
            n2 = 10;
        }
        return Stem.values()[n2 - 1];
    }

    public Branch getBranch() {
        int n2 = this.number % 12;
        if (n2 == 0) {
            n2 = 12;
        }
        return Branch.values()[n2 - 1];
    }

    public static SexagesimalName parse(String string, Locale locale) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        SexagesimalName sexagesimalName = SexagesimalName.parse(string, parsePosition, locale, true);
        if (sexagesimalName == null) {
            throw new ParseException(string, 0);
        }
        return sexagesimalName;
    }

    public String getDisplayName(Locale locale) {
        Stem stem = this.getStem();
        Branch branch = this.getBranch();
        String string = LANGS_WITHOUT_SEP.contains(locale.getLanguage()) ? "" : "-";
        return stem.getDisplayName(locale) + string + branch.getDisplayName(locale);
    }

    public String getZodiac(Locale locale) {
        return this.getBranch().getZodiac(locale);
    }

    public SexagesimalName roll(int n2) {
        if (n2 == 0) {
            return this;
        }
        return SexagesimalName.of(MathUtils.floorModulo(MathUtils.safeAdd(this.number - 1, n2), 60) + 1);
    }

    @Override
    public int compareTo(SexagesimalName sexagesimalName) {
        if (this.getClass().equals(sexagesimalName.getClass())) {
            return this.number - ((SexagesimalName)SexagesimalName.class.cast((Object)sexagesimalName)).number;
        }
        throw new ClassCastException("Cannot compare different types.");
    }

    public boolean equals(Object object) {
        if (this.getClass().equals(object.getClass())) {
            return this.number == ((SexagesimalName)object).number;
        }
        return false;
    }

    public int hashCode() {
        return Integer.hashCode(this.number);
    }

    public String toString() {
        return this.getDisplayName(Locale.ROOT) + "(" + String.valueOf(this.number) + ")";
    }

    /*
     * WARNING - void declaration
     */
    static SexagesimalName parse(CharSequence charSequence, ParsePosition parsePosition, Locale locale, boolean bl2) {
        int n2 = parsePosition.getIndex();
        int n3 = charSequence.length();
        boolean bl3 = locale.getLanguage().isEmpty();
        if (n2 + 1 >= n3 || n2 < 0) {
            parsePosition.setErrorIndex(n2);
            return null;
        }
        Stem enum_ = null;
        Enum enum_2 = null;
        if (LANGS_WITHOUT_SEP.contains(locale.getLanguage())) {
            for (Stem enum_3 : Stem.values()) {
                if (enum_3.getDisplayName(locale).charAt(0) != charSequence.charAt(n2)) continue;
                enum_ = enum_3;
                break;
            }
            if (enum_ != null) {
                for (Enum enum_3 : Branch.values()) {
                    if (((Branch)enum_3).getDisplayName(locale).charAt(0) != charSequence.charAt(n2 + 1)) continue;
                    enum_2 = enum_3;
                    n2 += 2;
                    break;
                }
            }
        } else {
            void var12_22;
            char c2;
            int n4;
            int n5;
            String string;
            void var12_20;
            int n6 = -1;
            for (int i2 = n2 + 1; i2 < n3; ++i2) {
                if (charSequence.charAt(i2) != '-') continue;
                n6 = i2;
                break;
            }
            if (n6 == -1) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            Enum[] enumArray = Stem.values();
            int n7 = enumArray.length;
            boolean bl4 = false;
            while (var12_20 < n7) {
                Stem stem = enumArray[var12_20];
                string = stem.getDisplayName(locale);
                for (n5 = n2; n5 < n6; ++n5) {
                    n4 = n5 - n2;
                    c2 = charSequence.charAt(n5);
                    if (bl3) {
                        c2 = SexagesimalName.toASCII(c2);
                    }
                    if (n4 >= string.length() || string.charAt(n4) != c2) break;
                    if (n4 + 1 != string.length()) continue;
                    enum_ = stem;
                    break;
                }
                ++var12_20;
            }
            if (enum_ == null) {
                if (bl2 && !bl3 && n6 + 1 < n3) {
                    return SexagesimalName.parse(charSequence, parsePosition, Locale.ROOT, true);
                }
                parsePosition.setErrorIndex(n2);
                return null;
            }
            enumArray = Branch.values();
            n7 = enumArray.length;
            boolean bl5 = false;
            while (var12_22 < n7) {
                Enum enum_4 = enumArray[var12_22];
                string = ((Branch)enum_4).getDisplayName(locale);
                for (n5 = n6 + 1; n5 < n3; ++n5) {
                    n4 = n5 - n6 - 1;
                    c2 = charSequence.charAt(n5);
                    if (bl3) {
                        c2 = SexagesimalName.toASCII(c2);
                    }
                    if (n4 >= string.length() || string.charAt(n4) != c2) break;
                    if (n4 + 1 != string.length()) continue;
                    enum_2 = enum_4;
                    n2 = n5 + 1;
                    break;
                }
                ++var12_22;
            }
        }
        if (enum_ == null || enum_2 == null) {
            if (bl2 && !bl3) {
                return SexagesimalName.parse(charSequence, parsePosition, Locale.ROOT, true);
            }
            parsePosition.setErrorIndex(n2);
            return null;
        }
        parsePosition.setIndex(n2);
        return SexagesimalName.of(enum_, enum_2);
    }

    private static char toASCII(char c2) {
        switch (c2) {
            case '\u00e0': 
            case '\u01ce': {
                return 'a';
            }
            case '\u00ec': 
            case '\u00ed': 
            case '\u012b': 
            case '\u01d0': {
                return 'i';
            }
            case '\u00f9': 
            case '\u016b': {
                return 'u';
            }
            case '\u00e8': 
            case '\u00e9': 
            case '\u0113': {
                return 'e';
            }
            case '\u01d2': {
                return 'o';
            }
        }
        return c2;
    }

    Object readResolve() throws ObjectStreamException {
        return SexagesimalName.of(this.number);
    }

    static {
        SexagesimalName[] sexagesimalNameArray = new SexagesimalName[60];
        for (int i2 = 0; i2 < 60; ++i2) {
            sexagesimalNameArray[i2] = new SexagesimalName(i2 + 1);
        }
        INSTANCES = sexagesimalNameArray;
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put("root", STEMS_SIMPLE);
        hashMap.put("zh", STEMS_CHINESE);
        hashMap.put("ja", STEMS_CHINESE);
        hashMap.put("ko", STEMS_KOREAN);
        hashMap.put("vi", STEMS_VIETNAMESE);
        hashMap.put("ru", STEMS_RUSSIAN);
        LANG_2_STEM = Collections.unmodifiableMap(hashMap);
        HashMap<String, String[]> hashMap2 = new HashMap<String, String[]>();
        hashMap2.put("root", BRANCHES_SIMPLE);
        hashMap2.put("zh", BRANCHES_CHINESE);
        hashMap2.put("ja", BRANCHES_CHINESE);
        hashMap2.put("ko", BRANCHES_KOREAN);
        hashMap2.put("vi", BRANCHES_VIETNAMESE);
        hashMap2.put("ru", BRANCHES_RUSSIAN);
        LANG_2_BRANCH = Collections.unmodifiableMap(hashMap2);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("zh");
        hashSet.add("ja");
        hashSet.add("ko");
        LANGS_WITHOUT_SEP = Collections.unmodifiableSet(hashSet);
    }

    public static enum Stem {
        JIA_1_WOOD_YANG,
        YI_2_WOOD_YIN,
        BING_3_FIRE_YANG,
        DING_4_FIRE_YIN,
        WU_5_EARTH_YANG,
        JI_6_EARTH_YIN,
        GENG_7_METAL_YANG,
        XIN_8_METAL_YIN,
        REN_9_WATER_YANG,
        GUI_10_WATER_YIN;


        public String getDisplayName(Locale locale) {
            String string = locale.getLanguage();
            String[] stringArray = (String[])LANG_2_STEM.get(string.isEmpty() ? "root" : string);
            if (stringArray == null) {
                stringArray = STEMS_PINYIN;
            }
            return stringArray[this.ordinal()];
        }
    }

    public static enum Branch {
        ZI_1_RAT,
        CHOU_2_OX,
        YIN_3_TIGER,
        MAO_4_HARE,
        CHEN_5_DRAGON,
        SI_6_SNAKE,
        WU_7_HORSE,
        WEI_8_SHEEP,
        SHEN_9_MONKEY,
        YOU_10_FOWL,
        XU_11_DOG,
        HAI_12_PIG;


        public String getDisplayName(Locale locale) {
            String string = locale.getLanguage();
            String[] stringArray = (String[])LANG_2_BRANCH.get(string.isEmpty() ? "root" : string);
            if (stringArray == null) {
                stringArray = BRANCHES_PINYIN;
            }
            return stringArray[this.ordinal()];
        }

        public String getZodiac(Locale locale) {
            String string = "zodiac-" + String.valueOf(this.ordinal() + 1);
            return CalendarText.getInstance("chinese", locale).getTextForms().get(string);
        }
    }
}

