/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.ChineseCalendar;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.KoreanCalendar;
import net.time4j.calendar.VietnameseCalendar;

final class SPXEA
implements Externalizable {
    static final int CHINESE = 14;
    static final int KOREAN = 15;
    static final int VIETNAMESE = 16;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPXEA() {
    }

    SPXEA(Object object, int n2) {
        this.obj = object;
        this.type = n2;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 14: 
            case 15: 
            case 16: {
                EastAsianCalendar eastAsianCalendar = (EastAsianCalendar)this.obj;
                objectOutput.writeByte(eastAsianCalendar.getCycle());
                objectOutput.writeByte(eastAsianCalendar.getYear().getNumber());
                objectOutput.writeByte(eastAsianCalendar.getMonth().getNumber());
                objectOutput.writeBoolean(eastAsianCalendar.getMonth().isLeap());
                objectOutput.writeByte(eastAsianCalendar.getDayOfMonth());
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by2 = objectInput.readByte();
        byte by3 = objectInput.readByte();
        byte by4 = objectInput.readByte();
        byte by5 = objectInput.readByte();
        boolean bl2 = objectInput.readBoolean();
        byte by6 = objectInput.readByte();
        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(by5);
        if (bl2) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        switch (by2) {
            case 14: {
                this.obj = ChineseCalendar.of(by3, by4, eastAsianMonth, by6);
                break;
            }
            case 15: {
                this.obj = KoreanCalendar.of(by3, by4, eastAsianMonth, by6);
                break;
            }
            case 16: {
                this.obj = VietnameseCalendar.of(by3, by4, eastAsianMonth, by6);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

