/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.calendar.IndianCalendar;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum IndianMonth implements ChronoCondition<IndianCalendar>
{
    CHAITRA,
    VAISHAKHA,
    JYESHTHA,
    ASHADHA,
    SHRAVANA,
    BHAADRA,
    ASHWIN,
    KARTIKA,
    AGRAHAYANA,
    PAUSHA,
    MAGHA,
    PHALGUNA;

    private static final IndianMonth[] ENUMS;

    public static IndianMonth valueOf(int n2) {
        if (n2 < 1 || n2 > 12) {
            throw new IllegalArgumentException("Out of range: " + n2);
        }
        return ENUMS[n2 - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance("indian", locale);
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    @Override
    public boolean test(IndianCalendar indianCalendar) {
        return indianCalendar.getMonth() == this;
    }

    public IndianMonth roll(int n2) {
        return IndianMonth.valueOf((this.ordinal() + (n2 % 12 + 12)) % 12 + 1);
    }

    static {
        ENUMS = IndianMonth.values();
    }
}

