/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import java.util.Optional;
import net.time4j.GeneralTimestamp;
import net.time4j.PlainTime;
import net.time4j.Weekday;
import net.time4j.base.MathUtils;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.CyclicYear;
import net.time4j.calendar.EastAsianCS;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.EastAsianST;
import net.time4j.calendar.EastAsianYear;
import net.time4j.calendar.SexagesimalName;
import net.time4j.calendar.SolarTerm;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ElementRule;
import net.time4j.engine.EpochDays;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.UnitRule;
import net.time4j.format.CalendarType;

public abstract class EastAsianCalendar<U, D extends EastAsianCalendar<U, D>>
extends Calendrical<U, D> {
    static final int DAY_OF_MONTH_INDEX = 0;
    static final int DAY_OF_YEAR_INDEX = 1;
    static final int MONTH_AS_ORDINAL_INDEX = 2;
    static final int CYCLE_INDEX = 3;
    static final int UNIT_CYCLES = 0;
    static final int UNIT_YEARS = 1;
    static final int UNIT_MONTHS = 2;
    static final int UNIT_WEEKS = 3;
    static final int UNIT_DAYS = 4;
    private final transient int cycle;
    private final transient int yearOfCycle;
    private final transient EastAsianMonth month;
    private final transient int dayOfMonth;
    private final transient long utcDays;
    private final transient int leapMonth;

    EastAsianCalendar(int n2, int n3, EastAsianMonth eastAsianMonth, int n4, long l2) {
        this.cycle = n2;
        this.yearOfCycle = n3;
        this.month = eastAsianMonth;
        this.dayOfMonth = n4;
        this.utcDays = l2;
        this.leapMonth = this.getCalendarSystem().getLeapMonth(n2, n3);
    }

    public CyclicYear getYear() {
        return CyclicYear.of(this.yearOfCycle);
    }

    public SolarTerm getSolarTerm() {
        return EastAsianST.getInstance().getValue((EastAsianCalendar)this.getContext());
    }

    public EastAsianMonth getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public Weekday getDayOfWeek() {
        return Weekday.valueOf(MathUtils.floorModulo(this.utcDays + 5L, 7) + 1);
    }

    public int getDayOfYear() {
        return (int)(this.utcDays - this.getCalendarSystem().newYear(this.cycle, this.yearOfCycle) + 1L);
    }

    public SexagesimalName getSexagesimalMonth() {
        long l2;
        SolarTerm solarTerm = this.getSolarTerm();
        int n2 = MathUtils.floorModulo(solarTerm.getIndex() + 1, 12);
        SexagesimalName.Branch branch = SexagesimalName.Branch.values()[n2];
        int n3 = EastAsianYear.forGregorian(this.get(CommonElements.RELATED_GREGORIAN_YEAR)).getElapsedCyclicYears();
        if (n2 <= 2 && this.utcDays >= (l2 = SolarTerm.MINOR_11_DAXUE_255.onOrAfter((EastAsianCalendar)this.minus(CalendarDays.of(this.utcDays - this.newYearUTC(0)))).getDaysSinceEpochUTC()) && this.utcDays < this.newYearUTC(1)) {
            ++n3;
        }
        int n4 = MathUtils.floorModulo(12 * (n3 - 1) + n2 + 2, 10);
        SexagesimalName.Stem stem = SexagesimalName.Stem.values()[n4];
        return SexagesimalName.of(stem, branch);
    }

    public SexagesimalName getSexagesimalDay() {
        int n2 = MathUtils.floorModulo(EpochDays.RATA_DIE.transform(this.utcDays, EpochDays.UTC) - 45L, 60);
        if (n2 == 0) {
            n2 = 60;
        }
        return SexagesimalName.of(n2);
    }

    public boolean isLeapYear() {
        return this.leapMonth > 0;
    }

    public Optional<EastAsianMonth> findLeapMonth() {
        int n2 = this.getCalendarSystem().getLeapMonth(this.getCycle(), this.getYear().getNumber());
        return n2 == 0 ? Optional.empty() : Optional.of(EastAsianMonth.valueOf(n2).withLeap());
    }

    public D withBeginOfNextLeapMonth() {
        Object object = (EastAsianCalendar)this.getContext();
        EastAsianCS<D> eastAsianCS = ((EastAsianCalendar)object).getCalendarSystem();
        int n2 = ((EastAsianCalendar)object).getCycle();
        int n3 = ((EastAsianCalendar)object).getYear().getNumber();
        while (true) {
            Optional<EastAsianMonth> optional;
            if ((optional = ((EastAsianCalendar)object).findLeapMonth()).isPresent() && ((EastAsianCalendar)object).getMonth().compareTo(optional.get()) < 0) {
                long l2 = eastAsianCS.transform(n2, n3, optional.get(), 1);
                return (D)eastAsianCS.transform(l2);
            }
            if (++n3 > 60) {
                n3 = 1;
                ++n2;
            }
            object = eastAsianCS.transform(eastAsianCS.transform(n2, n3, EastAsianMonth.valueOf(1), 1));
        }
    }

    public int lengthOfMonth() {
        long l2 = this.getCalendarSystem().newMoonOnOrAfter(this.utcDays + 1L);
        return (int)((long)this.dayOfMonth + l2 - this.utcDays - 1L);
    }

    public int lengthOfYear() {
        int n2 = this.cycle;
        int n3 = this.yearOfCycle;
        if (++n3 > 60) {
            n3 = 1;
            ++n2;
        }
        long l2 = this.getCalendarSystem().newYear(this.cycle, this.yearOfCycle);
        long l3 = this.getCalendarSystem().newYear(n2, n3);
        return (int)(l3 - l2);
    }

    public GeneralTimestamp<D> at(PlainTime plainTime) {
        return GeneralTimestamp.of((EastAsianCalendar)this.getContext(), plainTime);
    }

    public GeneralTimestamp<D> atTime(int n2, int n3) {
        return this.at(PlainTime.of(n2, n3));
    }

    @Override
    public long getDaysSinceEpochUTC() {
        return this.utcDays;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() == object.getClass()) {
            EastAsianCalendar eastAsianCalendar = (EastAsianCalendar)object;
            return this.cycle == eastAsianCalendar.cycle && this.yearOfCycle == eastAsianCalendar.yearOfCycle && this.dayOfMonth == eastAsianCalendar.dayOfMonth && this.month.equals(eastAsianCalendar.month) && this.utcDays == eastAsianCalendar.utcDays;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.utcDays);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getClass().getAnnotation(CalendarType.class).value();
        stringBuilder.append(string.equals("dangi") ? "korean" : string);
        stringBuilder.append('[');
        stringBuilder.append(this.getYear().getDisplayName(Locale.ROOT));
        stringBuilder.append('(');
        stringBuilder.append(this.getInt(CommonElements.RELATED_GREGORIAN_YEAR));
        stringBuilder.append(")-");
        stringBuilder.append(this.month.toString());
        stringBuilder.append('-');
        if (this.dayOfMonth < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.dayOfMonth);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getCycleRule(ChronoElement<?> chronoElement) {
        return new IntegerElementRule(3, chronoElement);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, CyclicYear> getYearOfCycleRule(ChronoElement<?> chronoElement) {
        return new CyclicYearRule(chronoElement, false);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, CyclicYear> getVietYearOfCycleRule(ChronoElement<?> chronoElement) {
        return new CyclicYearRule(chronoElement, true);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, EastAsianMonth> getMonthOfYearRule(ChronoElement<?> chronoElement) {
        return new MonthRule(chronoElement);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getMonthAsOrdinalRule(ChronoElement<?> chronoElement) {
        return new IntegerElementRule(2, chronoElement);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getDayOfMonthRule() {
        return new IntegerElementRule(0, null);
    }

    static <D extends EastAsianCalendar<?, D>> ElementRule<D, Integer> getDayOfYearRule() {
        return new IntegerElementRule(1, null);
    }

    static <D extends EastAsianCalendar<?, D>> UnitRule<D> getUnitRule(int n2) {
        return new EastAsianUnitRule(n2);
    }

    int getCycle() {
        return this.cycle;
    }

    int getLeapMonth() {
        return this.leapMonth;
    }

    abstract EastAsianCS<D> getCalendarSystem();

    private long newYearUTC(int n2) {
        return this.getCalendarSystem().newYear(this.cycle, this.yearOfCycle + n2);
    }

    private static class IntegerElementRule<D extends EastAsianCalendar<?, D>>
    implements IntElementRule<D> {
        private final ChronoElement<?> child;
        private final int index;

        private IntegerElementRule(int n2, ChronoElement<?> chronoElement) {
            this.index = n2;
            this.child = chronoElement;
        }

        @Override
        public int getInt(D d2) {
            switch (this.index) {
                case 0: {
                    return ((EastAsianCalendar)d2).getDayOfMonth();
                }
                case 1: {
                    return ((EastAsianCalendar)d2).getDayOfYear();
                }
                case 2: {
                    int n2 = ((EastAsianCalendar)d2).getMonth().getNumber();
                    int n3 = ((EastAsianCalendar)d2).getLeapMonth();
                    if (n3 > 0 && n3 < n2 || ((EastAsianCalendar)d2).getMonth().isLeap()) {
                        ++n2;
                    }
                    return n2;
                }
                case 3: {
                    return ((EastAsianCalendar)d2).getCycle();
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public boolean isValid(D d2, int n2) {
            if (n2 < 1) {
                return false;
            }
            if (this.index == 0) {
                if (n2 > 30) {
                    return false;
                }
                if (n2 == 30) {
                    return ((EastAsianCalendar)d2).lengthOfMonth() == 30;
                }
                return true;
            }
            if (this.index == 1) {
                return n2 <= ((EastAsianCalendar)d2).lengthOfYear();
            }
            if (this.index == 2) {
                return n2 <= 12 || n2 == 13 && ((EastAsianCalendar)d2).getLeapMonth() > 0;
            }
            if (this.index == 3) {
                EastAsianCS eastAsianCS = ((EastAsianCalendar)d2).getCalendarSystem();
                int n3 = ((EastAsianCalendar)eastAsianCS.transform(eastAsianCS.getMinimumSinceUTC())).getCycle();
                int n4 = ((EastAsianCalendar)eastAsianCS.transform(eastAsianCS.getMaximumSinceUTC())).getCycle();
                return n2 >= n3 && n2 <= n4;
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public D withValue(D d2, int n2, boolean bl2) {
            switch (this.index) {
                case 0: {
                    if (bl2) {
                        long l2 = ((EastAsianCalendar)d2).getDaysSinceEpochUTC() + (long)n2 - (long)((EastAsianCalendar)d2).getDayOfMonth();
                        return (D)((EastAsianCalendar)d2).getCalendarSystem().transform(l2);
                    }
                    if (n2 < 1 || n2 > 30 || n2 == 30 && ((EastAsianCalendar)d2).lengthOfMonth() < 30) {
                        throw new IllegalArgumentException("Day of month out of range: " + n2);
                    }
                    long l3 = ((EastAsianCalendar)d2).getDaysSinceEpochUTC() + (long)n2 - (long)((EastAsianCalendar)d2).getDayOfMonth();
                    return ((EastAsianCalendar)d2).getCalendarSystem().create(((EastAsianCalendar)d2).getCycle(), ((EastAsianCalendar)d2).getYear().getNumber(), ((EastAsianCalendar)d2).getMonth(), n2, l3);
                }
                case 1: {
                    if (!(bl2 || n2 >= 1 && n2 <= ((EastAsianCalendar)d2).lengthOfYear())) {
                        throw new IllegalArgumentException("Day of year out of range: " + n2);
                    }
                    long l4 = ((EastAsianCalendar)d2).getDaysSinceEpochUTC() + (long)n2 - (long)((EastAsianCalendar)d2).getDayOfYear();
                    return (D)((EastAsianCalendar)d2).getCalendarSystem().transform(l4);
                }
                case 2: {
                    if (this.isValid(d2, n2)) {
                        int n3 = ((EastAsianCalendar)d2).getLeapMonth();
                        boolean bl3 = false;
                        if (n3 > 0 && n3 < n2) {
                            if (n2 == n3 + 1) {
                                bl3 = true;
                            }
                            --n2;
                        }
                        EastAsianMonth eastAsianMonth = EastAsianMonth.valueOf(n2);
                        if (bl3) {
                            eastAsianMonth = eastAsianMonth.withLeap();
                        }
                        return MonthRule.withMonth(d2, eastAsianMonth);
                    }
                    throw new IllegalArgumentException("Ordinal month out of range: " + n2);
                }
                case 3: {
                    if (this.isValid(d2, n2)) {
                        int n4 = n2 - ((EastAsianCalendar)d2).getCycle();
                        UnitRule unitRule = EastAsianCalendar.getUnitRule(0);
                        return (D)((EastAsianCalendar)unitRule.addTo(d2, n4));
                    }
                    throw new IllegalArgumentException("Sexagesimal cycle out of range: " + n2);
                }
            }
            throw new UnsupportedOperationException("Unknown element index: " + this.index);
        }

        @Override
        public Integer getValue(D d2) {
            return this.getInt(d2);
        }

        @Override
        public Integer getMinimum(D d2) {
            if (this.index == 3) {
                EastAsianCS eastAsianCS = ((EastAsianCalendar)d2).getCalendarSystem();
                return ((EastAsianCalendar)eastAsianCS.transform(eastAsianCS.getMinimumSinceUTC())).getCycle();
            }
            return 1;
        }

        @Override
        public Integer getMaximum(D d2) {
            int n2;
            switch (this.index) {
                case 0: {
                    n2 = ((EastAsianCalendar)d2).lengthOfMonth();
                    break;
                }
                case 1: {
                    n2 = ((EastAsianCalendar)d2).lengthOfYear();
                    break;
                }
                case 2: {
                    n2 = ((EastAsianCalendar)d2).isLeapYear() ? 13 : 12;
                    break;
                }
                case 3: {
                    EastAsianCS eastAsianCS = ((EastAsianCalendar)d2).getCalendarSystem();
                    n2 = ((EastAsianCalendar)eastAsianCS.transform(eastAsianCS.getMaximumSinceUTC())).getCycle();
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown element index: " + this.index);
                }
            }
            return n2;
        }

        @Override
        public boolean isValid(D d2, Integer n2) {
            return n2 != null && this.isValid(d2, (int)n2);
        }

        @Override
        public D withValue(D d2, Integer n2, boolean bl2) {
            if (n2 == null) {
                throw new IllegalArgumentException("Missing element value.");
            }
            return this.withValue(d2, (int)n2, bl2);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(D d2) {
            return this.child;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(D d2) {
            return this.child;
        }
    }

    private static class CyclicYearRule<D extends EastAsianCalendar<?, D>>
    implements ElementRule<D, CyclicYear> {
        private final ChronoElement<?> child;
        private final boolean vietnam;

        private CyclicYearRule(ChronoElement<?> chronoElement, boolean bl2) {
            this.child = chronoElement;
            this.vietnam = bl2;
        }

        @Override
        public CyclicYear getValue(D d2) {
            return ((EastAsianCalendar)d2).getYear();
        }

        @Override
        public CyclicYear getMinimum(D d2) {
            if (this.vietnam) {
                return ((EastAsianCalendar)d2).getCycle() == 75 ? CyclicYear.of(10) : CyclicYear.of(1);
            }
            return ((EastAsianCalendar)d2).getCycle() == 72 ? CyclicYear.of(22) : CyclicYear.of(1);
        }

        @Override
        public CyclicYear getMaximum(D d2) {
            return ((EastAsianCalendar)d2).getCycle() == 94 ? CyclicYear.of(56) : CyclicYear.of(60);
        }

        @Override
        public boolean isValid(D d2, CyclicYear cyclicYear) {
            CyclicYear cyclicYear2 = this.getMinimum(d2);
            CyclicYear cyclicYear3 = this.getMaximum(d2);
            return cyclicYear != null && cyclicYear2.compareTo(cyclicYear) <= 0 && cyclicYear3.compareTo(cyclicYear) >= 0;
        }

        @Override
        public D withValue(D d2, CyclicYear cyclicYear, boolean bl2) {
            if (this.isValid(d2, cyclicYear)) {
                EastAsianCS eastAsianCS = ((EastAsianCalendar)d2).getCalendarSystem();
                int n2 = ((EastAsianCalendar)d2).getDayOfMonth();
                EastAsianMonth eastAsianMonth = ((EastAsianCalendar)d2).getMonth();
                int n3 = cyclicYear.getNumber();
                int n4 = ((EastAsianCalendar)d2).getCycle();
                if (eastAsianMonth.isLeap() && eastAsianMonth.getNumber() != eastAsianCS.getLeapMonth(n4, n3)) {
                    eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                }
                if (n2 <= 29) {
                    long l2 = eastAsianCS.transform(n4, n3, eastAsianMonth, n2);
                    return eastAsianCS.create(n4, n3, eastAsianMonth, n2, l2);
                }
                long l3 = eastAsianCS.transform(n4, n3, eastAsianMonth, 1);
                Object object = eastAsianCS.transform(l3);
                n2 = Math.min(n2, ((EastAsianCalendar)object).lengthOfMonth());
                return eastAsianCS.create(n4, n3, eastAsianMonth, n2, l3 + (long)n2 - 1L);
            }
            throw new IllegalArgumentException("Invalid cyclic year: " + cyclicYear);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(D d2) {
            return this.child;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(D d2) {
            return this.child;
        }
    }

    private static class MonthRule<D extends EastAsianCalendar<?, D>>
    implements ElementRule<D, EastAsianMonth> {
        private final ChronoElement<?> child;

        private MonthRule(ChronoElement<?> chronoElement) {
            this.child = chronoElement;
        }

        @Override
        public EastAsianMonth getValue(D d2) {
            return ((EastAsianCalendar)d2).getMonth();
        }

        @Override
        public EastAsianMonth getMinimum(D d2) {
            return EastAsianMonth.valueOf(1);
        }

        @Override
        public EastAsianMonth getMaximum(D d2) {
            return EastAsianMonth.valueOf(12);
        }

        @Override
        public boolean isValid(D d2, EastAsianMonth eastAsianMonth) {
            return eastAsianMonth != null && (!eastAsianMonth.isLeap() || eastAsianMonth.getNumber() == ((EastAsianCalendar)d2).getLeapMonth());
        }

        @Override
        public D withValue(D d2, EastAsianMonth eastAsianMonth, boolean bl2) {
            if (this.isValid(d2, eastAsianMonth)) {
                return MonthRule.withMonth(d2, eastAsianMonth);
            }
            throw new IllegalArgumentException("Invalid month: " + eastAsianMonth);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(D d2) {
            return this.child;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(D d2) {
            return this.child;
        }

        static <D extends EastAsianCalendar<?, D>> D withMonth(D d2, EastAsianMonth eastAsianMonth) {
            EastAsianCS<D> eastAsianCS = d2.getCalendarSystem();
            int n2 = d2.getDayOfMonth();
            int n3 = d2.getYear().getNumber();
            if (n2 <= 29) {
                long l2 = eastAsianCS.transform(d2.getCycle(), n3, eastAsianMonth, n2);
                return eastAsianCS.create(d2.getCycle(), n3, eastAsianMonth, n2, l2);
            }
            long l3 = eastAsianCS.transform(d2.getCycle(), n3, eastAsianMonth, 1);
            Object object = eastAsianCS.transform(l3);
            n2 = Math.min(n2, ((EastAsianCalendar)object).lengthOfMonth());
            return eastAsianCS.create(d2.getCycle(), n3, eastAsianMonth, n2, l3 + (long)n2 - 1L);
        }
    }

    private static class EastAsianUnitRule<D extends EastAsianCalendar<?, D>>
    implements UnitRule<D> {
        private final int index;

        EastAsianUnitRule(int n2) {
            this.index = n2;
        }

        @Override
        public D addTo(D d2, long l2) {
            EastAsianCS eastAsianCS = ((EastAsianCalendar)d2).getCalendarSystem();
            int n2 = ((EastAsianCalendar)d2).getDayOfMonth();
            int n3 = ((EastAsianCalendar)d2).getCycle();
            int n4 = ((EastAsianCalendar)d2).getYear().getNumber();
            EastAsianMonth eastAsianMonth = ((EastAsianCalendar)d2).getMonth();
            switch (this.index) {
                case 0: {
                    l2 = MathUtils.safeMultiply(l2, 60L);
                }
                case 1: {
                    long l3 = MathUtils.safeAdd((long)(n3 * 60 + n4 - 1), l2);
                    n3 = MathUtils.safeCast(MathUtils.floorDivide(l3, 60));
                    n4 = MathUtils.floorModulo(l3, 60) + 1;
                    if (eastAsianMonth.isLeap() && eastAsianCS.getLeapMonth(n3, n4) != eastAsianMonth.getNumber()) {
                        eastAsianMonth = EastAsianMonth.valueOf(eastAsianMonth.getNumber());
                    }
                    return EastAsianUnitRule.create(n3, n4, eastAsianMonth, n2, eastAsianCS);
                }
                case 2: {
                    EastAsianUnitRule.checkAmountOfMonths(l2);
                    int n5 = l2 > 0L ? 1 : -1;
                    int n6 = eastAsianMonth.getNumber();
                    boolean bl2 = eastAsianMonth.isLeap();
                    int n7 = eastAsianCS.getLeapMonth(n3, n4);
                    while (l2 != 0L) {
                        if (bl2) {
                            bl2 = false;
                            if (n5 == 1) {
                                ++n6;
                            }
                        } else if (n5 == 1 && n7 == n6) {
                            bl2 = true;
                        } else if (n5 == -1 && n7 == n6 - 1) {
                            bl2 = true;
                            --n6;
                        } else {
                            n6 += n5;
                        }
                        if (!bl2) {
                            if (n6 == 13) {
                                n6 = 1;
                                if (++n4 == 61) {
                                    n4 = 1;
                                    ++n3;
                                }
                                n7 = eastAsianCS.getLeapMonth(n3, n4);
                            } else if (n6 == 0) {
                                n6 = 12;
                                if (--n4 == 0) {
                                    n4 = 60;
                                    --n3;
                                }
                                n7 = eastAsianCS.getLeapMonth(n3, n4);
                            }
                        }
                        l2 -= (long)n5;
                    }
                    eastAsianMonth = EastAsianMonth.valueOf(n6);
                    if (bl2) {
                        eastAsianMonth = eastAsianMonth.withLeap();
                    }
                    return EastAsianUnitRule.create(n3, n4, eastAsianMonth, n2, eastAsianCS);
                }
                case 3: {
                    l2 = MathUtils.safeMultiply(l2, 7L);
                }
                case 4: {
                    long l4 = MathUtils.safeAdd(((EastAsianCalendar)d2).getDaysSinceEpochUTC(), l2);
                    return (D)eastAsianCS.transform(l4);
                }
            }
            throw new UnsupportedOperationException();
        }

        @Override
        public long between(D d2, D d3) {
            return EastAsianUnitRule.between(d2, d3, this.index);
        }

        private static <D extends EastAsianCalendar<?, D>> long between(D d2, D d3, int n2) {
            EastAsianCS<D> eastAsianCS = d2.getCalendarSystem();
            switch (n2) {
                case 0: {
                    return EastAsianUnitRule.between(d2, d3, 1) / 60L;
                }
                case 1: {
                    int n3;
                    int n4 = d3.getCycle() * 60 + d3.getYear().getNumber() - d2.getCycle() * 60 - d2.getYear().getNumber();
                    if (n4 > 0) {
                        int n5 = d2.getMonth().compareTo(d3.getMonth());
                        if (n5 > 0 || n5 == 0 && d2.getDayOfMonth() > d3.getDayOfMonth()) {
                            --n4;
                        }
                    } else if (n4 < 0 && ((n3 = d2.getMonth().compareTo(d3.getMonth())) < 0 || n3 == 0 && d2.getDayOfMonth() < d3.getDayOfMonth())) {
                        ++n4;
                    }
                    return n4;
                }
                case 2: {
                    D d4 = d2;
                    D d5 = d3;
                    boolean bl2 = false;
                    if (d2.isAfter(d3)) {
                        d4 = d3;
                        d5 = d2;
                        bl2 = true;
                    }
                    int n6 = d4.getCycle();
                    int n7 = d4.getYear().getNumber();
                    EastAsianMonth eastAsianMonth = d4.getMonth();
                    int n8 = eastAsianMonth.getNumber();
                    boolean bl3 = eastAsianMonth.isLeap();
                    int n9 = eastAsianCS.getLeapMonth(n6, n7);
                    int n10 = 0;
                    while (n6 != d5.getCycle() || n7 != d5.getYear().getNumber() || !eastAsianMonth.equals(d5.getMonth())) {
                        if (bl3) {
                            bl3 = false;
                            ++n8;
                        } else if (n9 == n8) {
                            bl3 = true;
                        } else {
                            ++n8;
                        }
                        if (!bl3) {
                            if (n8 == 13) {
                                n8 = 1;
                                if (++n7 == 61) {
                                    n7 = 1;
                                    ++n6;
                                }
                                n9 = eastAsianCS.getLeapMonth(n6, n7);
                            } else if (n8 == 0) {
                                n8 = 12;
                                if (--n7 == 0) {
                                    n7 = 60;
                                    --n6;
                                }
                                n9 = eastAsianCS.getLeapMonth(n6, n7);
                            }
                        }
                        eastAsianMonth = EastAsianMonth.valueOf(n8);
                        if (bl3) {
                            eastAsianMonth = eastAsianMonth.withLeap();
                        }
                        ++n10;
                    }
                    if (n10 > 0 && d4.getDayOfMonth() > d5.getDayOfMonth()) {
                        --n10;
                    }
                    return bl2 ? -n10 : n10;
                }
                case 3: {
                    return (d3.getDaysSinceEpochUTC() - d2.getDaysSinceEpochUTC()) / 7L;
                }
                case 4: {
                    return d3.getDaysSinceEpochUTC() - d2.getDaysSinceEpochUTC();
                }
            }
            throw new UnsupportedOperationException();
        }

        private static <D extends EastAsianCalendar<?, D>> D create(int n2, int n3, EastAsianMonth eastAsianMonth, int n4, EastAsianCS<D> eastAsianCS) {
            if (n4 <= 29) {
                long l2 = eastAsianCS.transform(n2, n3, eastAsianMonth, n4);
                return eastAsianCS.create(n2, n3, eastAsianMonth, n4, l2);
            }
            long l3 = eastAsianCS.transform(n2, n3, eastAsianMonth, 1);
            Object object = eastAsianCS.transform(l3);
            n4 = Math.min(n4, ((EastAsianCalendar)object).lengthOfMonth());
            return eastAsianCS.create(n2, n3, eastAsianMonth, n4, l3 + (long)n4 - 1L);
        }

        private static void checkAmountOfMonths(long l2) {
            if (l2 > 1200L || l2 < -1200L) {
                throw new ArithmeticException("Month arithmetic limited to delta not greater than 1200.");
            }
        }
    }
}

