/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoFunction;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

class ZonalQuery<V>
implements ChronoFunction<Moment, V> {
    private final ChronoElement<V> element;
    private final Timezone tz;
    private final ZonalOffset offset;

    ZonalQuery(ChronoElement<V> chronoElement, Timezone timezone) {
        if (timezone == null) {
            throw new NullPointerException("Missing timezone.");
        }
        this.element = chronoElement;
        this.tz = timezone;
        this.offset = null;
    }

    ZonalQuery(ChronoElement<V> chronoElement, ZonalOffset zonalOffset) {
        if (zonalOffset == null) {
            throw new NullPointerException("Missing timezone offset.");
        }
        this.element = chronoElement;
        this.tz = null;
        this.offset = zonalOffset;
    }

    @Override
    public V apply(Moment moment) {
        ZonalOffset zonalOffset;
        ZonalOffset zonalOffset2 = zonalOffset = this.offset == null ? this.tz.getOffset(moment) : this.offset;
        if (this.element == PlainTime.SECOND_OF_MINUTE && moment.isLeapSecond() && zonalOffset.getFractionalAmount() == 0 && zonalOffset.getAbsoluteSeconds() % 60 == 0) {
            return this.element.getType().cast(60);
        }
        return PlainTimestamp.from(moment, zonalOffset).get(this.element);
    }
}

