/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.SystemClock;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class ZonalClock {
    private static final ZonalClock SYSTEM = new ZonalClock();
    private final TimeSource<?> timeSource;
    private final Timezone timezone;

    public ZonalClock(TimeSource<?> timeSource, TZID tZID) {
        this(timeSource, Timezone.of(tZID));
    }

    public ZonalClock(TimeSource<?> timeSource, String string) {
        this(timeSource, Timezone.of(string));
    }

    public ZonalClock(TimeSource<?> timeSource, Timezone timezone) {
        if (timeSource == null) {
            throw new NullPointerException("Missing time source.");
        }
        if (timezone == null) {
            throw new NullPointerException("Missing timezone.");
        }
        this.timeSource = timeSource;
        this.timezone = timezone;
    }

    private ZonalClock() {
        this.timeSource = SystemClock.INSTANCE;
        this.timezone = null;
    }

    public PlainDate today() {
        Object obj = this.timeSource.currentTime();
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        return PlainDate.from(obj, timezone.getOffset((UnixTime)obj));
    }

    public PlainTimestamp now() {
        Object obj = this.timeSource.currentTime();
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        return PlainTimestamp.from(obj, timezone.getOffset((UnixTime)obj));
    }

    public <T extends ChronoEntity<T>> T now(Chronology<T> chronology) {
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        Attributes attributes = new Attributes.Builder().setTimezone(timezone.getID()).build();
        ChronoEntity chronoEntity = (ChronoEntity)chronology.createFrom(this.timeSource, attributes);
        if (chronoEntity == null) {
            Class<T> clazz = chronology.getChronoType();
            if (CalendarVariant.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("Calendar variant required: " + clazz.getName());
            }
            throw new IllegalArgumentException("Insufficient data: " + clazz.getName());
        }
        return (T)chronoEntity;
    }

    public <C extends CalendarVariant<C>> GeneralTimestamp<C> now(CalendarFamily<C> calendarFamily, String string, StartOfDay startOfDay) {
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        Moment moment = Moment.from(this.timeSource.currentTime());
        return moment.toGeneralTimestamp(calendarFamily, string, timezone.getID(), startOfDay);
    }

    public <C extends CalendarVariant<C>> GeneralTimestamp<C> now(CalendarFamily<C> calendarFamily, VariantSource variantSource, StartOfDay startOfDay) {
        return this.now(calendarFamily, variantSource.getVariant(), startOfDay);
    }

    public TimeSource<?> getSource() {
        return this.timeSource;
    }

    public TZID getTimezone() {
        Timezone timezone = this.timezone == null ? Timezone.ofSystem() : this.timezone;
        return timezone.getID();
    }

    static ZonalClock ofSystem() {
        return SYSTEM;
    }
}

