/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ProportionalElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;

final class RoundingOperator<T extends ChronoEntity<T>>
implements ChronoOperator<T> {
    private final ProportionalElement<?, T> element;
    private final Boolean up;
    private final double stepwidth;
    private final boolean longBased;

    RoundingOperator(ProportionalElement<?, T> proportionalElement, Boolean bl2, int n2) {
        this.element = proportionalElement;
        this.up = bl2;
        this.stepwidth = n2;
        this.longBased = proportionalElement.getType().equals(Long.class);
    }

    @Override
    public T apply(T t2) {
        double d2;
        double d3 = ((Number)((ChronoEntity)t2).get(this.element)).doubleValue();
        if (this.up == null) {
            double d4 = Math.ceil(d3 / this.stepwidth) * this.stepwidth;
            double d5 = Math.floor(d3 / this.stepwidth) * this.stepwidth;
            d2 = d3 - d5 < d4 - d3 ? d5 : d4;
        } else {
            d2 = this.up != false ? Math.ceil(d3 / this.stepwidth) * this.stepwidth : Math.floor(d3 / this.stepwidth) * this.stepwidth;
        }
        Number number = this.longBased ? (Number)((long)d2) : (Number)((int)d2);
        return ((ChronoEntity)t2).with(RoundingOperator.lenient(this.element, number));
    }

    private static <V extends Number, T extends ChronoEntity<T>> ChronoOperator<T> lenient(ProportionalElement<V, T> proportionalElement, Number number) {
        return proportionalElement.setLenient((Number)proportionalElement.getType().cast(number));
    }
}

