/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import net.time4j.SI;
import net.time4j.SPX;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.TimeSpanFormatter;
import net.time4j.scale.TimeScale;
import net.time4j.scale.UniversalTime;

public final class MachineTime<U>
implements TimeSpan<U>,
Comparable<MachineTime<U>>,
Serializable {
    private static final int MRD = 1000000000;
    private static final MachineTime<TimeUnit> POSIX_ZERO = new MachineTime(0L, 0, TimeScale.POSIX);
    private static final MachineTime<SI> UTC_ZERO = new MachineTime(0L, 0, TimeScale.UTC);
    public static final TimeMetric<TimeUnit, MachineTime<TimeUnit>> ON_POSIX_SCALE = new Metric<TimeUnit>(TimeScale.POSIX);
    public static final TimeMetric<TimeUnit, MachineTime<SI>> ON_UTC_SCALE = new Metric<SI>(TimeScale.UTC);
    private static final long serialVersionUID = -4150291820807606229L;
    private final transient long seconds;
    private final transient int nanos;
    private final transient TimeScale scale;

    private MachineTime(long l2, int n2, TimeScale timeScale) {
        while (n2 < 0) {
            n2 += 1000000000;
            l2 = Math.subtractExact(l2, 1L);
        }
        while (n2 >= 1000000000) {
            n2 -= 1000000000;
            l2 = Math.addExact(l2, 1L);
        }
        if (l2 < 0L && n2 > 0) {
            ++l2;
            n2 -= 1000000000;
        }
        this.seconds = l2;
        this.nanos = n2;
        this.scale = timeScale;
    }

    public static MachineTime<TimeUnit> of(long l2, TimeUnit timeUnit) {
        if (timeUnit.compareTo(TimeUnit.SECONDS) >= 0) {
            long l3 = Math.multiplyExact(l2, TimeUnit.SECONDS.convert(1L, timeUnit));
            return MachineTime.ofPosixUnits(l3, 0);
        }
        long l4 = Math.multiplyExact(l2, TimeUnit.NANOSECONDS.convert(1L, timeUnit));
        long l5 = Math.floorDiv(l4, 1000000000L);
        int n2 = (int)Math.floorMod(l4, 1000000000L);
        return MachineTime.ofPosixUnits(l5, n2);
    }

    public static MachineTime<SI> of(long l2, SI sI) {
        switch (sI) {
            case SECONDS: {
                return MachineTime.ofSIUnits(l2, 0);
            }
            case NANOSECONDS: {
                long l3 = Math.floorDiv(l2, 1000000000L);
                int n2 = (int)Math.floorMod(l2, 1000000000L);
                return MachineTime.ofSIUnits(l3, n2);
            }
        }
        throw new UnsupportedOperationException(sI.name());
    }

    public static MachineTime<TimeUnit> ofPosixUnits(long l2, int n2) {
        if (l2 == 0L && n2 == 0) {
            return POSIX_ZERO;
        }
        return new MachineTime<TimeUnit>(l2, n2, TimeScale.POSIX);
    }

    public static MachineTime<SI> ofSIUnits(long l2, int n2) {
        if (l2 == 0L && n2 == 0) {
            return UTC_ZERO;
        }
        return new MachineTime<SI>(l2, n2, TimeScale.UTC);
    }

    public static MachineTime<TimeUnit> ofPosixSeconds(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Invalid value: " + d2);
        }
        long l2 = (long)Math.floor(d2);
        int n2 = (int)((d2 - (double)l2) * 1.0E9);
        return MachineTime.ofPosixUnits(l2, n2);
    }

    public static MachineTime<TimeUnit> ofPosixSeconds(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, RoundingMode.FLOOR);
        int n2 = bigDecimal.subtract(bigDecimal2).multiply(BigDecimal.valueOf(1000000000L)).setScale(0, RoundingMode.DOWN).intValueExact();
        return MachineTime.ofPosixUnits(bigDecimal2.longValueExact(), n2);
    }

    public static MachineTime<SI> ofSISeconds(double d2) {
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Invalid value: " + d2);
        }
        long l2 = (long)Math.floor(d2);
        int n2 = (int)((d2 - (double)l2) * 1.0E9);
        return MachineTime.ofSIUnits(l2, n2);
    }

    public static MachineTime<SI> ofSISeconds(BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.setScale(0, RoundingMode.FLOOR);
        int n2 = bigDecimal.subtract(bigDecimal2).multiply(BigDecimal.valueOf(1000000000L)).setScale(0, RoundingMode.DOWN).intValueExact();
        return MachineTime.ofSIUnits(bigDecimal2.longValueExact(), n2);
    }

    public long getSeconds() {
        long l2 = this.seconds;
        if (this.nanos < 0) {
            --l2;
        }
        return l2;
    }

    public int getFraction() {
        int n2 = this.nanos;
        if (n2 < 0) {
            n2 += 1000000000;
        }
        return n2;
    }

    public TimeScale getScale() {
        return this.scale;
    }

    @Override
    public List<TimeSpan.Item<U>> getTotalLength() {
        Object t2;
        Enum enum_;
        ArrayList arrayList = new ArrayList(2);
        if (this.seconds != 0L) {
            enum_ = this.scale == TimeScale.UTC ? SI.SECONDS : TimeUnit.SECONDS;
            t2 = MachineTime.cast(enum_);
            arrayList.add(TimeSpan.Item.of(Math.abs(this.seconds), t2));
        }
        if (this.nanos != 0) {
            enum_ = this.scale == TimeScale.UTC ? SI.NANOSECONDS : TimeUnit.NANOSECONDS;
            t2 = MachineTime.cast(enum_);
            arrayList.add(TimeSpan.Item.of(Math.abs(this.nanos), t2));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public boolean contains(Object object) {
        if (this.scale == TimeScale.POSIX && TimeUnit.SECONDS.equals(object) || this.scale == TimeScale.UTC && SI.SECONDS.equals(object)) {
            return this.seconds != 0L;
        }
        if (this.scale == TimeScale.POSIX && TimeUnit.NANOSECONDS.equals(object) || this.scale == TimeScale.UTC && SI.NANOSECONDS.equals(object)) {
            return this.nanos != 0;
        }
        return false;
    }

    @Override
    public long getPartialAmount(Object object) {
        if (this.scale == TimeScale.POSIX && TimeUnit.SECONDS.equals(object) || this.scale == TimeScale.UTC && SI.SECONDS.equals(object)) {
            return Math.abs(this.seconds);
        }
        if (this.scale == TimeScale.POSIX && TimeUnit.NANOSECONDS.equals(object) || this.scale == TimeScale.UTC && SI.NANOSECONDS.equals(object)) {
            return Math.abs(this.nanos);
        }
        return 0L;
    }

    @Override
    public boolean isNegative() {
        return this.seconds < 0L || this.nanos < 0;
    }

    @Override
    public boolean isPositive() {
        return this.seconds > 0L || this.nanos > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.seconds == 0L && this.nanos == 0;
    }

    public MachineTime<U> plus(long l2, U u2) {
        long l3 = this.seconds;
        int n2 = this.nanos;
        if (this.scale == TimeScale.POSIX) {
            TimeUnit timeUnit = (TimeUnit)((Object)TimeUnit.class.cast(u2));
            if (timeUnit.compareTo(TimeUnit.SECONDS) >= 0) {
                l3 = Math.addExact(l3, Math.multiplyExact(l2, TimeUnit.SECONDS.convert(1L, timeUnit)));
            } else {
                long l4 = Math.addExact((long)n2, Math.multiplyExact(l2, TimeUnit.NANOSECONDS.convert(1L, timeUnit)));
                l3 = Math.addExact(l3, Math.floorDiv(l4, 1000000000L));
                n2 = (int)Math.floorMod(l4, 1000000000L);
            }
        } else {
            switch ((SI)SI.class.cast(u2)) {
                case SECONDS: {
                    l3 = Math.addExact(l3, l2);
                    break;
                }
                case NANOSECONDS: {
                    long l5 = Math.addExact((long)n2, l2);
                    l3 = Math.addExact(l3, Math.floorDiv(l5, 1000000000L));
                    n2 = (int)Math.floorMod(l5, 1000000000L);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(u2.toString());
                }
            }
        }
        return new MachineTime<U>(l3, n2, this.scale);
    }

    public MachineTime<U> plus(MachineTime<U> machineTime) {
        if (machineTime.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return machineTime;
        }
        long l2 = Math.addExact(this.seconds, machineTime.seconds);
        int n2 = this.nanos + machineTime.nanos;
        return new MachineTime<U>(l2, n2, this.scale);
    }

    public MachineTime<U> minus(long l2, U u2) {
        return this.plus(Math.negateExact(l2), u2);
    }

    public MachineTime<U> minus(MachineTime<U> machineTime) {
        if (machineTime.isEmpty()) {
            return this;
        }
        if (this.isEmpty()) {
            return machineTime.inverse();
        }
        long l2 = Math.subtractExact(this.seconds, machineTime.seconds);
        int n2 = this.nanos - machineTime.nanos;
        return new MachineTime<U>(l2, n2, this.scale);
    }

    public MachineTime<U> abs() {
        if (this.isNegative()) {
            return new MachineTime<U>(Math.negateExact(this.seconds), -this.nanos, this.scale);
        }
        return this;
    }

    public MachineTime<U> inverse() {
        if (this.isEmpty()) {
            return this;
        }
        return new MachineTime<U>(Math.negateExact(this.seconds), -this.nanos, this.scale);
    }

    public MachineTime<U> multipliedBy(long l2) {
        if (l2 == 1L) {
            return this;
        }
        if (l2 == 0L) {
            if (this.scale == TimeScale.POSIX) {
                return (MachineTime)MachineTime.cast(POSIX_ZERO);
            }
            return (MachineTime)MachineTime.cast(UTC_ZERO);
        }
        BigDecimal bigDecimal = this.toBigDecimal().multiply(BigDecimal.valueOf(l2));
        MachineTime<Enum> machineTime = this.scale == TimeScale.POSIX ? MachineTime.ofPosixSeconds(bigDecimal) : MachineTime.ofSISeconds(bigDecimal);
        return (MachineTime)MachineTime.cast(machineTime);
    }

    public MachineTime<U> multipliedBy(double d2) {
        if (d2 == 1.0) {
            return this;
        }
        if (d2 == 0.0) {
            if (this.scale == TimeScale.POSIX) {
                return (MachineTime)MachineTime.cast(POSIX_ZERO);
            }
            return (MachineTime)MachineTime.cast(UTC_ZERO);
        }
        if (Double.isFinite(d2)) {
            double d3 = this.toBigDecimal().doubleValue() * d2;
            MachineTime<Enum> machineTime = this.scale == TimeScale.POSIX ? MachineTime.ofPosixSeconds(d3) : MachineTime.ofSISeconds(d3);
            return (MachineTime)MachineTime.cast(machineTime);
        }
        throw new IllegalArgumentException("Not finite: " + d2);
    }

    public MachineTime<U> dividedBy(long l2, RoundingMode roundingMode) {
        if (l2 == 1L) {
            return this;
        }
        BigDecimal bigDecimal = this.toBigDecimal().setScale(9, RoundingMode.FLOOR).divide(new BigDecimal(l2), roundingMode);
        MachineTime<Enum> machineTime = this.scale == TimeScale.POSIX ? MachineTime.ofPosixSeconds(bigDecimal) : MachineTime.ofSISeconds(bigDecimal);
        return (MachineTime)MachineTime.cast(machineTime);
    }

    @Override
    public <T extends TimePoint<? super U, T>> T addTo(T t2) {
        Enum enum_;
        Enum enum_2;
        if (this.scale == TimeScale.POSIX) {
            enum_2 = TimeUnit.SECONDS;
            enum_ = TimeUnit.NANOSECONDS;
        } else {
            enum_2 = SI.SECONDS;
            enum_ = SI.NANOSECONDS;
        }
        return ((TimePoint)t2.plus(this.seconds, (Enum)enum_2)).plus(this.nanos, (Enum)enum_);
    }

    @Override
    public <T extends TimePoint<? super U, T>> T subtractFrom(T t2) {
        Enum enum_;
        Enum enum_2;
        if (this.scale == TimeScale.POSIX) {
            enum_2 = TimeUnit.SECONDS;
            enum_ = TimeUnit.NANOSECONDS;
        } else {
            enum_2 = SI.SECONDS;
            enum_ = SI.NANOSECONDS;
        }
        return ((TimePoint)t2.minus(this.seconds, (Enum)enum_2)).minus(this.nanos, (Enum)enum_);
    }

    public static Collector<MachineTime<TimeUnit>, ?, MachineTime<TimeUnit>> summingUpPosix() {
        return Collectors.reducing(MachineTime.of(0L, TimeUnit.SECONDS), MachineTime::plus);
    }

    public static Collector<MachineTime<SI>, ?, MachineTime<SI>> summingUpReal() {
        return Collectors.reducing(MachineTime.of(0L, SI.SECONDS), MachineTime::plus);
    }

    public boolean isShorterThan(MachineTime<U> machineTime) {
        return this.abs().compareTo(machineTime.abs()) < 0;
    }

    public boolean isLongerThan(MachineTime<U> machineTime) {
        return this.abs().compareTo(machineTime.abs()) > 0;
    }

    @Override
    public int compareTo(MachineTime<U> machineTime) {
        if (this.scale == machineTime.scale) {
            if (this.seconds < machineTime.seconds) {
                return -1;
            }
            if (this.seconds > machineTime.seconds) {
                return 1;
            }
            return this.nanos - machineTime.nanos;
        }
        throw new ClassCastException("Different time scales.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MachineTime) {
            MachineTime machineTime = (MachineTime)object;
            return this.seconds == machineTime.seconds && this.nanos == machineTime.nanos && this.scale == machineTime.scale;
        }
        return false;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 23 * n2 + (int)(this.seconds ^ this.seconds >>> 32);
        n2 = 23 * n2 + this.nanos;
        n2 = 23 * n2 + this.scale.hashCode();
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.createNumber(stringBuilder);
        stringBuilder.append("s [");
        stringBuilder.append(this.scale.name());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public BigDecimal toBigDecimal() {
        StringBuilder stringBuilder = new StringBuilder();
        this.createNumber(stringBuilder);
        return new BigDecimal(stringBuilder.toString());
    }

    public Duration toTemporalAmount() {
        if (this.scale == TimeScale.POSIX) {
            return Duration.ofSeconds(this.seconds, this.nanos);
        }
        throw new IllegalStateException("Can only convert based on &quot;java.util.concurrent.TimeUnit&quot;: " + this);
    }

    public static MachineTime<TimeUnit> from(Duration duration) {
        return MachineTime.ofPosixUnits(duration.getSeconds(), duration.getNano());
    }

    private void createNumber(StringBuilder stringBuilder) {
        if (this.isNegative()) {
            stringBuilder.append('-');
            stringBuilder.append(Math.abs(this.seconds));
        } else {
            stringBuilder.append(this.seconds);
        }
        if (this.nanos != 0) {
            stringBuilder.append('.');
            String string = String.valueOf(Math.abs(this.nanos));
            for (int i2 = 9 - string.length(); i2 > 0; --i2) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private Object writeReplace() {
        return new SPX(this, 5);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class Metric<U>
    implements TimeMetric<TimeUnit, MachineTime<U>> {
        private final TimeScale scale;

        private Metric(TimeScale timeScale) {
            this.scale = timeScale;
        }

        @Override
        public <T extends TimePoint<? super TimeUnit, T>> MachineTime<U> between(T t2, T t3) {
            int n2;
            long l2;
            if (this.scale == TimeScale.UTC && t2 instanceof UniversalTime) {
                UniversalTime universalTime = (UniversalTime)((Object)t2);
                UniversalTime universalTime2 = (UniversalTime)((Object)t3);
                long l3 = universalTime2.getElapsedTime(TimeScale.UTC);
                long l4 = universalTime.getElapsedTime(TimeScale.UTC);
                if (l3 < 0L || l4 < 0L) {
                    throw new UnsupportedOperationException("Cannot calculate SI-duration before 1972-01-01.");
                }
                l2 = l3 - l4;
                n2 = universalTime2.getNanosecond(TimeScale.UTC) - universalTime.getNanosecond(TimeScale.UTC);
            } else if (t2 instanceof UnixTime) {
                UnixTime unixTime = (UnixTime)((Object)t2);
                UnixTime unixTime2 = (UnixTime)((Object)t3);
                l2 = unixTime2.getPosixTime() - unixTime.getPosixTime();
                n2 = unixTime2.getNanosecond() - unixTime.getNanosecond();
            } else {
                throw new UnsupportedOperationException("Machine time requires objects of type 'UnixTime'.");
            }
            return new MachineTime(l2, n2, this.scale);
        }

        public Metric<U> reversible() {
            return this;
        }
    }

    private static class Normalized
    implements TimeSpan<TimeUnit> {
        private final TimeSpan<? super TimeUnit> duration;
        private final Set<TimeUnit> patternUnits;

        Normalized(TimeSpan<? super TimeUnit> timeSpan, Set<TimeUnit> set) {
            if (timeSpan == null) {
                throw new NullPointerException();
            }
            this.duration = timeSpan;
            this.patternUnits = set;
        }

        @Override
        public List<TimeSpan.Item<TimeUnit>> getTotalLength() {
            throw new AssertionError((Object)"Never called.");
        }

        @Override
        public boolean contains(TimeUnit timeUnit) {
            return true;
        }

        @Override
        public long getPartialAmount(TimeUnit timeUnit) {
            if (timeUnit == TimeUnit.NANOSECONDS) {
                return this.duration.getPartialAmount(TimeUnit.NANOSECONDS);
            }
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            long l5 = this.duration.getPartialAmount(TimeUnit.SECONDS);
            if (this.patternUnits.contains((Object)TimeUnit.DAYS)) {
                l2 = l5 / 86400L;
                l5 -= l2 * 86400L;
            }
            if (this.patternUnits.contains((Object)TimeUnit.HOURS)) {
                l3 = l5 / 3600L;
                l5 -= l3 * 3600L;
            }
            if (this.patternUnits.contains((Object)TimeUnit.MINUTES)) {
                l4 = l5 / 60L;
                l5 -= l4 * 60L;
            }
            switch (timeUnit) {
                case DAYS: {
                    return l2;
                }
                case HOURS: {
                    return l3;
                }
                case MINUTES: {
                    return l4;
                }
                case SECONDS: {
                    return l5;
                }
            }
            throw new AssertionError((Object)"Never called.");
        }

        @Override
        public boolean isNegative() {
            return this.duration.isNegative();
        }

        @Override
        public boolean isPositive() {
            return this.duration.isPositive();
        }

        @Override
        public boolean isEmpty() {
            return this.duration.isEmpty();
        }

        @Override
        public <T extends TimePoint<? super TimeUnit, T>> T addTo(T t2) {
            throw new AssertionError((Object)"Never called.");
        }

        @Override
        public <T extends TimePoint<? super TimeUnit, T>> T subtractFrom(T t2) {
            throw new AssertionError((Object)"Never called.");
        }
    }

    public static final class Formatter
    extends TimeSpanFormatter<TimeUnit, MachineTime<TimeUnit>> {
        private Formatter(String string) {
            super(TimeUnit.class, string);
        }

        public static Formatter ofPattern(String string) {
            return new Formatter(string);
        }

        @Override
        public void print(TimeSpan<? super TimeUnit> timeSpan, Appendable appendable) throws IOException {
            String string = this.getPattern();
            int n2 = string.length();
            StringBuilder stringBuilder = new StringBuilder(n2);
            block0: for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if (c2 == '\'') {
                    ++i2;
                    while (i2 < n2) {
                        if (string.charAt(i2) == '\'') {
                            if (i2 + 1 >= n2 || string.charAt(i2 + 1) != '\'') continue block0;
                            ++i2;
                        }
                        ++i2;
                    }
                    continue;
                }
                stringBuilder.append(c2);
            }
            String string2 = stringBuilder.toString();
            EnumSet<TimeUnit> enumSet = EnumSet.noneOf(TimeUnit.class);
            if (string2.contains("D")) {
                enumSet.add(TimeUnit.DAYS);
            }
            if (string2.contains("h")) {
                enumSet.add(TimeUnit.HOURS);
            }
            if (string2.contains("m")) {
                enumSet.add(TimeUnit.MINUTES);
            }
            if (string2.contains("s")) {
                enumSet.add(TimeUnit.SECONDS);
            }
            if (string2.contains("f")) {
                enumSet.add(TimeUnit.NANOSECONDS);
            }
            super.print(new Normalized(timeSpan, enumSet), appendable);
        }

        @Override
        protected MachineTime<TimeUnit> convert(Map<TimeUnit, Long> map, boolean bl2) {
            long l2 = 0L;
            int n2 = 0;
            if (map.containsKey((Object)TimeUnit.NANOSECONDS)) {
                n2 = MathUtils.safeCast(map.get((Object)TimeUnit.NANOSECONDS));
            }
            block6: for (Map.Entry<TimeUnit, Long> entry : map.entrySet()) {
                int n3;
                switch (entry.getKey()) {
                    case DAYS: {
                        n3 = 86400;
                        break;
                    }
                    case HOURS: {
                        n3 = 3600;
                        break;
                    }
                    case MINUTES: {
                        n3 = 60;
                        break;
                    }
                    case SECONDS: {
                        n3 = 1;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                l2 += MathUtils.safeMultiply(entry.getValue(), (long)n3);
            }
            if (bl2) {
                l2 = MathUtils.safeNegate(l2);
                n2 = -n2;
            }
            return MachineTime.ofPosixUnits(l2, n2);
        }

        @Override
        protected TimeUnit getUnit(char c2) {
            switch (c2) {
                case 'D': {
                    return TimeUnit.DAYS;
                }
                case 'h': {
                    return TimeUnit.HOURS;
                }
                case 'm': {
                    return TimeUnit.MINUTES;
                }
                case 's': {
                    return TimeUnit.SECONDS;
                }
                case 'f': {
                    return TimeUnit.NANOSECONDS;
                }
            }
            throw new IllegalArgumentException("Unsupported pattern symbol: " + c2);
        }
    }
}

