/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import net.time4j.AbstractDateElement;
import net.time4j.PlainDate;
import net.time4j.ProportionalElement;
import net.time4j.ProportionalFunction;
import net.time4j.RoundingOperator;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoOperator;

final class IntegerDateElement
extends AbstractDateElement<Integer>
implements ProportionalElement<Integer, PlainDate> {
    static final int YEAR = 14;
    static final int MONTH = 15;
    static final int DAY_OF_MONTH = 16;
    static final int DAY_OF_YEAR = 17;
    static final int DAY_OF_QUARTER = 18;
    private static final long serialVersionUID = -1337148214680014674L;
    private final transient int ruleIndex;
    private final transient Integer defaultMin;
    private final transient Integer defaultMax;
    private final transient char symbol;
    private final transient ChronoFunction<ChronoEntity<?>, BigDecimal> rf;

    private IntegerDateElement(String string, int n2, Integer n3, Integer n4, char c2) {
        super(string);
        this.ruleIndex = n2;
        this.defaultMin = n3;
        this.defaultMax = n4;
        this.symbol = c2;
        this.rf = new ProportionalFunction(this, false);
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    @Override
    public char getSymbol() {
        return this.symbol;
    }

    @Override
    public Integer getDefaultMinimum() {
        return this.defaultMin;
    }

    @Override
    public Integer getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public ChronoFunction<ChronoEntity<?>, BigDecimal> ratio() {
        return this.rf;
    }

    @Override
    public ChronoOperator<PlainDate> roundedUp(int n2) {
        return new RoundingOperator<PlainDate>(this, Boolean.TRUE, n2);
    }

    @Override
    public ChronoOperator<PlainDate> roundedHalf(int n2) {
        return new RoundingOperator<PlainDate>(this, null, n2);
    }

    @Override
    public ChronoOperator<PlainDate> roundedDown(int n2) {
        return new RoundingOperator<PlainDate>(this, Boolean.FALSE, n2);
    }

    @Override
    protected boolean isSingleton() {
        return true;
    }

    int getRuleIndex() {
        return this.ruleIndex;
    }

    static IntegerDateElement create(String string, int n2, int n3, int n4, char c2) {
        return new IntegerDateElement(string, n2, n3, n4, c2);
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainDate.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

